/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.action;

import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.SourcePageNotFoundException;
import net.sourceforge.stripes.util.HtmlUtil;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.ValidationError;

public class ValidationErrorReportResolution
implements Resolution {
    private static final Log log = Log.getInstance(ValidationErrorReportResolution.class);
    private ActionBeanContext context;

    public ValidationErrorReportResolution(ActionBeanContext context) {
        this.context = context;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        SourcePageNotFoundException exception = new SourcePageNotFoundException(this.getContext());
        log.error(exception, new Object[0]);
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        writer.println("<div style=\"font-family: Arial, sans-serif; font-size: 10pt;\">");
        writer.println("<h1>Stripes validation error report</h1><p>");
        writer.println(HtmlUtil.encode(exception.getMessage()));
        writer.println("</p><h2>Validation errors</h2><p>");
        this.sendErrors(request, response);
        writer.println("</p></div>");
    }

    protected void sendErrors(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        ResourceBundle bundle = null;
        try {
            bundle = StripesFilter.getConfiguration().getLocalizationBundleFactory().getErrorMessageBundle(locale);
        }
        catch (MissingResourceException mre) {
            log.warn(this.getClass().getName(), " could not find the error messages resource bundle. ", "As a result default headers/footers etc. will be used. Check that ", "you have a StripesResources.properties in your classpath (unless ", "of course you have configured a different bundle).");
        }
        String header = this.getResource(bundle, "header", "<div class=\"errorHeader\">Validation Errors</div><ul>");
        String footer = this.getResource(bundle, "footer", "</ul>");
        String openElement = this.getResource(bundle, "beforeError", "<li>");
        String closeElement = this.getResource(bundle, "afterError", "</li>");
        PrintWriter writer = response.getWriter();
        writer.write(header);
        for (List list : this.getContext().getValidationErrors().values()) {
            for (ValidationError fieldError : list) {
                writer.write(openElement);
                writer.write(HtmlUtil.encode(fieldError.getMessage(locale)));
                writer.write(closeElement);
            }
        }
        writer.write(footer);
    }

    protected String getResource(ResourceBundle bundle, String name, String fallback) {
        String resource;
        if (bundle == null) {
            return fallback;
        }
        try {
            resource = bundle.getString("stripes.errors." + name);
        }
        catch (MissingResourceException mre) {
            resource = fallback;
        }
        return resource;
    }
}

