/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.config;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.FilterConfig;
import net.sourceforge.stripes.config.DontAutoLoad;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.ReflectUtil;
import net.sourceforge.stripes.util.ResolverUtil;
import net.sourceforge.stripes.util.StringUtil;
import net.sourceforge.stripes.vfs.VFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapPropertyResolver {
    private static final Log log = Log.getInstance(BootstrapPropertyResolver.class);
    private FilterConfig filterConfig;
    public static final String VFS_CLASSES = "VFS.Classes";
    public static final String PACKAGES = "Extension.Packages";

    public BootstrapPropertyResolver(FilterConfig filterConfig) {
        this.setFilterConfig(filterConfig);
        this.initVFS();
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected void initVFS() {
        List<Class<?>> vfsImpls = this.getClassPropertyList(VFS_CLASSES);
        for (Class<?> clazz : vfsImpls) {
            if (!VFS.class.isAssignableFrom(clazz)) {
                log.warn("Class ", clazz.getName(), " does not extend ", VFS.class.getName());
                continue;
            }
            VFS.addImplClass(clazz);
        }
    }

    public String getProperty(String key) {
        String value = null;
        try {
            value = this.filterConfig.getInitParameter(key);
        }
        catch (AccessControlException e) {
            log.debug("Security manager prevented " + this.getClass().getName() + " from reading filter init-param" + key);
        }
        if (value == null) {
            try {
                value = this.filterConfig.getServletContext().getInitParameter(key);
            }
            catch (AccessControlException e) {
                log.debug("Security manager prevented " + this.getClass().getName() + " from reading servlet context init-param" + key);
            }
        }
        if (value == null) {
            try {
                value = System.getProperty(key);
            }
            catch (AccessControlException e) {
                log.debug("Security manager prevented " + this.getClass().getName() + " from reading system property " + key);
            }
        }
        return value;
    }

    public <T> Class<? extends T> getClassProperty(String paramName, Class<T> targetType) {
        Class<T> clazz = null;
        String className = this.getProperty(paramName);
        if (className != null) {
            try {
                clazz = ReflectUtil.findClass(className);
                log.info("Class implementing/extending ", targetType.getSimpleName(), " found in web.xml: ", className);
            }
            catch (ClassNotFoundException e) {
                log.error("Couldn't find class specified in web.xml under param ", paramName, ": ", className);
            }
        } else {
            ResolverUtil resolver = new ResolverUtil();
            String[] packages = StringUtil.standardSplit(this.getProperty(PACKAGES));
            resolver.findImplementations(targetType, packages);
            Set<Class<T>> classes = resolver.getClasses();
            this.removeDontAutoloadClasses(classes);
            this.removeAbstractClasses(classes);
            if (classes.size() == 1) {
                clazz = classes.iterator().next();
                className = clazz.getName();
                log.info("Class implementing/extending ", targetType.getSimpleName(), " found via auto-discovery: ", className);
            } else if (classes.size() > 1) {
                throw new StripesRuntimeException(StringUtil.combineParts("Found too many classes implementing/extending ", targetType.getSimpleName(), ": ", classes));
            }
        }
        return clazz;
    }

    public List<Class<?>> getClassPropertyList(String paramName) {
        ArrayList classes = new ArrayList();
        String classList = this.getProperty(paramName);
        if (classList != null) {
            String[] classNames;
            for (String className : classNames = StringUtil.standardSplit(classList)) {
                className = className.trim();
                try {
                    classes.add(ReflectUtil.findClass(className));
                }
                catch (ClassNotFoundException e) {
                    throw new StripesRuntimeException("Could not find class [" + className + "] specified by the configuration parameter [" + paramName + "]. This value must contain fully qualified class names separated " + " by commas.");
                }
            }
        }
        return classes;
    }

    public <T> List<Class<? extends T>> getClassPropertyList(Class<T> targetType) {
        ResolverUtil resolver = new ResolverUtil();
        String[] packages = StringUtil.standardSplit(this.getProperty(PACKAGES));
        resolver.findImplementations(targetType, packages);
        Set<Class<? extends T>> classes = resolver.getClasses();
        this.removeDontAutoloadClasses(classes);
        this.removeAbstractClasses(classes);
        return new ArrayList<Class<? extends T>>(classes);
    }

    public <T> List<Class<? extends T>> getClassPropertyList(String paramName, Class<T> targetType) {
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        for (Class<?> clazz : this.getClassPropertyList(paramName)) {
            classes.add(clazz);
        }
        classes.addAll(this.getClassPropertyList(targetType));
        return classes;
    }

    protected <T> void removeDontAutoloadClasses(Collection<Class<? extends T>> classes) {
        Iterator<Class<T>> iterator = classes.iterator();
        while (iterator.hasNext()) {
            Class<T> clazz = iterator.next();
            if (!clazz.isAnnotationPresent(DontAutoLoad.class)) continue;
            log.debug("Ignoring ", clazz, " because @DontAutoLoad is present.");
            iterator.remove();
        }
    }

    protected <T> void removeAbstractClasses(Collection<Class<? extends T>> classes) {
        Iterator<Class<T>> iterator = classes.iterator();
        while (iterator.hasNext()) {
            Class<T> clazz = iterator.next();
            if (clazz.isInterface()) {
                log.trace("Ignoring ", clazz, " because it is an interface.");
                iterator.remove();
                continue;
            }
            if ((clazz.getModifiers() & 0x400) != 1024) continue;
            log.trace("Ignoring ", clazz, " because it is abstract.");
            iterator.remove();
        }
    }
}

