/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.SessionScope;
import net.sourceforge.stripes.config.BootstrapPropertyResolver;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.config.DontAutoLoad;
import net.sourceforge.stripes.controller.ActionResolver;
import net.sourceforge.stripes.controller.StripesRequestWrapper;
import net.sourceforge.stripes.controller.UrlBinding;
import net.sourceforge.stripes.controller.UrlBindingFactory;
import net.sourceforge.stripes.exception.ActionBeanNotFoundException;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.HttpUtil;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.ResolverUtil;
import net.sourceforge.stripes.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedClassActionResolver
implements ActionResolver {
    @Deprecated
    private static final String URL_FILTERS = "ActionResolver.UrlFilters";
    @Deprecated
    private static final String PACKAGE_FILTERS = "ActionResolver.PackageFilters";
    public static final String PACKAGES = "ActionResolver.Packages";
    private static final String DEFAULT_HANDLER_KEY = "__default_handler";
    private static final Log log = Log.getInstance(AnnotatedClassActionResolver.class);
    private Configuration configuration;
    private UrlBindingFactory urlBindingFactory = new UrlBindingFactory();
    private Map<Class<? extends ActionBean>, Map<String, Method>> eventMappings = new HashMap<Class<? extends ActionBean>, Map<String, Method>>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Map<String, Method> get(Object key) {
            Map value = (Map)super.get(key);
            if (value == null) {
                return Collections.emptyMap();
            }
            return value;
        }
    };

    @Override
    public void init(Configuration configuration) throws Exception {
        this.configuration = configuration;
        for (Class<? extends ActionBean> clazz : this.findClasses()) {
            this.addActionBean(clazz);
        }
    }

    public UrlBindingFactory getUrlBindingFactory() {
        return this.urlBindingFactory;
    }

    protected void addActionBean(Class<? extends ActionBean> clazz) {
        if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isAnnotationPresent(DontAutoLoad.class)) {
            return;
        }
        String binding = this.getUrlBinding(clazz);
        if (binding == null) {
            return;
        }
        UrlBinding proto = this.getUrlBindingFactory().getBindingPrototype(clazz);
        if (proto == null) {
            this.getUrlBindingFactory().addBinding(clazz, new UrlBinding(clazz, binding));
        }
        HashMap<String, Method> classMappings = new HashMap<String, Method>();
        this.processMethods(clazz, classMappings);
        this.eventMappings.put(clazz, classMappings);
        if (log.getRealLog().isDebugEnabled()) {
            for (Map.Entry entry : classMappings.entrySet()) {
                String event = (String)entry.getKey();
                Method handler = (Method)entry.getValue();
                boolean isDefault = DEFAULT_HANDLER_KEY.equals(event);
                log.debug("Bound: ", clazz.getSimpleName(), ".", handler.getName(), "() ==> ", binding, isDefault ? "" : "?" + event);
            }
        }
    }

    protected void removeActionBean(Class<? extends ActionBean> clazz) {
        String binding = this.getUrlBinding(clazz);
        if (binding != null) {
            this.getUrlBindingFactory().removeBinding(clazz);
        }
        this.eventMappings.remove(clazz);
    }

    @Override
    public String getUrlBindingFromPath(String path) {
        UrlBinding mapping = this.getUrlBindingFactory().getBindingPrototype(path);
        return mapping == null ? null : mapping.toString();
    }

    @Override
    public String getUrlBinding(Class<? extends ActionBean> clazz) {
        UrlBinding mapping = this.getUrlBindingFactory().getBindingPrototype(clazz);
        return mapping == null ? null : mapping.toString();
    }

    protected void processMethods(Class<?> clazz, Map<String, Method> classMappings) {
        Method[] methods;
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            this.processMethods(superclass, classMappings);
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || method.isBridge()) continue;
            String eventName = this.getHandledEvent(method);
            if (classMappings.containsKey(eventName) && clazz.equals(classMappings.get(eventName).getDeclaringClass())) {
                throw new StripesRuntimeException("The ActionBean " + clazz + " declares multiple event handlers for event '" + eventName + "'");
            }
            DefaultHandler defaultMapping = method.getAnnotation(DefaultHandler.class);
            if (eventName != null) {
                classMappings.put(eventName, method);
            }
            if (defaultMapping == null) continue;
            if (classMappings.containsKey(DEFAULT_HANDLER_KEY) && clazz.equals(classMappings.get(DEFAULT_HANDLER_KEY).getDeclaringClass())) {
                throw new StripesRuntimeException("The ActionBean " + clazz + " declares multiple default event handlers");
            }
            classMappings.put(DEFAULT_HANDLER_KEY, method);
        }
    }

    @Override
    public String getHandledEvent(Method handler) {
        HandlesEvent mapping = handler.getAnnotation(HandlesEvent.class);
        if (mapping != null) {
            return mapping.value();
        }
        return null;
    }

    @Override
    public Class<? extends ActionBean> getActionBeanType(String path) {
        UrlBinding binding = this.getUrlBindingFactory().getBindingPrototype(path);
        return binding == null ? null : binding.getBeanType();
    }

    @Override
    public ActionBean getActionBean(ActionBeanContext context) throws StripesServletException {
        HttpServletRequest request = context.getRequest();
        String path = HttpUtil.getRequestedPath(request);
        ActionBean bean = this.getActionBean(context, path);
        request.setAttribute("__stripes_resolved_action", (Object)this.getUrlBindingFromPath(path));
        return bean;
    }

    @Deprecated
    protected String getRequestedPath(HttpServletRequest request) {
        String servletPath = null;
        String pathInfo = null;
        if (request.getAttribute("javax.servlet.include.servlet_path") != null) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
        } else {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        return (servletPath == null ? "" : servletPath) + (pathInfo == null ? "" : pathInfo);
    }

    @Override
    public ActionBean getActionBean(ActionBeanContext context, String path) throws StripesServletException {
        ActionBean bean;
        Class<? extends ActionBean> beanClass = this.getActionBeanType(path);
        if (beanClass == null) {
            throw new ActionBeanNotFoundException(path, this.getUrlBindingFactory().getPathMap());
        }
        String bindingPath = this.getUrlBinding(beanClass);
        try {
            HttpServletRequest request = context.getRequest();
            if (beanClass.isAnnotationPresent(SessionScope.class)) {
                bean = (ActionBean)request.getSession().getAttribute(bindingPath);
                if (bean == null) {
                    bean = this.makeNewActionBean(beanClass, context);
                    request.getSession().setAttribute(bindingPath, (Object)bean);
                }
            } else {
                bean = (ActionBean)request.getAttribute(bindingPath);
                if (bean == null) {
                    bean = this.makeNewActionBean(beanClass, context);
                    request.setAttribute(bindingPath, (Object)bean);
                }
            }
            this.setActionBeanContext(bean, context);
        }
        catch (Exception e) {
            StripesServletException sse = new StripesServletException("Could not create instance of ActionBean type [" + beanClass.getName() + "].", e);
            log.error((Throwable)((Object)sse), new Object[0]);
            throw sse;
        }
        this.assertGetContextWorks(bean);
        return bean;
    }

    protected void setActionBeanContext(ActionBean bean, ActionBeanContext context) {
        ActionBeanContext abcFromBean = bean.getContext();
        if (abcFromBean == null) {
            bean.setContext(context);
        } else {
            StripesRequestWrapper wrapperFromRequest;
            StripesRequestWrapper wrapperFromBean = StripesRequestWrapper.findStripesWrapper((ServletRequest)abcFromBean.getRequest());
            if (wrapperFromBean != (wrapperFromRequest = StripesRequestWrapper.findStripesWrapper((ServletRequest)context.getRequest()))) {
                bean.setContext(context);
            }
        }
    }

    protected void assertGetContextWorks(ActionBean bean) throws StripesServletException {
        if (bean.getContext() == null) {
            throw new StripesServletException("Ahem. Stripes has just resolved and instantiated the ActionBean class " + bean.getClass().getName() + " and set the ActionBeanContext " + "on it. However calling getContext() isn't returning the context back! Since " + "this is required for several parts of Stripes to function correctly you should " + "now stop and implement setContext()/getContext() correctly. Thank you.");
        }
    }

    protected ActionBean makeNewActionBean(Class<? extends ActionBean> type, ActionBeanContext context) throws Exception {
        return type.newInstance();
    }

    @Override
    public String getEventName(Class<? extends ActionBean> bean, ActionBeanContext context) {
        String event = this.getEventNameFromRequestAttribute(bean, context);
        if (event == null) {
            event = this.getEventNameFromEventNameParam(bean, context);
        }
        if (event == null) {
            event = this.getEventNameFromRequestParams(bean, context);
        }
        if (event == null) {
            event = this.getEventNameFromPath(bean, context);
        }
        return event;
    }

    protected String getEventNameFromRequestAttribute(Class<? extends ActionBean> bean, ActionBeanContext context) {
        return (String)context.getRequest().getAttribute("__stripes_event_name");
    }

    protected String getEventNameFromRequestParams(Class<? extends ActionBean> bean, ActionBeanContext context) {
        ArrayList<String> eventParams = new ArrayList<String>();
        Map parameterMap = context.getRequest().getParameterMap();
        for (String event : this.eventMappings.get(bean).keySet()) {
            if (!parameterMap.containsKey(event) && !parameterMap.containsKey(event + ".x")) continue;
            eventParams.add(event);
        }
        if (eventParams.size() == 0) {
            return null;
        }
        if (eventParams.size() == 1) {
            return (String)eventParams.get(0);
        }
        throw new StripesRuntimeException("Multiple event parameters " + eventParams + " are present in this request. Only one event parameter may be specified " + "per request. Otherwise, Stripes would be unable to determine which event " + "to execute.");
    }

    protected String getEventNameFromPath(Class<? extends ActionBean> bean, ActionBeanContext context) {
        int index;
        String extra;
        String event;
        String binding;
        Map<String, Method> mappings = this.eventMappings.get(bean);
        String path = HttpUtil.getRequestedPath(context.getRequest());
        UrlBinding prototype = this.getUrlBindingFactory().getBindingPrototype(path);
        String string = binding = prototype == null ? null : prototype.getPath();
        if (binding != null && path.length() != binding.length() && mappings.containsKey(event = extra.substring(0, (index = (extra = path.substring(binding.length() + 1)).indexOf("/")) != -1 ? index : extra.length()))) {
            return event;
        }
        return null;
    }

    protected String getEventNameFromEventNameParam(Class<? extends ActionBean> bean, ActionBeanContext context) {
        String[] values = context.getRequest().getParameterValues("_eventName");
        String event = null;
        if (values != null && values.length == 1 && this.eventMappings.get(bean).containsKey(values[0])) {
            event = values[0];
        }
        if (event != null) {
            try {
                String otherName = this.getEventNameFromRequestParams(bean, context);
                if (otherName != null && !otherName.equals(event)) {
                    Object[] otherValue = context.getRequest().getParameterValues(otherName);
                    log.warn("The event name was specified by two request parameters: ", "_eventName", "=", event, " and ", otherName, "=", Arrays.toString(otherValue), ". ", "As of Stripes 1.5, ", "_eventName", " overrides all other request parameters.");
                }
            }
            catch (StripesRuntimeException e) {
                // empty catch block
            }
        }
        return event;
    }

    @Override
    public Method getHandler(Class<? extends ActionBean> bean, String eventName) throws StripesServletException {
        Map<String, Method> mappings = this.eventMappings.get(bean);
        Method handler = mappings.get(eventName);
        if (handler == null) {
            throw new StripesServletException("Could not find handler method for event name [" + eventName + "] on class [" + bean.getName() + "].  Known handler mappings are: " + mappings);
        }
        return handler;
    }

    @Override
    public Method getDefaultHandler(Class<? extends ActionBean> bean) throws StripesServletException {
        Map<String, Method> handlers = this.eventMappings.get(bean);
        if (handlers.size() == 1) {
            return handlers.values().iterator().next();
        }
        Method handler = handlers.get(DEFAULT_HANDLER_KEY);
        if (handler != null) {
            return handler;
        }
        throw new StripesServletException("No default handler could be found for ActionBean of type: " + bean.getName());
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected Set<Class<? extends ActionBean>> findClasses() {
        String packages;
        BootstrapPropertyResolver bootstrap = this.getConfiguration().getBootstrapPropertyResolver();
        if (bootstrap.getProperty(URL_FILTERS) != null || bootstrap.getProperty(PACKAGE_FILTERS) != null) {
            log.error("The configuration properties '", URL_FILTERS, "' and '", PACKAGE_FILTERS, "' are deprecated, and NO LONGER SUPPORTED. Please read the upgrade ", "documentation for Stripes 1.5 for how to resolve this situation. In short ", "you should specify neither ", URL_FILTERS, " or ", PACKAGE_FILTERS, ". Instead you should specify a comma separated list of package roots ", "(e.g. com.myco.web) that should be scanned for implementations of ", "ActionBean, using the configuration parameter '", PACKAGES, "'.");
        }
        if ((packages = bootstrap.getProperty(PACKAGES)) == null) {
            throw new StripesRuntimeException("You must supply a value for the configuration parameter 'ActionResolver.Packages'. The value should be a list of one or more package roots (comma separated) that are to be scanned for ActionBean implementations. The packages specified and all subpackages are examined for implementations of ActionBean.");
        }
        String[] pkgs = StringUtil.standardSplit(packages);
        ResolverUtil resolver = new ResolverUtil();
        resolver.findImplementations(ActionBean.class, pkgs);
        return resolver.getClasses();
    }

    @Override
    public Collection<Class<? extends ActionBean>> getActionBeanClasses() {
        return this.getUrlBindingFactory().getActionBeanClasses();
    }
}

