/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.HttpCache;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.controller.ExecutionContext;
import net.sourceforge.stripes.controller.Interceptor;
import net.sourceforge.stripes.controller.Intercepts;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Intercepts(value={LifecycleStage.ResolutionExecution})
public class HttpCacheInterceptor
implements Interceptor {
    private static final Log logger = Log.getInstance(HttpCacheInterceptor.class);
    private Map<CacheKey, HttpCache> cache = new HashMap<CacheKey, HttpCache>(128);

    @Override
    public Resolution intercept(ExecutionContext ctx) throws Exception {
        ActionBean actionBean = ctx.getActionBean();
        Method handler = ctx.getHandler();
        if (actionBean != null && handler != null) {
            Class<?> beanClass = actionBean.getClass();
            logger.debug("Looking for ", HttpCache.class.getSimpleName(), " on ", beanClass.getName(), ".", handler.getName(), "()");
            HttpCache annotation = this.getAnnotation(handler, beanClass);
            if (annotation != null) {
                HttpServletResponse response = ctx.getActionBeanContext().getResponse();
                if (annotation.allow()) {
                    long expires = annotation.expires();
                    if (expires != Integer.MIN_VALUE) {
                        logger.debug("Response expires in ", expires, " seconds");
                        expires = expires * 1000L + System.currentTimeMillis();
                        response.setDateHeader("Expires", expires);
                    }
                } else {
                    logger.debug("Disabling client-side caching for response");
                    response.setDateHeader("Expires", 0L);
                    response.setHeader("Cache-control", "no-store, no-cache, must-revalidate");
                    response.setHeader("Pragma", "no-cache");
                }
            }
        }
        return ctx.proceed();
    }

    protected HttpCache getAnnotation(Method method, Class<? extends ActionBean> beanClass) {
        CacheKey cacheKey = new CacheKey(method, beanClass);
        if (this.cache.containsKey(cacheKey)) {
            HttpCache annotation = this.cache.get(cacheKey);
            return annotation;
        }
        HttpCache annotation = method.getAnnotation(HttpCache.class);
        if (annotation == null) {
            Class<? extends ActionBean> clazz = beanClass;
            do {
                annotation = clazz.getAnnotation(HttpCache.class);
            } while ((clazz = clazz.getSuperclass()) != null && annotation == null);
        }
        if (annotation != null) {
            logger.debug("Found ", HttpCache.class.getSimpleName(), " for ", beanClass.getName(), ".", method.getName(), "()");
            int expires = annotation.expires();
            if (annotation.allow() && expires != Integer.MIN_VALUE && expires < 0) {
                logger.warn(HttpCache.class.getSimpleName(), " for ", beanClass.getName(), ".", method.getName(), "() allows caching but expires in the past");
            } else if (!annotation.allow() && expires != Integer.MIN_VALUE) {
                logger.warn(HttpCache.class.getSimpleName(), " for ", beanClass.getName(), ".", method.getName(), "() disables caching but explicitly sets expires");
            }
        }
        this.cache.put(cacheKey, annotation);
        return annotation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CacheKey {
        private Method method;
        private Class<?> beanClass;
        private int hashCode;

        public CacheKey(Method method, Class<? extends ActionBean> beanClass) {
            this.method = method;
            this.beanClass = beanClass;
            this.hashCode = method.hashCode() * 37 + beanClass.hashCode();
        }

        public boolean equals(Object obj) {
            CacheKey that = (CacheKey)obj;
            return this.method.equals(that.method) && this.beanClass.equals(that.beanClass);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.beanClass.getName() + "." + this.method.getName() + "()";
        }
    }
}

