/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.sourceforge.stripes.controller.ActionResolver;
import net.sourceforge.stripes.controller.AnnotatedClassActionResolver;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.controller.UrlBinding;
import net.sourceforge.stripes.controller.UrlBindingParameter;
import net.sourceforge.stripes.controller.multipart.MultipartWrapper;
import net.sourceforge.stripes.exception.UrlBindingConflictException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MergedParameterMap
implements Map<String, String[]> {
    private HttpServletRequestWrapper request;
    private Map<String, String[]> uriParams;
    private Stack<Map<String, String[]>> uriParamStack;

    MergedParameterMap(HttpServletRequestWrapper request) {
        this.request = request;
        this.uriParams = this.getUriParameters((HttpServletRequest)request);
        if (this.uriParams == null) {
            this.uriParams = Collections.emptyMap();
        }
    }

    MergedParameterMap(HttpServletRequestWrapper request, MultipartWrapper multipart) {
        this.request = request;
        Map<String, String[]> uriParams = this.getUriParameters((HttpServletRequest)request);
        LinkedHashMap<String, String[]> multipartParams = null;
        Enumeration<String> names = multipart.getParameterNames();
        if (names != null && names.hasMoreElements()) {
            multipartParams = new LinkedHashMap<String, String[]>();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                multipartParams.put(name, multipart.getParameterValues(name));
            }
        }
        this.uriParams = uriParams == null && multipartParams == null ? Collections.emptyMap() : this.mergeParameters(uriParams, multipartParams);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getParameterMap().containsKey(key) || this.uriParams.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getParameterMap().containsValue(value) || this.uriParams.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String[]>> entrySet() {
        LinkedHashSet<Map.Entry<String, String[]>> entries = new LinkedHashSet<Map.Entry<String, String[]>>();
        for (String key : this.keySet()) {
            entries.add(new Entry(key));
        }
        return entries;
    }

    @Override
    public String[] get(Object key) {
        if (key == null) {
            return null;
        }
        return this.mergeParameters(this.getParameterMap().get(key), this.uriParams.get(key));
    }

    @Override
    public boolean isEmpty() {
        return this.getParameterMap().isEmpty() && this.uriParams.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> merged = new LinkedHashSet<String>();
        merged.addAll(this.uriParams.keySet());
        merged.addAll(this.getParameterMap().keySet());
        return merged;
    }

    @Override
    public String[] put(String key, String[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String[]> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Collection<String[]> values() {
        Set<String> keys = this.keySet();
        ArrayList<String[]> merged = new ArrayList<String[]>(keys.size());
        for (String key : keys) {
            merged.add(this.mergeParameters(this.getParameterMap().get(key), this.uriParams.get(key)));
        }
        return merged;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("{ ");
        for (Map.Entry<String, String[]> entry : this.entrySet()) {
            buf.append(entry).append(", ");
        }
        if (buf.toString().endsWith(", ")) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(" }");
        return buf.toString();
    }

    Map<String, String[]> getParameterMap() {
        return this.request == null ? Collections.emptyMap() : this.request.getRequest().getParameterMap();
    }

    void pushUriParameters(HttpServletRequestWrapper request) {
        if (this.uriParamStack == null) {
            this.uriParamStack = new Stack();
        }
        Map<String, String[]> map = this.getUriParameters((HttpServletRequest)request);
        this.uriParamStack.push(this.uriParams);
        this.uriParams = this.mergeParameters(new LinkedHashMap<String, String[]>(this.uriParams), map);
    }

    void popUriParameters() {
        this.uriParams = this.uriParamStack == null || this.uriParamStack.isEmpty() ? null : this.uriParamStack.pop();
    }

    Map<String, String[]> getUriParameters(HttpServletRequest request) {
        ActionResolver resolver = StripesFilter.getConfiguration().getActionResolver();
        if (!(resolver instanceof AnnotatedClassActionResolver)) {
            return null;
        }
        UrlBinding binding = null;
        try {
            binding = ((AnnotatedClassActionResolver)resolver).getUrlBindingFactory().getBinding(request);
        }
        catch (UrlBindingConflictException e) {
            // empty catch block
        }
        LinkedHashMap<String, String[]> params = null;
        if (binding != null && binding.getParameters().size() > 0) {
            for (UrlBindingParameter p : binding.getParameters()) {
                String[] values;
                String name = p.getName();
                if (name == null) continue;
                String value = p.getValue();
                if ("$event".equals(name)) {
                    if (value == null) continue;
                    name = value;
                    value = "";
                }
                if (value == null && request.getParameterValues(name) == null) {
                    value = p.getDefaultValue();
                }
                if (value == null) continue;
                if (params == null) {
                    params = new LinkedHashMap<String, String[]>();
                }
                if ((values = (String[])params.get(name)) == null) {
                    values = new String[]{value};
                } else {
                    String[] tmp = new String[values.length + 1];
                    System.arraycopy(values, 0, tmp, 0, values.length);
                    tmp[tmp.length - 1] = value;
                    values = tmp;
                }
                params.put(name, values);
            }
        }
        return params;
    }

    Map<String, String[]> mergeParameters(Map<String, String[]> target, Map<String, String[]> source) {
        if (target == null) {
            target = new LinkedHashMap<String, String[]>();
        }
        if (source == null || source.isEmpty()) {
            return target;
        }
        for (Map.Entry<String, String[]> entry : target.entrySet()) {
            entry.setValue(this.mergeParameters(entry.getValue(), source.get(entry.getKey())));
        }
        for (Map.Entry<String, String[]> entry : source.entrySet()) {
            if (target.containsKey(entry.getKey())) continue;
            target.put(entry.getKey(), entry.getValue());
        }
        return target;
    }

    String[] mergeParameters(String[] requestParams, String[] uriParams) {
        if (requestParams == null || requestParams.length == 0) {
            if (uriParams == null || uriParams.length == 0) {
                return null;
            }
            return uriParams;
        }
        if (uriParams == null || uriParams.length == 0) {
            return requestParams;
        }
        String[] merged = new String[uriParams.length + requestParams.length];
        System.arraycopy(uriParams, 0, merged, 0, uriParams.length);
        System.arraycopy(requestParams, 0, merged, uriParams.length, requestParams.length);
        return merged;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Entry
    implements Map.Entry<String, String[]> {
        private String key;

        Entry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String[] getValue() {
            return MergedParameterMap.this.get(this.key);
        }

        @Override
        public String[] setValue(String[] value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            Entry that = (Entry)obj;
            return this.key == that.key;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return "" + this.key + "=" + Arrays.deepToString(this.getValue());
        }
    }
}

