/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.UrlBindingParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlBinding {
    protected Class<? extends ActionBean> beanType;
    protected String path;
    protected String suffix;
    protected List<Object> components;
    protected List<UrlBindingParameter> parameters;

    public UrlBinding(Class<? extends ActionBean> beanType, String path, List<Object> components) {
        this.beanType = beanType;
        this.path = path;
        if (components != null && !components.isEmpty()) {
            Object last;
            this.components = Collections.unmodifiableList(components);
            this.parameters = new ArrayList<UrlBindingParameter>(components.size());
            for (Object component : components) {
                if (!(component instanceof UrlBindingParameter)) continue;
                this.parameters.add((UrlBindingParameter)component);
            }
            if (!this.parameters.isEmpty() && (last = components.get(components.size() - 1)) instanceof String) {
                this.suffix = (String)last;
            }
        } else {
            this.components = Collections.emptyList();
            this.parameters = Collections.emptyList();
        }
    }

    public UrlBinding(Class<? extends ActionBean> beanType, String path) {
        this.beanType = beanType;
        this.path = path;
        this.components = Collections.emptyList();
        this.parameters = Collections.emptyList();
    }

    public Class<? extends ActionBean> getBeanType() {
        return this.beanType;
    }

    public List<Object> getComponents() {
        return this.components;
    }

    public List<UrlBindingParameter> getParameters() {
        return this.parameters;
    }

    public String getPath() {
        return this.path;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UrlBinding)) {
            return false;
        }
        UrlBinding that = (UrlBinding)obj;
        return this.getBeanType() == that.getBeanType() && ((Object)this.getComponents()).equals(that.getComponents());
    }

    public int hashCode() {
        return this.getPath() == null ? 0 : this.getPath().hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64).append(this.getPath());
        for (Object component : this.getComponents()) {
            if (component instanceof UrlBindingParameter) {
                buf.append('{').append(component).append('}');
                continue;
            }
            buf.append(component);
        }
        return buf.toString();
    }
}

