/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.lang.reflect.Method;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.controller.StripesFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlBindingParameter {
    public static final String PARAMETER_NAME_EVENT = "$event";
    protected Class<? extends ActionBean> beanClass;
    protected String name;
    protected String value;
    protected String defaultValue;

    public UrlBindingParameter(Class<? extends ActionBean> beanClass, String name, String value) {
        this(beanClass, name, value, null);
    }

    public UrlBindingParameter(Class<? extends ActionBean> beanClass, String name, String value, String defaultValue) {
        this.beanClass = beanClass;
        this.name = name;
        this.value = value;
        this.defaultValue = defaultValue;
    }

    public UrlBindingParameter(UrlBindingParameter prototype) {
        this(prototype.beanClass, prototype.name, prototype.value, prototype.defaultValue);
    }

    public UrlBindingParameter(UrlBindingParameter prototype, String value) {
        this(prototype.beanClass, prototype.name, value, prototype.defaultValue);
    }

    public Class<? extends ActionBean> getBeanClass() {
        return this.beanClass;
    }

    public String getDefaultValue() {
        if (this.defaultValue == null && PARAMETER_NAME_EVENT.equals(this.name)) {
            try {
                Method defaultHandler = StripesFilter.getConfiguration().getActionResolver().getDefaultHandler(this.beanClass);
                HandlesEvent annotation = defaultHandler.getAnnotation(HandlesEvent.class);
                this.defaultValue = annotation != null ? annotation.value() : defaultHandler.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UrlBindingParameter)) {
            return false;
        }
        UrlBindingParameter that = (UrlBindingParameter)o;
        return this.value == null ? that.value == null : this.value.equals(that.value);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        if (this.defaultValue == null) {
            return this.name;
        }
        return this.name + "=" + this.defaultValue;
    }
}

