/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.mock;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.mock.MockServletOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpServletResponse
implements HttpServletResponse {
    private MockServletOutputStream out = new MockServletOutputStream();
    private PrintWriter writer = new PrintWriter((OutputStream)((Object)this.out), true);
    private Locale locale = Locale.getDefault();
    private Map<String, List<Object>> headers = new HashMap<String, List<Object>>();
    private List<Cookie> cookies = new ArrayList<Cookie>();
    private int status = 200;
    private String errorMessage;
    private String characterEncoding = "UTF-8";
    private int contentLength;
    private String contentType;
    private String redirectUrl;

    public MockHttpServletResponse() {
        this.setContentType("text/html");
    }

    public void addCookie(Cookie cookie) {
        ListIterator<Cookie> iterator = this.cookies.listIterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getName().equals(cookie.getName())) continue;
            iterator.remove();
        }
        this.cookies.add(cookie);
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }

    public void sendError(int status, String errorMessage) throws IOException {
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public void sendError(int status) throws IOException {
        this.status = status;
    }

    public void sendRedirect(String url) throws IOException {
        this.status = 302;
        this.redirectUrl = url;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setDateHeader(String name, long value) {
        this.headers.remove(name);
        this.addDateHeader(name, value);
    }

    public void addDateHeader(String name, long value) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    public void setHeader(String name, String value) {
        this.headers.remove(name);
        this.addHeader(name, value);
    }

    public void addHeader(String name, String value) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.remove(name);
        this.addIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        List<Object> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    public Map<String, List<Object>> getHeaderMap() {
        return this.headers;
    }

    public void setStatus(int statusCode) {
        this.status = statusCode;
    }

    public void setStatus(int status, String errorMessage) {
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public int getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        this.getHeaderMap().put("Content-type", Collections.singletonList(contentType));
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public byte[] getOutputBytes() {
        this.writer.flush();
        return this.out.getBytes();
    }

    public String getOutputString() {
        this.writer.flush();
        return this.out.getString();
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setBufferSize(int i) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
        throw new IllegalStateException("reset() is not supported");
    }

    public boolean isCommitted() {
        return true;
    }

    public void reset() {
        throw new IllegalStateException("reset() is not supported");
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

