/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTag;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.ajax.JavaScriptBuilder;
import net.sourceforge.stripes.controller.ParameterName;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.localization.LocalizationUtility;
import net.sourceforge.stripes.tag.FormTag;
import net.sourceforge.stripes.tag.HtmlTagSupport;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.bean.PropertyExpression;
import net.sourceforge.stripes.util.bean.PropertyExpressionEvaluation;
import net.sourceforge.stripes.validation.ValidationMetadata;
import net.sourceforge.stripes.validation.ValidationMetadataProvider;

public class FieldMetadataTag
extends HtmlTagSupport
implements BodyTag {
    private static final Log log = Log.getInstance(FormTag.class);
    private String var;
    private String fields;
    private boolean includeType = false;
    private boolean fqn = false;
    private String actionWithoutContext;

    public FormTag getForm() {
        return this.getParentTag(FormTag.class);
    }

    private String getMetadata() {
        ActionBean bean = null;
        String action = this.getAction();
        FormTag form = this.getForm();
        if (form != null) {
            if (action != null) {
                log.warn("Parameters action and/or beanclass specified but field-metadata tag is inside of a Stripes form tag. The bean will be pulled from the form tag.");
            }
            action = form.getAction();
        }
        if (form != null) {
            bean = form.getActionBean();
        }
        Class<Object> beanClass = null;
        if (bean != null) {
            beanClass = bean.getClass();
        } else if (action != null && (beanClass = StripesFilter.getConfiguration().getActionResolver().getActionBeanType(action)) != null) {
            try {
                bean = (ActionBean)beanClass.newInstance();
            }
            catch (Exception e) {
                log.error(e, new Object[0]);
                return null;
            }
        }
        if (beanClass == null) {
            log.error("Couldn't determine ActionBean class from FormTag! One of the following conditions must be met:\r\n\t", "1. Include this tag inside of a stripes:form tag\r\n\t", "2. Use the action parameter\r\n\t", "3. Use the beanclass parameter");
            return null;
        }
        ValidationMetadataProvider metadataProvider = StripesFilter.getConfiguration().getValidationMetadataProvider();
        if (metadataProvider == null) {
            log.error("Couldn't get ValidationMetadataProvider!");
            return null;
        }
        Map<String, ValidationMetadata> metadata = metadataProvider.getValidationMetadata(beanClass);
        StringBuilder sb = new StringBuilder("{\r\n\t\t");
        HashSet<String> fields = new HashSet<String>();
        if (form != null) {
            for (String field : form.getRegisteredFields()) {
                fields.add(new ParameterName(field).getStrippedName());
            }
        }
        if (this.fields != null && this.fields.trim().length() > 0) {
            fields.addAll(Arrays.asList(this.fields.split(",")));
        } else if (form == null) {
            log.error("Fields attribute is required when field-metadata tag isn't inside of a Stripes form tag.");
            return null;
        }
        boolean first = true;
        Locale locale = this.getPageContext().getRequest().getLocale();
        for (String field : fields) {
            PropertyExpressionEvaluation eval = null;
            try {
                eval = new PropertyExpressionEvaluation(PropertyExpression.getExpression(field), bean);
            }
            catch (Exception e) {
                continue;
            }
            Class<?> fieldType = eval.getType();
            ValidationMetadata data = metadata.get(field);
            StringBuilder fieldInfo = new StringBuilder();
            if (fieldType.isPrimitive() || Number.class.isAssignableFrom(fieldType) || Date.class.isAssignableFrom(fieldType) || this.includeType) {
                fieldInfo.append("type:").append(JavaScriptBuilder.quote(this.fqn ? fieldType.getName() : fieldType.getSimpleName()));
            }
            Class<Object> typeConverterClass = null;
            if (data != null) {
                if (fieldInfo.length() > 0) {
                    fieldInfo.append(',');
                }
                fieldInfo.append("required:").append(data.required()).append(",ignore:").append(data.ignore()).append(",encrypted:").append(data.encrypted()).append(",trim:").append(data.trim());
                if (data.on() != null) {
                    fieldInfo.append(",on:[");
                    Iterator<String> it = data.on().iterator();
                    while (it.hasNext()) {
                        fieldInfo.append(JavaScriptBuilder.quote(it.next()));
                        if (!it.hasNext()) continue;
                        fieldInfo.append(",");
                    }
                    fieldInfo.append("]");
                }
                if (data.mask() != null) {
                    fieldInfo.append(",mask:").append("new RegExp(").append(JavaScriptBuilder.quote("^" + data.mask().toString() + "$")).append(")");
                }
                if (data.minlength() != null) {
                    fieldInfo.append(",minlength:").append(data.minlength());
                }
                if (data.maxlength() != null) {
                    fieldInfo.append(",maxlength:").append(data.maxlength());
                }
                if (data.minvalue() != null) {
                    fieldInfo.append(",minvalue:").append(data.minvalue());
                }
                if (data.maxvalue() != null) {
                    fieldInfo.append(",maxvalue:").append(data.maxvalue());
                }
                String label = data.label();
                if (data.label() == null) {
                    label = LocalizationUtility.getLocalizedFieldName(field, form == null ? null : form.getAction(), form == null ? null : form.getActionBeanClass(), locale);
                }
                if (label != null) {
                    fieldInfo.append(",label:").append(JavaScriptBuilder.quote(label));
                }
                typeConverterClass = data.converter();
            }
            if (typeConverterClass == null) {
                try {
                    typeConverterClass = StripesFilter.getConfiguration().getTypeConverterFactory().getTypeConverter(fieldType, this.pageContext.getRequest().getLocale()).getClass();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (typeConverterClass != null) {
                fieldInfo.append(fieldInfo.length() > 0 ? "," : "").append("typeConverter:").append(JavaScriptBuilder.quote(this.fqn ? typeConverterClass.getName() : typeConverterClass.getSimpleName()));
            }
            if (fieldInfo.length() <= 0) continue;
            if (first) {
                first = false;
            } else {
                sb.append(",\r\n\t\t");
            }
            sb.append(JavaScriptBuilder.quote(field)).append(":{");
            sb.append((CharSequence)fieldInfo);
            sb.append("}");
        }
        sb.append("\r\n\t}");
        return sb.toString();
    }

    public FieldMetadataTag() {
        this.getAttributes().put("type", "text/javascript");
    }

    public void doInitBody() throws JspException {
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doStartTag() throws JspException {
        this.getPageContext().setAttribute(this.getVar(), (Object)new Var(this.getMetadata()));
        return 2;
    }

    public int doEndTag() throws JspException {
        JspWriter writer = this.getPageContext().getOut();
        String body = this.getBodyContentAsString();
        if (body != null) {
            try {
                boolean pageIsScript;
                String contentType = this.getPageContext().getResponse().getContentType();
                boolean bl = pageIsScript = contentType != null && contentType.toLowerCase().contains("ascript");
                if (!pageIsScript) {
                    this.writeOpenTag(writer, "script");
                    writer.write("//<![CDATA[\r\n");
                }
                writer.write(body);
                if (!pageIsScript) {
                    writer.write("\r\n//]]>");
                    this.writeCloseTag(writer, "script");
                }
            }
            catch (IOException ioe) {
                throw new StripesJspException("IOException while writing output in LinkTag.", ioe);
            }
        }
        String type = this.getAttributes().get("type");
        this.getAttributes().clear();
        this.getAttributes().put("type", type);
        return 0;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public boolean isIncludeType() {
        return this.includeType;
    }

    public void setIncludeType(boolean includeType) {
        this.includeType = includeType;
    }

    public boolean isFqn() {
        return this.fqn;
    }

    public void setFqn(boolean fqn) {
        this.fqn = fqn;
    }

    public void setAction(String action) {
        String binding = StripesFilter.getConfiguration().getActionResolver().getUrlBindingFromPath(action);
        this.actionWithoutContext = binding != null ? binding : action;
    }

    public String getAction() {
        return this.actionWithoutContext;
    }

    public void setBeanclass(Object beanclass) throws StripesJspException {
        String url = this.getActionBeanUrl(beanclass);
        if (url == null) {
            throw new StripesJspException("Could not determine action from 'beanclass' supplied. The value supplied was '" + beanclass + "'. Please ensure that this bean type " + "exists and is in the classpath. If you are developing a page and the ActionBean " + "does not yet exist, consider using the 'action' attribute instead for now.");
        }
        this.setAction(url);
    }

    public Object getBeanclass() {
        return null;
    }

    public class Var {
        private String fieldMetadata;
        private String formId;

        private Var(String fieldMetadata) {
            this.fieldMetadata = fieldMetadata;
            FormTag form = FieldMetadataTag.this.getForm();
            if (form != null) {
                if (form.getId() == null) {
                    form.setId("stripes-" + new Random().nextInt());
                }
                this.formId = form.getId();
            }
        }

        public String toString() {
            return this.fieldMetadata;
        }

        public String getFormId() {
            return this.formId;
        }
    }
}

