/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.DynamicAttributes;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.tag.PageOptionsTag;
import net.sourceforge.stripes.tag.StripesTagSupport;
import net.sourceforge.stripes.util.HtmlUtil;
import net.sourceforge.stripes.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlTagSupport
extends StripesTagSupport
implements DynamicAttributes {
    private static final Log log = Log.getInstance(HtmlTagSupport.class);
    private final Map<String, String> attributes = new HashMap<String, String>();
    private BodyContent bodyContent;

    protected final void set(String name, String value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    protected final String get(String name) {
        return this.attributes.get(name);
    }

    protected final Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setDynamicAttribute(String uri, String name, Object value) throws JspException {
        this.set(name, value == null ? "" : value.toString());
    }

    public BodyContent getBodyContent() {
        return this.bodyContent;
    }

    public void setBodyContent(BodyContent bodyContent) {
        this.bodyContent = bodyContent;
    }

    @Override
    public void release() {
        this.pageContext = null;
        this.parentTag = null;
        this.bodyContent = null;
        this.attributes.clear();
    }

    protected String getBodyContentAsString() {
        String body;
        String returnValue = null;
        if (this.bodyContent != null && (body = this.getBodyContent().getString()) != null && body.length() > 0) {
            returnValue = body;
        }
        return returnValue;
    }

    protected boolean isXmlTags() {
        return !"html".equalsIgnoreCase(PageOptionsTag.getHtmlMode(this.pageContext));
    }

    protected void writeOpenTag(JspWriter writer, String tag) throws JspException {
        try {
            writer.print("<");
            writer.print(tag);
            this.writeAttributes(writer);
            writer.print(">");
        }
        catch (IOException ioe) {
            JspException jspe = new JspException("IOException encountered while writing open tag <" + tag + "> to the JspWriter.", (Throwable)ioe);
            log.warn((Throwable)jspe, new Object[0]);
            throw jspe;
        }
    }

    protected void writeCloseTag(JspWriter writer, String tag) throws JspException {
        try {
            writer.print("</");
            writer.print(tag);
            writer.print(">");
        }
        catch (IOException ioe) {
            JspException jspe = new JspException("IOException encountered while writing close tag </" + tag + "> to the JspWriter.", (Throwable)ioe);
            log.warn((Throwable)jspe, new Object[0]);
            throw jspe;
        }
    }

    protected void writeSingletonTag(JspWriter writer, String tag) throws JspException {
        try {
            writer.print("<");
            writer.print(tag);
            this.writeAttributes(writer);
            writer.print(this.isXmlTags() ? " />" : ">");
        }
        catch (IOException ioe) {
            JspException jspe = new JspException("IOException encountered while writing singleton tag <" + tag + "/> to the JspWriter.", (Throwable)ioe);
            log.warn((Throwable)jspe, new Object[0]);
            throw jspe;
        }
    }

    protected void writeAttributes(JspWriter writer) throws IOException {
        for (Map.Entry<String, String> attr : this.getAttributes().entrySet()) {
            String value = attr.getValue();
            if (value == null) continue;
            writer.print(" ");
            writer.print(attr.getKey());
            writer.print("=\"");
            writer.print(HtmlUtil.encode(value));
            writer.print("\"");
        }
    }

    protected <R> R evaluateExpression(String expression, Class<R> resultType) throws StripesJspException {
        try {
            return (R)this.pageContext.getExpressionEvaluator().evaluate(expression, resultType, this.pageContext.getVariableResolver(), null);
        }
        catch (ELException ele) {
            throw new StripesJspException("Could not evaluate EL expression  [" + expression + "] with result type [" + resultType.getName() + "] in tag class of type: " + this.getClass().getName(), ele);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "attributes=" + this.attributes + ", parentTag=" + this.parentTag + ", pageContext=" + this.pageContext + "}";
    }

    public void setId(String id) {
        this.set("id", id);
    }

    public String getId() {
        return this.get("id");
    }

    public void setClass(String cssClass) {
        this.set("class", cssClass);
    }

    public void setCssClass(String cssClass) {
        this.set("class", cssClass);
    }

    public String getCssClass() {
        return this.get("class");
    }

    public void setTitle(String title) {
        this.set("title", title);
    }

    public String getTitle() {
        return this.get("title");
    }

    public void setStyle(String style) {
        this.set("style", style);
    }

    public String getStyle() {
        return this.get("style");
    }

    public void setDir(String dir) {
        this.set("dir", dir);
    }

    public String getDir() {
        return this.get("dir");
    }

    public void setLang(String lang) {
        this.set("lang", lang);
    }

    public String getLang() {
        return this.get("lang");
    }

    public void setTabindex(String tabindex) {
        this.set("tabindex", tabindex);
    }

    public String getTabindex() {
        return this.get("tabindex");
    }

    public void setAccesskey(String accesskey) {
        this.set("accesskey", accesskey);
    }

    public String getAccesskey() {
        return this.get("accesskey");
    }

    public void setOnfocus(String onfocus) {
        this.set("onfocus", onfocus);
    }

    public String getOnfocus() {
        return this.get("onfocus");
    }

    public void setOnblur(String onblur) {
        this.set("onblur", onblur);
    }

    public String getOnblur() {
        return this.get("onblur");
    }

    public void setOnselect(String onselect) {
        this.set("onselect", onselect);
    }

    public String getOnselect() {
        return this.get("onselect");
    }

    public void setOnchange(String onchange) {
        this.set("onchange", onchange);
    }

    public String getOnchange() {
        return this.get("onchange");
    }

    public void setOnclick(String onclick) {
        this.set("onclick", onclick);
    }

    public String getOnclick() {
        return this.get("onclick");
    }

    public void setOndblclick(String ondblclick) {
        this.set("ondblclick", ondblclick);
    }

    public String getOndblclick() {
        return this.get("ondblclick");
    }

    public void setOnmousedown(String onmousedown) {
        this.set("onmousedown", onmousedown);
    }

    public String getOnmousedown() {
        return this.get("onmousedown");
    }

    public void setOnmouseup(String onmouseup) {
        this.set("onmouseup", onmouseup);
    }

    public String getOnmouseup() {
        return this.get("onmouseup");
    }

    public void setOnmouseover(String onmouseover) {
        this.set("onmouseover", onmouseover);
    }

    public String getOnmouseover() {
        return this.get("onmouseover");
    }

    public void setOnmousemove(String onmousemove) {
        this.set("onmousemove", onmousemove);
    }

    public String getOnmousemove() {
        return this.get("onmousemove");
    }

    public void setOnmouseout(String onmouseout) {
        this.set("onmouseout", onmouseout);
    }

    public String getOnmouseout() {
        return this.get("onmouseout");
    }

    public void setOnkeypress(String onkeypress) {
        this.set("onkeypress", onkeypress);
    }

    public String getOnkeypress() {
        return this.get("onkeypress");
    }

    public void setOnkeydown(String onkeydown) {
        this.set("onkeydown", onkeydown);
    }

    public String getOnkeydown() {
        return this.get("onkeydown");
    }

    public void setOnkeyup(String onkeyup) {
        this.set("onkeyup", onkeyup);
    }

    public String getOnkeyup() {
        return this.get("onkeyup");
    }
}

