/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TryCatchFinally;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.ActionResolver;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.tag.FormTag;
import net.sourceforge.stripes.tag.InputHiddenTag;
import net.sourceforge.stripes.tag.StripesTagSupport;
import net.sourceforge.stripes.util.CryptoUtil;
import net.sourceforge.stripes.util.HtmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardFieldsTag
extends StripesTagSupport
implements TryCatchFinally {
    private boolean currentFormOnly = false;

    public void setCurrentFormOnly(boolean currentFormOnly) {
        this.currentFormOnly = currentFormOnly;
    }

    public boolean isCurrentFormOnly() {
        return this.currentFormOnly;
    }

    @Override
    public int doStartTag() throws JspException {
        this.getTagStack().push(this);
        return 0;
    }

    @Override
    public int doEndTag() throws JspException {
        FormTag form = this.getParentTag(FormTag.class);
        ActionBean actionBean = form.getActionBean();
        if (!this.isCurrentFormOnly() || actionBean != null) {
            this.writeWizardFields(form);
        }
        return 6;
    }

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
        try {
            this.getTagStack().pop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeWizardFields(FormTag form) throws JspException, StripesJspException {
        InputHiddenTag hidden = new InputHiddenTag();
        hidden.setPageContext(this.getPageContext());
        hidden.setParent(this.getParent());
        Set<String> paramNames = this.getParamNames();
        Set<String> excludes = this.getExcludes(form);
        Class<? extends ActionBean> actionBeanType = form.getActionBeanClass();
        for (String name : paramNames) {
            if (excludes.contains(name) || this.isEventName(actionBeanType, name)) continue;
            hidden.setName(name);
            try {
                hidden.doStartTag();
                hidden.doAfterBody();
                hidden.doEndTag();
            }
            catch (Throwable t) {
                try {
                    hidden.doCatch(t);
                }
                catch (Throwable t2) {
                    if (t2 instanceof JspException) {
                        throw (JspException)t2;
                    }
                    if (t2 instanceof RuntimeException) {
                        throw (RuntimeException)t2;
                    }
                    throw new StripesJspException(t2);
                }
            }
            finally {
                hidden.doFinally();
            }
        }
    }

    protected Set<String> getParamNames() {
        HashSet<String> paramNames = new HashSet<String>();
        ServletRequest request = this.getPageContext().getRequest();
        paramNames.addAll(request.getParameterMap().keySet());
        String fieldsPresent = request.getParameter("__fp");
        if (fieldsPresent != null) {
            paramNames.addAll(HtmlUtil.splitValues(CryptoUtil.decrypt(fieldsPresent)));
        }
        return paramNames;
    }

    protected Set<String> getExcludes(FormTag form) {
        String eventName;
        HashSet<String> excludes = new HashSet<String>();
        excludes.addAll(form.getRegisteredFields());
        excludes.add("_sourcePage");
        excludes.add("__fp");
        excludes.add("_eventName");
        excludes.add("__fsk");
        ServletRequest request = this.getPageContext().getRequest();
        ActionBean submittedActionBean = (ActionBean)request.getAttribute("actionBean");
        if (submittedActionBean != null && (eventName = submittedActionBean.getContext().getEventName()) != null) {
            excludes.add(eventName);
            excludes.add(eventName + ".x");
            excludes.add(eventName + ".y");
        }
        return excludes;
    }

    protected boolean isEventName(Class<? extends ActionBean> beanType, String name) {
        if (beanType == null || name == null) {
            return false;
        }
        try {
            ActionResolver actionResolver = StripesFilter.getConfiguration().getActionResolver();
            return actionResolver.getHandler(beanType, name) != null;
        }
        catch (StripesServletException e) {
            return false;
        }
    }
}

