/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag.layout;

import java.io.IOException;
import java.util.LinkedList;
import javax.servlet.ServletException;
import javax.servlet.jsp.PageContext;
import net.sourceforge.stripes.tag.layout.LayoutContext;
import net.sourceforge.stripes.util.Log;

public class LayoutComponentRenderer {
    private static final Log log = Log.getInstance(LayoutComponentRenderer.class);
    private LinkedList<PageContext> pageContext;
    private String component;
    private LayoutContext context;

    public LayoutComponentRenderer(String component) {
        this.component = component;
    }

    public void pushPageContext(PageContext pageContext) {
        if (this.pageContext == null) {
            this.pageContext = new LinkedList();
        }
        this.pageContext.addFirst(pageContext);
    }

    public PageContext popPageContext() {
        return this.pageContext == null ? null : this.pageContext.poll();
    }

    public PageContext getPageContext() {
        return this.pageContext == null ? null : this.pageContext.peek();
    }

    public String getCurrentPage() {
        return (String)this.getPageContext().getRequest().getAttribute("javax.servlet.include.servlet_path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write() throws ServletException, IOException {
        LayoutContext context;
        PageContext pageContext = this.getPageContext();
        if (pageContext == null) {
            log.error("Failed to render component \"", this.component, "\" without a page context!");
            return false;
        }
        LayoutContext savedContext = this.context;
        LayoutContext currentContext = LayoutContext.lookup(pageContext);
        log.debug("Render component \"", this.component, "\" in ", this.getCurrentPage());
        LayoutContext layoutContext = context = savedContext == null ? currentContext : savedContext.getPrevious();
        while (context != null) {
            if (!context.getComponents().containsKey(this.component)) {
                log.trace("Not rendering \"", this.component, "\" in context ", context.getRenderPage(), " -> ", context.getDefinitionPage());
            } else {
                this.context = context;
                LayoutContext savedNext = context.getNext();
                String savedComponent = context.getComponent();
                boolean savedComponentRenderPhase = context.isComponentRenderPhase();
                boolean savedSilent = context.getOut().isSilent();
                try {
                    context.setNext(null);
                    context.setComponentRenderPhase(true);
                    context.setComponent(this.component);
                    context.getOut().setSilent(true, pageContext);
                    log.debug("Start execute \"", this.component, "\" in ", currentContext.getRenderPage(), " -> ", currentContext.getDefinitionPage(), " from ", context.getRenderPage(), " -> ", context.getDefinitionPage());
                    context.doInclude(pageContext, context.getRenderPage());
                    log.debug("End execute \"", this.component, "\" in ", currentContext.getRenderPage(), " -> ", currentContext.getDefinitionPage(), " from ", context.getRenderPage(), " -> ", context.getDefinitionPage());
                    if (context.getComponent() == null) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    context.setNext(savedNext);
                    context.setComponent(savedComponent);
                    context.setComponentRenderPhase(savedComponentRenderPhase);
                    context.getOut().setSilent(savedSilent, pageContext);
                    this.context = savedContext;
                }
            }
            context = context.getPrevious();
        }
        log.debug("Component \"", this.component, "\" evaluated to empty string in context ", currentContext.getRenderPage(), " -> ", currentContext.getDefinitionPage());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        PageContext pageContext = this.getPageContext();
        if (pageContext == null) {
            log.error("Failed to render component \"", this.component, "\" without a page context!");
            return "[Failed to render component \"" + this.component + "\" without a page context!]";
        }
        LayoutContext context = LayoutContext.lookup(pageContext);
        context.getOut().openBuffer(pageContext);
        try {
            log.debug("Start stringify \"", this.component, "\" in ", context.getRenderPage(), " -> ", context.getDefinitionPage());
            this.write();
        }
        catch (Exception e) {
            String string;
            try {
                log.error(e, "Unhandled exception trying to render component \"", this.component, "\" to a string in context ", context.getRenderPage(), " -> ", context.getDefinitionPage());
                string = "[Failed to render \"" + this.component + "\". See log for details.]";
            }
            catch (Throwable throwable) {
                log.debug("End stringify \"", this.component, "\" in ", context.getRenderPage(), " -> ", context.getDefinitionPage());
                String contents = context.getOut().closeBuffer(pageContext);
                throw throwable;
            }
            log.debug("End stringify \"", this.component, "\" in ", context.getRenderPage(), " -> ", context.getDefinitionPage());
            String contents = context.getOut().closeBuffer(pageContext);
            return string;
        }
        log.debug("End stringify \"", this.component, "\" in ", context.getRenderPage(), " -> ", context.getDefinitionPage());
        String contents = context.getOut().closeBuffer(pageContext);
        return contents;
    }
}

