/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag.layout;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.jsp.PageContext;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.tag.layout.LayoutComponentRenderer;
import net.sourceforge.stripes.tag.layout.LayoutRenderTag;
import net.sourceforge.stripes.tag.layout.LayoutRenderTagPath;
import net.sourceforge.stripes.tag.layout.LayoutWriter;
import net.sourceforge.stripes.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutContext {
    private static final Log log = Log.getInstance(LayoutContext.class);
    public static final String LAYOUT_CONTEXT_KEY = LayoutContext.class.getName() + "#Context";
    public static final String BROKEN_INCLUDE_KEY = LayoutContext.class.getName() + "#BROKEN_INCLUDE";
    private LayoutContext previous;
    private LayoutContext next;
    private LayoutRenderTag renderTag;
    private LayoutWriter out;
    private Map<String, LayoutComponentRenderer> components = new HashMap<String, LayoutComponentRenderer>();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private String renderPage;
    private String component;
    private LayoutRenderTagPath componentPath;
    private boolean componentRenderPhase;
    private boolean rendered;

    public static LayoutContext push(LayoutRenderTag renderTag) {
        LayoutContext context = new LayoutContext(renderTag);
        log.debug("Push context ", context.getRenderPage(), " -> ", context.getDefinitionPage());
        PageContext pageContext = renderTag.getPageContext();
        LayoutContext previous = LayoutContext.lookup(pageContext);
        if (previous == null) {
            context.out = new LayoutWriter(pageContext.getOut());
            pageContext.pushBody((Writer)context.out);
        } else {
            if (previous.next != null) {
                throw new StripesRuntimeException("Attempt to insert a new context into the middle of the stack");
            }
            context.out = previous.out;
            previous.next = context;
            context.previous = previous;
        }
        pageContext.setAttribute(LAYOUT_CONTEXT_KEY, (Object)context);
        return context;
    }

    public static LayoutContext lookup(PageContext pageContext) {
        LayoutContext context = (LayoutContext)pageContext.getAttribute(LAYOUT_CONTEXT_KEY);
        if (context == null && (context = (LayoutContext)pageContext.getRequest().getAttribute(LAYOUT_CONTEXT_KEY)) != null) {
            for (LayoutContext c = context.getFirst(); c != context; c = c.getNext()) {
                for (Map.Entry<String, Object> entry : c.getParameters().entrySet()) {
                    pageContext.setAttribute(entry.getKey(), entry.getValue());
                }
            }
            pageContext.setAttribute(LAYOUT_CONTEXT_KEY, (Object)context);
            pageContext.getRequest().removeAttribute(LAYOUT_CONTEXT_KEY);
        }
        return context;
    }

    public static LayoutContext pop(PageContext pageContext) {
        LayoutContext context = LayoutContext.lookup(pageContext);
        log.debug("Pop context ", context.getRenderPage(), " -> ", context.getDefinitionPage());
        pageContext.setAttribute(LAYOUT_CONTEXT_KEY, (Object)context.previous);
        if (context.previous == null) {
            pageContext.popBody();
        } else {
            context.previous.next = null;
            context.previous = null;
        }
        return context;
    }

    public LayoutContext(LayoutRenderTag renderTag) {
        this.renderTag = renderTag;
        this.renderPage = renderTag.getCurrentPagePath();
        this.componentPath = new LayoutRenderTagPath(renderTag);
        log.debug("Path is ", this.componentPath);
    }

    public LayoutContext getPrevious() {
        return this.previous;
    }

    public LayoutContext getNext() {
        return this.next;
    }

    public void setNext(LayoutContext next) {
        this.next = next;
    }

    public LayoutContext getFirst() {
        LayoutContext c = this;
        while (c.getPrevious() != null) {
            c = c.getPrevious();
        }
        return c;
    }

    public LayoutContext getLast() {
        LayoutContext c = this;
        while (c.getNext() != null) {
            c = c.getNext();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInclude(PageContext pageContext, String relativeUrlPath) throws ServletException, IOException {
        try {
            pageContext.getRequest().setAttribute(LAYOUT_CONTEXT_KEY, (Object)this);
            if (this.isIncludeBroken(pageContext)) {
                this.doIncludeHack(pageContext, relativeUrlPath);
            } else {
                pageContext.include(relativeUrlPath, false);
            }
        }
        finally {
            pageContext.getRequest().removeAttribute(LAYOUT_CONTEXT_KEY);
        }
    }

    protected boolean isIncludeBroken(PageContext pageContext) {
        Boolean b = (Boolean)pageContext.getServletContext().getAttribute(BROKEN_INCLUDE_KEY);
        if (b == null) {
            b = pageContext.getClass().getName().startsWith("weblogic.");
            pageContext.getServletContext().setAttribute(BROKEN_INCLUDE_KEY, (Object)b);
            if (b.booleanValue()) {
                log.info("This application server's include is broken so a workaround will be used.");
            }
        }
        return b;
    }

    protected void doIncludeHack(PageContext pageContext, String relativeUrlPath) throws ServletException, IOException {
        class MyServletOutputStream
        extends ServletOutputStream {
            static final String DEFAULT_CHARSET = "UTF-8";
            static final int BUFFER_SIZE = 1024;
            Writer out;
            String charset = "UTF-8";
            CharsetDecoder decoder;
            ByteBuffer bbuf;
            CharBuffer cbuf;

            MyServletOutputStream(Writer out) {
                this.out = out;
            }

            String getCharset() {
                return this.charset;
            }

            void setCharset(String charset) {
                if (charset == null) {
                    charset = DEFAULT_CHARSET;
                }
                if (!charset.equals(this.charset)) {
                    this.decoder = null;
                }
                this.charset = charset;
            }

            void initDecoder() {
                if (this.decoder == null) {
                    this.decoder = Charset.forName(this.getCharset()).newDecoder();
                    if (this.bbuf == null) {
                        this.bbuf = ByteBuffer.allocate(1024);
                    }
                    int size = (int)Math.ceil(1024.0f * this.decoder.maxCharsPerByte());
                    if (this.cbuf == null || this.cbuf.capacity() != size) {
                        this.cbuf = CharBuffer.allocate(size);
                    }
                }
            }

            void resetBuffer() {
                if (this.bbuf.hasRemaining()) {
                    ByteBuffer slice = this.bbuf.slice();
                    this.bbuf.clear();
                    this.bbuf.put(slice);
                } else {
                    this.bbuf.clear();
                }
            }

            void decodeBuffer() throws IOException {
                this.bbuf.flip();
                this.cbuf.clear();
                this.decoder.decode(this.bbuf, this.cbuf, false);
                this.cbuf.flip();
                this.out.write(this.cbuf.array(), this.cbuf.position(), this.cbuf.remaining());
                this.resetBuffer();
            }

            public void print(char c) throws IOException {
                this.out.write(c);
            }

            public void print(String s) throws IOException {
                this.out.write(s);
            }

            public void write(int b) throws IOException {
                this.initDecoder();
                this.bbuf.put((byte)b);
                this.decodeBuffer();
            }

            public void write(byte[] buf, int off, int len) throws IOException {
                this.initDecoder();
                for (int i = 0; i < len; i += this.bbuf.remaining()) {
                    int n = len - i;
                    if (n > this.bbuf.remaining()) {
                        n = this.bbuf.remaining();
                    }
                    this.bbuf.put(buf, i, n);
                    this.decodeBuffer();
                }
            }

            public void write(byte[] buf) throws IOException {
                this.write(buf, 0, buf.length);
            }
        }
        final MyServletOutputStream os = new MyServletOutputStream((Writer)pageContext.getOut());
        final PrintWriter writer = new PrintWriter((Writer)pageContext.getOut());
        HttpServletResponseWrapper response = new HttpServletResponseWrapper((HttpServletResponse)pageContext.getResponse()){
            {
                super(x0);
            }

            public String getCharacterEncoding() {
                return os.getCharset();
            }

            public void setCharacterEncoding(String charset) {
                os.setCharset(charset);
            }

            public ServletOutputStream getOutputStream() throws IOException {
                return os;
            }

            public PrintWriter getWriter() throws IOException {
                return writer;
            }
        };
        pageContext.getRequest().getRequestDispatcher(relativeUrlPath).include(pageContext.getRequest(), (ServletResponse)response);
    }

    public LayoutRenderTag getRenderTag() {
        return this.renderTag;
    }

    public Map<String, LayoutComponentRenderer> getComponents() {
        return this.components;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public boolean isRendered() {
        return this.rendered;
    }

    public void setRendered(boolean rendered) {
        this.rendered = rendered;
    }

    public String getRenderPage() {
        return this.renderPage;
    }

    public String getDefinitionPage() {
        return this.getRenderTag().getName();
    }

    public boolean isComponentRenderPhase() {
        return this.componentRenderPhase;
    }

    public void setComponentRenderPhase(boolean b) {
        this.componentRenderPhase = b;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public LayoutRenderTagPath getComponentPath() {
        return this.componentPath;
    }

    public LayoutWriter getOut() {
        return this.out;
    }

    public String toString() {
        return "LayoutContext{component names=" + this.components.keySet() + ", parameters=" + this.parameters + '}';
    }
}

