/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag.layout;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.DynamicAttributes;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.tag.layout.LayoutComponentTag;
import net.sourceforge.stripes.tag.layout.LayoutContext;
import net.sourceforge.stripes.tag.layout.LayoutRenderTagPath;
import net.sourceforge.stripes.tag.layout.LayoutTag;
import net.sourceforge.stripes.util.Log;

public class LayoutRenderTag
extends LayoutTag
implements BodyTag,
DynamicAttributes {
    private static final Log log = Log.getInstance(LayoutRenderTag.class);
    private String name;
    private LayoutContext context;
    private boolean contextIsNew;
    private boolean silent;
    private LayoutRenderTagPath path;
    private BodyContent bodyContent;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.initialize();
    }

    public LayoutRenderTagPath getPath() {
        return this.path;
    }

    protected void initialize() {
        LayoutRenderTagPath path;
        boolean create;
        LayoutContext context = LayoutContext.lookup(this.pageContext);
        boolean bl = create = context == null || !context.isComponentRenderPhase() || this.isChildOfCurrentComponent();
        if (create) {
            context = LayoutContext.push(this);
            path = context.getComponentPath();
        } else {
            path = new LayoutRenderTagPath(this);
        }
        this.context = context;
        this.contextIsNew = create;
        this.path = path;
        this.silent = context.getOut().isSilent();
    }

    public boolean isChildOfCurrentComponent() {
        try {
            Object parent = this.getLayoutParent();
            return parent instanceof LayoutComponentTag && ((LayoutComponentTag)parent).isCurrentComponent();
        }
        catch (StripesJspException e) {
            throw new StripesRuntimeException("Something has happened that should never happen", (Throwable)((Object)e));
        }
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        this.context.getParameters().put(localName, value);
    }

    public int doStartTag() throws JspException {
        try {
            if (this.contextIsNew) {
                log.debug("Start layout init in ", this.context.getRenderPage());
                this.pushPageContextAttributes(this.context.getParameters());
            }
            if (this.context.isComponentRenderPhase()) {
                log.debug("Start component render phase for ", this.context.getComponent(), " in ", this.context.getRenderPage());
                this.exportComponentRenderers();
            }
            this.context.getOut().setSilent(true, this.pageContext);
            return this.contextIsNew ? 2 : 1;
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    public void setBodyContent(BodyContent bodyContent) {
        this.bodyContent = bodyContent;
    }

    public void doInitBody() throws JspException {
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.contextIsNew) {
                log.debug("End layout init in ", this.context.getRenderPage());
                try {
                    log.debug("Start layout exec in ", this.context.getDefinitionPage());
                    this.context.getOut().setSilent(true, this.pageContext);
                    this.context.doInclude(this.pageContext, this.getName());
                    log.debug("End layout exec in ", this.context.getDefinitionPage());
                }
                catch (Exception e) {
                    throw new StripesJspException("An exception was raised while invoking a layout. The layout used was '" + this.getName() + "'. The following information was supplied to the render " + "tag: " + this.context.toString(), e);
                }
                if (!this.context.isRendered()) {
                    throw new StripesJspException("Attempt made to render a layout that does not exist. The layout name provided was '" + this.getName() + "'. Please check that a JSP/view exists at " + "that location within your web application.");
                }
                this.context.getOut().setSilent(this.silent, this.pageContext);
                LayoutContext.pop(this.pageContext);
                this.popPageContextAttributes();
            } else {
                this.context.getOut().setSilent(this.silent, this.pageContext);
            }
            if (this.context.isComponentRenderPhase()) {
                log.debug("End component render phase for ", this.context.getComponent(), " in ", this.context.getRenderPage());
                this.cleanUpComponentRenderers();
            }
            int e = 6;
            return e;
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.context = null;
            this.contextIsNew = false;
            this.path = null;
            this.silent = false;
            if (this.bodyContent != null) {
                this.bodyContent.clearBody();
                this.bodyContent = null;
            }
        }
    }
}

