/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag.layout;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.jsp.PageContext;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.tag.layout.LayoutComponentTag;
import net.sourceforge.stripes.tag.layout.LayoutRenderTag;
import net.sourceforge.stripes.tag.layout.LayoutTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutRenderTagPath {
    private List<String> componentPath;
    private int index;

    public LayoutRenderTagPath(LayoutRenderTag tag) {
        this.componentPath = this.calculateComponentPath(tag);
        this.index = this.incrementIndex(tag.getPageContext());
    }

    protected List<String> calculateComponentPath(LayoutRenderTag tag) {
        LinkedList<String> path = null;
        Object parent = tag.getLayoutParent();
        while (parent instanceof LayoutComponentTag) {
            if (path == null) {
                path = new LinkedList<String>();
            }
            path.addFirst(((LayoutComponentTag)parent).getName());
            parent = ((LayoutTag)parent).getLayoutParent();
            parent = parent instanceof LayoutRenderTag ? ((LayoutTag)parent).getLayoutParent() : null;
        }
        return path;
    }

    protected int incrementIndex(PageContext pageContext) {
        String key = this.getClass().getName() + "#" + this.toStringWithoutIndex();
        Integer index = (Integer)pageContext.getAttribute(key);
        index = index == null ? Integer.valueOf(0) : Integer.valueOf(index + 1);
        pageContext.setAttribute(key, (Object)index);
        return index;
    }

    public List<String> getComponentPath() {
        return this.componentPath;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isPathComponent(LayoutComponentTag tag) throws StripesJspException {
        List<String> path = this.getComponentPath();
        return path == null ? false : this.isPathComponent(tag, path.iterator());
    }

    protected boolean isPathComponent(LayoutComponentTag tag, Iterator<String> path) {
        Object parent = tag.getLayoutParent();
        if (parent instanceof LayoutRenderTag && (!((parent = ((LayoutTag)parent).getLayoutParent()) instanceof LayoutComponentTag) || parent instanceof LayoutComponentTag && this.isPathComponent((LayoutComponentTag)parent, path) && path.hasNext())) {
            return tag.getName().equals(path.next());
        }
        return false;
    }

    public boolean equals(Object obj) {
        LayoutRenderTagPath that = (LayoutRenderTagPath)obj;
        if (this.index != that.index) {
            return false;
        }
        if (this.componentPath == that.componentPath) {
            return true;
        }
        if (this.componentPath == null || that.componentPath == null) {
            return false;
        }
        return ((Object)this.componentPath).equals(that.componentPath);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.toStringWithoutIndex() + '[' + this.index + ']';
    }

    public String toStringWithoutIndex() {
        if (this.componentPath == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        Iterator<String> it = this.componentPath.iterator();
        while (it.hasNext()) {
            s.append(it.next());
            if (!it.hasNext()) continue;
            s.append('>');
        }
        return s.toString();
    }
}

