/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ActionResolver;
import net.sourceforge.stripes.controller.AnnotatedClassActionResolver;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.controller.UrlBinding;
import net.sourceforge.stripes.controller.UrlBindingParameter;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.exception.UrlBindingConflictException;
import net.sourceforge.stripes.format.Formatter;
import net.sourceforge.stripes.format.FormatterFactory;
import net.sourceforge.stripes.util.CollectionUtil;
import net.sourceforge.stripes.util.CryptoUtil;
import net.sourceforge.stripes.util.Literal;
import net.sourceforge.stripes.util.StringUtil;
import net.sourceforge.stripes.validation.ValidationMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlBuilder {
    private String baseUrl;
    private String anchor;
    private Locale locale;
    private String parameterSeparator;
    private Parameter event;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private String url;

    @Deprecated
    public UrlBuilder(String url, boolean isForPage) {
        this(Locale.getDefault(), url, isForPage);
    }

    public UrlBuilder(Locale locale, String url, boolean isForPage) {
        this(locale, isForPage);
        if (url != null) {
            int index = url.indexOf(35);
            if (index != -1) {
                if (index < url.length() - 1) {
                    this.anchor = url.substring(index + 1);
                }
                url = url.substring(0, index);
            }
            this.baseUrl = url;
        }
    }

    public UrlBuilder(Locale locale, Class<? extends ActionBean> beanType, boolean isForPage) {
        this(locale, isForPage);
        Configuration configuration = StripesFilter.getConfiguration();
        if (configuration == null) {
            throw new StripesRuntimeException("Unable to lookup URL binding for ActionBean class because there is no Configuration object available.");
        }
        this.baseUrl = configuration.getActionResolver().getUrlBinding(beanType);
    }

    protected UrlBuilder(Locale locale, boolean isForPage) {
        this.locale = locale;
        this.parameterSeparator = isForPage ? "&amp;" : "&";
    }

    public String getEvent() {
        return (String)(this.event == null ? null : this.event.value);
    }

    public UrlBuilder setEvent(String event) {
        this.event = new Parameter("$event", event);
        return this;
    }

    public String getParameterSeparator() {
        return this.parameterSeparator;
    }

    public void setParameterSeparator(String parameterSeparator) {
        this.parameterSeparator = parameterSeparator;
    }

    public UrlBuilder addParameter(String name, Object ... values) {
        if (values == null || values.length == 0) {
            values = Literal.array("");
        }
        for (Object v : values) {
            if (v instanceof Collection) {
                this.addParameter(name, ((Collection)v).toArray());
                continue;
            }
            if (v != null && v.getClass().isArray()) {
                this.addParameter(name, CollectionUtil.asObjectArray(v));
                continue;
            }
            this.parameters.add(new Parameter(name, v));
            this.url = null;
        }
        return this;
    }

    public UrlBuilder addParameters(Map<? extends Object, ? extends Object> parameters) {
        for (Map.Entry<? extends Object, ? extends Object> parameter : parameters.entrySet()) {
            String name = parameter.getKey().toString();
            Object valueOrValues = parameter.getValue();
            if (valueOrValues == null) {
                this.addParameter(name, new Object[]{null});
                continue;
            }
            if (valueOrValues.getClass().isArray()) {
                this.addParameter(name, CollectionUtil.asObjectArray(valueOrValues));
                continue;
            }
            if (valueOrValues instanceof Collection) {
                this.addParameter(name, (Collection)valueOrValues);
                continue;
            }
            this.addParameter(name, valueOrValues);
        }
        return this;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public UrlBuilder setAnchor(String anchor) {
        this.anchor = anchor != null && anchor.startsWith("#") && anchor.length() > 1 ? anchor.substring(1) : anchor;
        return this;
    }

    public String toString() {
        if (this.url == null) {
            this.url = this.build();
        }
        if (this.anchor != null && this.anchor.length() > 0) {
            return this.url + "#" + StringUtil.uriFragmentEncode(this.anchor);
        }
        return this.url;
    }

    protected String format(Object value) {
        if (value == null) {
            return "";
        }
        Formatter formatter = this.getFormatter(value);
        if (formatter == null) {
            return value.toString();
        }
        return formatter.format(value);
    }

    protected Formatter getFormatter(Object value) {
        Configuration configuration = StripesFilter.getConfiguration();
        if (configuration == null) {
            return null;
        }
        FormatterFactory factory = configuration.getFormatterFactory();
        if (factory == null) {
            return null;
        }
        return factory.getFormatter(value.getClass(), this.locale, null, null);
    }

    protected Map<String, ValidationMetadata> getValidationMetadata() {
        Map<String, ValidationMetadata> validations = null;
        Configuration configuration = StripesFilter.getConfiguration();
        if (configuration != null) {
            Class<? extends ActionBean> beanType = null;
            try {
                beanType = configuration.getActionResolver().getActionBeanType(this.baseUrl);
            }
            catch (UrlBindingConflictException e) {
                // empty catch block
            }
            if (beanType != null) {
                validations = configuration.getValidationMetadataProvider().getValidationMetadata(beanType);
            }
        }
        if (validations == null) {
            validations = Collections.emptyMap();
        }
        return validations;
    }

    protected String build() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.parameters.size() + 1);
        if (this.event != null) {
            parameters.add(this.event);
        }
        parameters.addAll(this.parameters);
        Map<String, ValidationMetadata> validations = this.getValidationMetadata();
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(this.getBaseURL(this.baseUrl, parameters));
        boolean seenQuestionMark = buffer.indexOf("?") != -1;
        for (Parameter param : parameters) {
            if (param == this.event) {
                if (param.value == null) continue;
                param = new Parameter((String)this.event.value, "");
            }
            if (!seenQuestionMark) {
                buffer.append('?');
                seenQuestionMark = true;
            } else {
                buffer.append(this.getParameterSeparator());
            }
            buffer.append(StringUtil.urlEncode(param.name)).append('=');
            if (param.value == null) continue;
            ValidationMetadata validation = validations.get(param.name);
            String formatted = this.format(param.value);
            if (validation != null && validation.encrypted()) {
                formatted = CryptoUtil.encrypt(formatted);
            }
            buffer.append(StringUtil.urlEncode(formatted));
        }
        return buffer.toString();
    }

    protected String getBaseURL(String baseUrl, Collection<Parameter> parameters) {
        ActionResolver resolver = StripesFilter.getConfiguration().getActionResolver();
        if (!(resolver instanceof AnnotatedClassActionResolver)) {
            return baseUrl;
        }
        UrlBinding binding = null;
        try {
            binding = ((AnnotatedClassActionResolver)resolver).getUrlBindingFactory().getBindingPrototype(baseUrl);
        }
        catch (UrlBindingConflictException e) {
            // empty catch block
        }
        if (binding == null || binding.getParameters().size() == 0) {
            return baseUrl;
        }
        if (baseUrl.equals(binding.toString())) {
            baseUrl = binding.getPath();
        }
        if (binding.getPath().length() < baseUrl.length()) {
            return baseUrl;
        }
        Map<String, ValidationMetadata> validations = this.getValidationMetadata();
        HashMap<String, Parameter> map = new HashMap<String, Parameter>();
        for (Parameter p : parameters) {
            if (map.containsKey(p.name)) continue;
            map.put(p.name, p);
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append(baseUrl);
        String nextLiteral = null;
        for (Object component : binding.getComponents()) {
            if (component instanceof String) {
                nextLiteral = (String)component;
                continue;
            }
            if (!(component instanceof UrlBindingParameter)) continue;
            boolean ok = false;
            UrlBindingParameter parameter = (UrlBindingParameter)component;
            Parameter assigned = (Parameter)map.get(parameter.getName());
            Object value = assigned != null && (assigned.value != null || assigned.isEvent()) ? assigned.value : parameter.getDefaultValue();
            if (value != null) {
                String formatted = this.format(value);
                ValidationMetadata validation = validations.get(parameter.getName());
                if (validation != null && validation.encrypted()) {
                    formatted = CryptoUtil.encrypt(formatted);
                }
                if (formatted != null && formatted.length() > 0) {
                    if (nextLiteral != null) {
                        buf.append(nextLiteral);
                    }
                    buf.append(StringUtil.urlEncode(formatted));
                    parameters.remove(assigned);
                    ok = true;
                }
            } else if (assigned != null && assigned.isEvent()) {
                parameters.remove(assigned);
            }
            nextLiteral = null;
            if (ok) continue;
            break;
        }
        if (nextLiteral != null) {
            buf.append(nextLiteral);
        } else if (binding.getSuffix() != null) {
            buf.append(binding.getSuffix());
        }
        String url = buf.toString();
        try {
            StripesFilter.getConfiguration().getActionResolver().getActionBeanType(url);
        }
        catch (UrlBindingConflictException e) {
            UrlBindingConflictException tmp = new UrlBindingConflictException(binding.getBeanType(), e.getPath(), e.getMatches());
            tmp.setStackTrace(e.getStackTrace());
            e = tmp;
            throw e;
        }
        return url;
    }

    private static class Parameter {
        String name;
        Object value;

        Parameter(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public boolean isEvent() {
            return "$event".equals(this.name);
        }

        public String toString() {
            return "" + this.name + "=" + this.value;
        }
    }
}

