/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util.bean;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.bean.NodeEvaluation;
import net.sourceforge.stripes.util.bean.PropertyAccessor;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPropertyAccessor
implements PropertyAccessor<Map<?, ?>> {
    private static final Log log = Log.getInstance(MapPropertyAccessor.class);

    @Override
    public Object getValue(NodeEvaluation evaluation, Map<?, ?> map) {
        Object key = this.getKey(evaluation);
        return map.get(key);
    }

    @Override
    public void setValue(NodeEvaluation evaluation, Map map, Object value) {
        Object key = this.getKey(evaluation);
        if (key != null && !evaluation.getKeyType().isAssignableFrom(key.getClass())) {
            String exprString = evaluation.getExpressionEvaluation().getExpression().getSource();
            String nodeString = evaluation.getNode().getStringValue();
            String declTypeName = evaluation.getKeyType().getName();
            String evalTypeName = key.getClass().getName();
            log.warn("Unable to bind ", exprString, " because the string \"", nodeString, "\" evaluates to a ", evalTypeName, ", which is not assignable to the map's key type of ", declTypeName, ". This likely means type conversion failed and there is no constructor ", declTypeName, "(String).");
        } else {
            map.put(key, value);
        }
    }

    protected Object getKey(NodeEvaluation evaluation) {
        Class<?> declaredType = evaluation.getKeyType();
        Class<?> nodeType = evaluation.getNode().getTypedValue().getClass();
        if (nodeType.equals(declaredType) || declaredType == null) {
            return evaluation.getNode().getTypedValue();
        }
        try {
            String stringKey = evaluation.getNode().getStringValue();
            ActionBean bean = (ActionBean)evaluation.getExpressionEvaluation().getBean();
            Locale locale = bean.getContext().getLocale();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            TypeConverter tc = StripesFilter.getConfiguration().getTypeConverterFactory().getTypeConverter(declaredType, locale);
            if (tc != null) {
                Object retval = tc.convert(stringKey, declaredType, errors);
                if (errors.size() == 0) {
                    return retval;
                }
            } else {
                Constructor<?> c = declaredType.getConstructor(String.class);
                if (c != null) {
                    return c.newInstance(stringKey);
                }
            }
        }
        catch (Exception e) {
            log.warn("Exception while converting Map key to appropriate type. Key: ", evaluation.getNode().getStringValue());
        }
        return evaluation.getNode().getTypedValue();
    }
}

