/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.BigDecimalTypeConverter;
import net.sourceforge.stripes.validation.BigIntegerTypeConverter;
import net.sourceforge.stripes.validation.BooleanTypeConverter;
import net.sourceforge.stripes.validation.ByteTypeConverter;
import net.sourceforge.stripes.validation.CharacterTypeConverter;
import net.sourceforge.stripes.validation.DateTypeConverter;
import net.sourceforge.stripes.validation.DoubleTypeConverter;
import net.sourceforge.stripes.validation.EnumeratedTypeConverter;
import net.sourceforge.stripes.validation.FloatTypeConverter;
import net.sourceforge.stripes.validation.IntegerTypeConverter;
import net.sourceforge.stripes.validation.LongTypeConverter;
import net.sourceforge.stripes.validation.ObjectTypeConverter;
import net.sourceforge.stripes.validation.ShortTypeConverter;
import net.sourceforge.stripes.validation.StringTypeConverter;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.TypeConverterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTypeConverterFactory
implements TypeConverterFactory {
    private static final Log log = Log.getInstance(DefaultTypeConverterFactory.class);
    private Map<Class<?>, Class<? extends TypeConverter<?>>> converters = new ConcurrentHashMap();
    private Map<Class<?>, Class<? extends TypeConverter<?>>> classCache = new ConcurrentHashMap();
    private Configuration configuration;

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
        this.converters.put(Boolean.class, BooleanTypeConverter.class);
        this.converters.put(Boolean.TYPE, BooleanTypeConverter.class);
        this.converters.put(Byte.class, ByteTypeConverter.class);
        this.converters.put(Byte.TYPE, ByteTypeConverter.class);
        this.converters.put(Short.class, ShortTypeConverter.class);
        this.converters.put(Short.TYPE, ShortTypeConverter.class);
        this.converters.put(Integer.class, IntegerTypeConverter.class);
        this.converters.put(Integer.TYPE, IntegerTypeConverter.class);
        this.converters.put(Long.class, LongTypeConverter.class);
        this.converters.put(Long.TYPE, LongTypeConverter.class);
        this.converters.put(Float.class, FloatTypeConverter.class);
        this.converters.put(Float.TYPE, FloatTypeConverter.class);
        this.converters.put(Double.class, DoubleTypeConverter.class);
        this.converters.put(Double.TYPE, DoubleTypeConverter.class);
        this.converters.put(Date.class, DateTypeConverter.class);
        this.converters.put(BigInteger.class, BigIntegerTypeConverter.class);
        this.converters.put(BigDecimal.class, BigDecimalTypeConverter.class);
        this.converters.put(Enum.class, EnumeratedTypeConverter.class);
        this.converters.put(String.class, StringTypeConverter.class);
        this.converters.put(Object.class, ObjectTypeConverter.class);
        this.converters.put(Character.class, CharacterTypeConverter.class);
        this.converters.put(Character.TYPE, CharacterTypeConverter.class);
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected Map<Class<?>, Class<? extends TypeConverter<?>>> getTypeConverters() {
        return this.converters;
    }

    @Override
    public void add(Class<?> targetType, Class<? extends TypeConverter<?>> converterClass) {
        this.converters.put(targetType, converterClass);
        this.clearCache();
    }

    @Override
    public TypeConverter getTypeConverter(Class forType, Locale locale) throws Exception {
        Class<? extends TypeConverter<?>> converterClass = this.findTypeConverterClass(forType);
        if (converterClass != null) {
            try {
                return this.getInstance(converterClass, locale);
            }
            catch (Exception e) {
                log.error(e, "Unable to instantiate type converter ", converterClass);
                return null;
            }
        }
        log.trace("Couldn't find a type converter for ", forType);
        return null;
    }

    protected Class<? extends TypeConverter<?>> findTypeConverterClass(Class<?> targetClass) {
        if (this.converters.containsKey(targetClass)) {
            return this.converters.get(targetClass);
        }
        if (this.classCache.containsKey(targetClass)) {
            return this.classCache.get(targetClass);
        }
        if (targetClass.isEnum()) {
            Class<? extends TypeConverter<?>> converterClass = this.findTypeConverterClass(Enum.class);
            if (converterClass != null) {
                return this.cacheTypeConverterClass(targetClass, converterClass);
            }
        } else {
            for (Annotation annotation : targetClass.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (!this.converters.containsKey(annotationType)) continue;
                return this.cacheTypeConverterClass(targetClass, this.converters.get(annotationType));
            }
        }
        return null;
    }

    protected Class<? extends TypeConverter<?>> cacheTypeConverterClass(Class<?> clazz, Class<? extends TypeConverter<?>> converterClass) {
        log.debug("Caching type converter for ", clazz, " => ", converterClass);
        this.classCache.put(clazz, converterClass);
        return converterClass;
    }

    protected void clearCache() {
        log.debug("Clearing type converter cache");
        this.classCache.clear();
    }

    @Override
    public TypeConverter getInstance(Class<? extends TypeConverter> clazz, Locale locale) throws Exception {
        TypeConverter converter = clazz.newInstance();
        converter.setLocale(locale);
        return converter;
    }
}

