/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationMetadata {
    private String property;
    private boolean encrypted;
    private boolean required;
    private boolean trim;
    private Set<String> on;
    private boolean onIsPositive;
    private boolean ignore;
    private Integer minlength;
    private Integer maxlength;
    private Double minvalue;
    private Double maxvalue;
    private Pattern mask;
    private String expression;
    private Class<? extends TypeConverter> converter;
    private String label;

    public ValidationMetadata(String property) {
        this.property = property;
    }

    public ValidationMetadata(String property, Validate validate) {
        this.property = property;
        this.encrypted(validate.encrypted());
        this.required(validate.required());
        this.trim(validate.trim());
        this.ignore(validate.ignore());
        if (validate.minlength() != -1) {
            this.minlength(validate.minlength());
        }
        if (validate.maxlength() != -1) {
            this.maxlength(validate.maxlength());
        }
        if (validate.minvalue() != Double.MIN_VALUE) {
            this.minvalue(validate.minvalue());
        }
        if (validate.maxvalue() != Double.MAX_VALUE) {
            this.maxvalue(validate.maxvalue());
        }
        if (!"".equals(validate.mask())) {
            this.mask(validate.mask());
        }
        if (validate.converter() != TypeConverter.class) {
            this.converter(validate.converter());
        }
        if (!"".equals(validate.expression())) {
            this.expression(validate.expression());
        }
        if (validate.on().length > 0) {
            this.on(validate.on());
        }
        if (!"".equals(validate.label())) {
            this.label = validate.label();
        }
    }

    public String getProperty() {
        return this.property;
    }

    public ValidationMetadata encrypted(boolean encrypted) {
        this.encrypted = encrypted;
        return this;
    }

    public boolean encrypted() {
        return this.encrypted;
    }

    public ValidationMetadata required(boolean required) {
        this.required = required;
        return this;
    }

    public boolean required() {
        return this.required;
    }

    public ValidationMetadata trim(boolean trim) {
        this.trim = trim;
        return this;
    }

    public boolean trim() {
        return this.trim;
    }

    public boolean requiredOn(String event) {
        return this.required && !this.ignore && (this.on == null || this.onIsPositive && this.on.contains(event) || !this.onIsPositive && !this.on.contains(event));
    }

    public ValidationMetadata ignore(boolean ignore) {
        this.ignore = ignore;
        return this;
    }

    public boolean ignore() {
        return this.ignore;
    }

    public ValidationMetadata minlength(Integer minlength) {
        this.minlength = minlength;
        return this;
    }

    public Integer minlength() {
        return this.minlength;
    }

    public ValidationMetadata maxlength(Integer maxlength) {
        this.maxlength = maxlength;
        return this;
    }

    public Integer maxlength() {
        return this.maxlength;
    }

    public ValidationMetadata minvalue(Double minvalue) {
        this.minvalue = minvalue;
        return this;
    }

    public Double minvalue() {
        return this.minvalue;
    }

    public ValidationMetadata maxvalue(Double maxvalue) {
        this.maxvalue = maxvalue;
        return this;
    }

    public Double maxvalue() {
        return this.maxvalue;
    }

    public ValidationMetadata mask(String mask) {
        this.mask = Pattern.compile(mask);
        return this;
    }

    public Pattern mask() {
        return this.mask;
    }

    public ValidationMetadata converter(Class<? extends TypeConverter> converter) {
        this.converter = converter;
        return this;
    }

    public Class<? extends TypeConverter> converter() {
        return this.converter;
    }

    public ValidationMetadata expression(String expression) {
        this.expression = expression;
        if (!this.expression.startsWith("${")) {
            this.expression = "${" + this.expression + "}";
        }
        return this;
    }

    public String expression() {
        return this.expression;
    }

    public ValidationMetadata on(String ... on) {
        if (on.length == 0) {
            this.on = null;
        } else {
            for (String s : on) {
                if (!s.isEmpty() && !"!".equals(s)) continue;
                throw new IllegalArgumentException("@Validate's \"on\" element must not contain empty strings");
            }
            this.on = new HashSet<String>();
            this.onIsPositive = on[0].charAt(0) != '!';
            for (String s : on) {
                if (this.onIsPositive) {
                    this.on.add(s);
                    continue;
                }
                this.on.add(s.substring(1));
            }
        }
        return this;
    }

    public Set<String> on() {
        return this.on;
    }

    public void label(String label) {
        this.label = label;
    }

    public String label() {
        return this.label;
    }

    public String toString() {
        return "ValidationMetadata{" + (this.required ? "required=" + this.required : "") + (this.encrypted ? "encrypted=" + this.encrypted : "") + (this.ignore ? ", ignore=" + this.ignore : "") + (this.minlength != null ? ", minlength=" + this.minlength : "") + (this.maxlength != null ? ", maxlength=" + this.maxlength : "") + (this.minvalue != null ? ", minvalue=" + this.minvalue : "") + (this.maxvalue != null ? ", maxvalue=" + this.maxvalue : "") + (this.mask != null ? ", mask=" + this.mask : "") + (this.expression != null ? ", expression='" + this.expression + '\'' : "") + (this.converter != null ? ", converter=" + this.converter.getSimpleName() : "") + (this.label != null ? ", label='" + this.label + '\'' : "") + '}';
    }
}

