/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.action;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.OnwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.controller.FlashScope;
import net.sourceforge.stripes.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedirectResolution
extends OnwardResolution<RedirectResolution>
implements Resolution {
    private static final Log log = Log.getInstance(RedirectResolution.class);
    private boolean prependContext = true;
    private boolean includeRequestParameters;
    private Collection<ActionBean> beans;

    public RedirectResolution(String url) {
        this(url, true);
    }

    public RedirectResolution(String url, boolean prependContext) {
        super(url);
        this.prependContext = prependContext;
    }

    public RedirectResolution(Class<? extends ActionBean> beanType) {
        super(beanType);
    }

    public RedirectResolution(Class<? extends ActionBean> beanType, String event) {
        super(beanType, event);
    }

    public RedirectResolution includeRequestParameters(boolean inc) {
        this.includeRequestParameters = inc;
        return this;
    }

    public RedirectResolution flash(ActionBean bean) {
        if (this.beans == null) {
            this.beans = new HashSet<ActionBean>();
        }
        this.beans.add(bean);
        return this;
    }

    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FlashScope flash;
        if (this.includeRequestParameters) {
            this.addParameters(request.getParameterMap());
        }
        if (this.beans != null) {
            flash = FlashScope.getCurrent(request, true);
            for (ActionBean bean : this.beans) {
                flash.put(bean);
            }
        }
        if ((flash = FlashScope.getCurrent(request, false)) != null) {
            this.addParameter("__fsk", flash.key());
        }
        String url = this.getUrl();
        if (this.prependContext && !"/".equals(request.getContextPath())) {
            url = request.getContextPath() + url;
        }
        url = response.encodeRedirectURL(url);
        log.trace("Redirecting ", this.beans == null ? "" : "(w/flashed bean) ", "to URL: ", url);
        response.sendRedirect(url);
    }
}

