/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.action;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.exception.StripesRuntimeException;

public class StreamingResolution
implements Resolution {
    private InputStream inputStream;
    private Reader reader;
    private String filename;
    private String contentType;
    private String characterEncoding;

    public StreamingResolution(String contentType) {
        this.contentType = contentType;
    }

    public StreamingResolution(String contentType, InputStream inputStream) {
        this.contentType = contentType;
        this.inputStream = inputStream;
    }

    public StreamingResolution(String contentType, Reader reader) {
        this.contentType = contentType;
        this.reader = reader;
    }

    public StreamingResolution(String contentType, String output) {
        this(contentType, new StringReader(output));
    }

    public StreamingResolution setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public final void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(this.contentType);
        if (this.characterEncoding != null) {
            response.setCharacterEncoding(this.characterEncoding);
        }
        if (this.filename != null) {
            response.setHeader("Content-disposition", "attachment; filename=" + this.filename);
        }
        this.stream(response);
    }

    protected void stream(HttpServletResponse response) throws Exception {
        int length = 0;
        if (this.reader != null) {
            char[] buffer = new char[512];
            PrintWriter out = response.getWriter();
            while ((length = this.reader.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            this.reader.close();
        } else if (this.inputStream != null) {
            byte[] buffer = new byte[512];
            ServletOutputStream out = response.getOutputStream();
            while ((length = this.inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            this.inputStream.close();
        } else {
            throw new StripesRuntimeException("A StreamingResolution was constructed without supplying a Reader or InputStream, but stream() was not overridden. Please either supply a source of streaming data, or override the stream() method.");
        }
    }
}

