/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.Expression;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.action.Wizard;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ActionBeanPropertyBinder;
import net.sourceforge.stripes.controller.ActionClassCache;
import net.sourceforge.stripes.controller.DelegatingVariableResolver;
import net.sourceforge.stripes.controller.DispatcherHelper;
import net.sourceforge.stripes.controller.ParameterName;
import net.sourceforge.stripes.controller.Row;
import net.sourceforge.stripes.controller.StripesRequestWrapper;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.CollectionUtil;
import net.sourceforge.stripes.util.CryptoUtil;
import net.sourceforge.stripes.util.HtmlUtil;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.ReflectUtil;
import net.sourceforge.stripes.util.bean.BeanUtil;
import net.sourceforge.stripes.util.bean.ExpressionException;
import net.sourceforge.stripes.util.bean.NoSuchPropertyException;
import net.sourceforge.stripes.util.bean.PropertyExpression;
import net.sourceforge.stripes.util.bean.PropertyExpressionEvaluation;
import net.sourceforge.stripes.validation.ScopedLocalizableError;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.Validate;
import net.sourceforge.stripes.validation.ValidateNestedProperties;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultActionBeanPropertyBinder
implements ActionBeanPropertyBinder {
    private static Log log = Log.getInstance(DefaultActionBeanPropertyBinder.class);
    private static Set<String> SPECIAL_KEYS = new HashSet<String>();
    private Map<Class<? extends ActionBean>, Map<String, Validate>> validations;
    private Map<Validate, Set<String>> validationEventMap;
    private Configuration configuration;

    @Override
    public void init(Configuration configuration) throws Exception {
        this.configuration = configuration;
        Set<Class<? extends ActionBean>> beanClasses = ActionClassCache.getInstance().getActionBeanClasses();
        this.validations = new HashMap<Class<? extends ActionBean>, Map<String, Validate>>();
        this.validationEventMap = new HashMap<Validate, Set<String>>();
        for (Class<? extends ActionBean> beanClass : beanClasses) {
            HashMap<String, Validate> fieldValidations = new HashMap<String, Validate>();
            this.processClassAnnotations(beanClass, fieldValidations);
            this.validations.put(beanClass, fieldValidations);
            for (Validate info : fieldValidations.values()) {
                Set events = null;
                if (info.on().length == 0) {
                    events = Collections.emptySet();
                } else {
                    events = new HashSet();
                    for (String event : info.on()) {
                        events.add(event);
                    }
                }
                this.validationEventMap.put(info, events);
            }
            StringBuilder builder = new StringBuilder(128);
            for (Map.Entry entry : fieldValidations.entrySet()) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append((String)entry.getKey());
                builder.append("->");
                builder.append(ReflectUtil.toString((Annotation)entry.getValue()));
            }
            log.debug("Loaded validations for ActionBean ", beanClass.getSimpleName(), ": ", builder.length() > 0 ? builder : "<none>");
        }
    }

    protected void processClassAnnotations(Class clazz, Map<String, Validate> fieldValidations) {
        Field[] fields;
        Validate[] validations;
        Method[] methods;
        Class superclass = clazz.getSuperclass();
        if (superclass != null) {
            this.processClassAnnotations(superclass, fieldValidations);
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            ValidateNestedProperties nested;
            if (!Modifier.isPublic(method.getModifiers())) continue;
            Validate validation = method.getAnnotation(Validate.class);
            if (validation != null) {
                String fieldName = this.getPropertyName(method.getName());
                fieldValidations.put(fieldName, validation);
            }
            if ((nested = method.getAnnotation(ValidateNestedProperties.class)) == null) continue;
            String fieldName = this.getPropertyName(method.getName());
            for (Validate nestedValidate : validations = nested.value()) {
                if ("".equals(nestedValidate.field())) {
                    log.warn("Nested validation used without field name: ", validation);
                    continue;
                }
                fieldValidations.put(fieldName + "." + nestedValidate.field(), nestedValidate);
            }
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            ValidateNestedProperties nested;
            Validate validation = field.getAnnotation(Validate.class);
            if (validation != null) {
                fieldValidations.put(field.getName(), validation);
            }
            if ((nested = field.getAnnotation(ValidateNestedProperties.class)) == null) continue;
            for (Validate nestedValidate : validations = nested.value()) {
                if ("".equals(nestedValidate.field())) {
                    log.warn("Nested validation used without field name: ", validation);
                    continue;
                }
                fieldValidations.put(field.getName() + "." + nestedValidate.field(), nestedValidate);
            }
        }
    }

    @Override
    public ValidationErrors bind(ActionBean bean, ActionBeanContext context, boolean validate) {
        ValidationErrors fieldErrors = context.getValidationErrors();
        SortedMap<ParameterName, String[]> parameters = this.getParameters(context);
        if (validate) {
            this.validateRequiredFields(parameters, bean, fieldErrors);
        }
        TreeMap<ParameterName, List<Object>> allConvertedFields = new TreeMap<ParameterName, List<Object>>();
        for (Map.Entry entry : parameters.entrySet()) {
            List<Object> convertedValues = null;
            ParameterName name = (ParameterName)entry.getKey();
            try {
                String pname = name.getName();
                if (SPECIAL_KEYS.contains(pname) || pname.equals(context.getEventName()) || fieldErrors.containsKey(pname)) continue;
                log.trace("Running binding for property with name: ", name);
                Validate validationInfo = this.validations.get(bean.getClass()).get(name.getStrippedName());
                PropertyExpressionEvaluation eval = new PropertyExpressionEvaluation(PropertyExpression.getExpression(pname), bean);
                Class type = eval.getType();
                Class scalarType = eval.getScalarType();
                if (!this.isBindingAllowed(eval)) continue;
                if (type == null && (validationInfo == null || validationInfo.converter() == null)) {
                    log.trace("Could not find type for property '", name.getName(), "' of '", bean.getClass().getSimpleName(), "' probably because it's not ", "a property of the bean.  Skipping binding.");
                    continue;
                }
                String[] values = (String[])entry.getValue();
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                if (validationInfo != null && validationInfo.ignore()) continue;
                if (validate && validationInfo != null) {
                    this.doPreConversionValidations(name, values, validationInfo, errors);
                }
                convertedValues = this.convert(bean, name, values, scalarType, validationInfo, errors);
                allConvertedFields.put(name, convertedValues);
                if (errors.size() > 0) {
                    fieldErrors.addAll(name.getName(), errors);
                    continue;
                }
                if (convertedValues.size() > 0) {
                    this.bindNonNullValue(bean, eval, convertedValues, type, scalarType);
                    continue;
                }
                this.bindNullValue(bean, name.getName(), type);
            }
            catch (Exception e) {
                this.handlePropertyBindingError(bean, name, convertedValues, e, fieldErrors);
            }
        }
        this.bindMissingValuesAsNull(bean, context);
        StripesRequestWrapper request = StripesRequestWrapper.findStripesWrapper((ServletRequest)context.getRequest());
        if (request.isMultipart()) {
            Enumeration<String> fileParameterNames = request.getFileParameterNames();
            while (fileParameterNames.hasMoreElements()) {
                String fileParameterName = fileParameterNames.nextElement();
                FileBean fileBean = request.getFileParameterValue(fileParameterName);
                log.trace("Attempting to bind file parameter with name [", fileParameterName, "] and value: ", fileBean);
                if (fileBean == null) continue;
                try {
                    this.bind(bean, fileParameterName, fileBean);
                }
                catch (Exception e) {
                    log.debug(e, "Could not bind file property with name [", fileParameterName, "] and value: ", fileBean);
                }
            }
        }
        if (validate) {
            this.doPostConversionValidations(bean, allConvertedFields, fieldErrors);
        }
        return fieldErrors;
    }

    protected boolean isBindingAllowed(PropertyExpressionEvaluation eval) {
        Type firstNodeType = eval.getRootNode().getValueType();
        return !(firstNodeType instanceof Class) || !ActionBeanContext.class.isAssignableFrom((Class)firstNodeType);
    }

    protected void handlePropertyBindingError(ActionBean bean, ParameterName name, List<Object> values, Exception e, ValidationErrors errors) {
        if (e instanceof NoSuchPropertyException) {
            NoSuchPropertyException nspe = (NoSuchPropertyException)e;
            log.debug("Could not bind property with name [", name, "] to bean of type: ", bean.getClass().getSimpleName(), " : ", nspe.getMessage());
        } else {
            log.debug(e, "Could not bind property with name [", name, "] to bean of type: ", bean.getClass().getSimpleName());
        }
    }

    protected void bindMissingValuesAsNull(ActionBean bean, ActionBeanContext context) {
        HttpServletRequest request = context.getRequest();
        Set paramatersSubmitted = request.getParameterMap().keySet();
        for (String name : this.getFieldsPresentInfo(bean)) {
            if (paramatersSubmitted.contains(name)) continue;
            try {
                BeanUtil.setPropertyToNull(name, bean);
            }
            catch (Exception e) {
                this.handlePropertyBindingError(bean, new ParameterName(name), null, e, context.getValidationErrors());
            }
        }
    }

    protected Collection<String> getFieldsPresentInfo(ActionBean bean) {
        boolean isWizard;
        ActionBeanContext ctx = bean.getContext();
        HttpServletRequest request = ctx.getRequest();
        String fieldsPresent = request.getParameter("__fp");
        Wizard wizard = bean.getClass().getAnnotation(Wizard.class);
        boolean bl = isWizard = wizard != null;
        if (fieldsPresent == null || "".equals(fieldsPresent)) {
            if (isWizard && !CollectionUtil.contains(wizard.startEvents(), ctx.getEventName())) {
                throw new StripesRuntimeException("Submission of a wizard form in Stripes absolutely requires that the hidden field Stripes writes containing the names of the fields present on the form is present and encrypted (as Stripes write it). This is necessary to prevent a user from spoofing the system and getting around any security/data checks.");
            }
            return Collections.emptySet();
        }
        try {
            fieldsPresent = CryptoUtil.decrypt(fieldsPresent, request);
        }
        catch (GeneralSecurityException gse) {
            if (isWizard) {
                throw new StripesRuntimeException("Stripes attmpted and failed to decrypt the non-null value in the 'fields present' field. Because this form submission is a wizard this situation cannot be accepted as it could result in a security problem. It is usually the result of either tampering with hidden field values, or session expiration.", gse);
            }
            return Collections.emptySet();
        }
        return HtmlUtil.splitValues(fieldsPresent);
    }

    protected void bindNonNullValue(ActionBean bean, PropertyExpressionEvaluation propertyEvaluation, List<Object> valueOrValues, Class targetType, Class scalarType) throws Exception {
        Class<?> valueType = valueOrValues.iterator().next().getClass();
        if (targetType.isArray() && !valueType.isArray()) {
            Object typedArray = Array.newInstance(scalarType, valueOrValues.size());
            for (int i = 0; i < valueOrValues.size(); ++i) {
                Array.set(typedArray, i, valueOrValues.get(i));
            }
            propertyEvaluation.setValue(typedArray);
        } else if (Collection.class.isAssignableFrom(targetType) && !Collection.class.isAssignableFrom(valueType)) {
            Collection collection = null;
            collection = targetType.isInterface() ? (Collection)ReflectUtil.getInterfaceInstance(targetType) : (Collection)targetType.newInstance();
            collection.addAll(valueOrValues);
            propertyEvaluation.setValue(collection);
        } else {
            propertyEvaluation.setValue(valueOrValues.get(0));
        }
    }

    protected void bindNullValue(ActionBean bean, String property, Class type) throws ExpressionException {
        BeanUtil.setPropertyToNull(property, bean);
    }

    protected SortedMap<ParameterName, String[]> getParameters(ActionBeanContext context) {
        Map requestParameters = context.getRequest().getParameterMap();
        TreeMap<ParameterName, String[]> parameters = new TreeMap<ParameterName, String[]>();
        for (Map.Entry entry : requestParameters.entrySet()) {
            parameters.put(new ParameterName(((String)entry.getKey()).trim()), (String[])entry.getValue());
        }
        return parameters;
    }

    @Override
    public void bind(ActionBean bean, String propertyName, Object propertyValue) throws Exception {
        BeanUtil.setPropertyValue(propertyName, bean, propertyValue);
    }

    protected String getPropertyName(String methodName) {
        return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
    }

    protected void validateRequiredFields(Map<ParameterName, String[]> parameters, ActionBean bean, ValidationErrors errors) {
        String[] values;
        log.debug("Running required field validation on bean class ", bean.getClass().getName());
        HashSet<String> indexedParams = new HashSet<String>();
        for (ParameterName name : parameters.keySet()) {
            if (!name.isIndexed()) continue;
            indexedParams.add(name.getStrippedName());
        }
        Map<String, Validate> validationInfos = this.validations.get(bean.getClass());
        StripesRequestWrapper req = StripesRequestWrapper.findStripesWrapper((ServletRequest)bean.getContext().getRequest());
        if (validationInfos != null) {
            boolean wizard = bean.getClass().getAnnotation(Wizard.class) != null;
            Collection<String> fieldsOnPage = this.getFieldsPresentInfo(bean);
            for (Map.Entry<String, Validate> entry : validationInfos.entrySet()) {
                String propertyName = entry.getKey();
                Validate validationInfo = entry.getValue();
                if (!validationInfo.required() || indexedParams.contains(propertyName) || !this.applies(validationInfo, bean.getContext()) || wizard && !fieldsOnPage.contains(propertyName)) continue;
                values = bean.getContext().getRequest().getParameterValues(propertyName);
                log.debug("Checking required field: ", propertyName, ", with values: ", values);
                this.checkSingleRequiredField(propertyName, propertyName, values, req, errors);
            }
        }
        if (indexedParams.size() > 0) {
            HashMap<String, Row> rows = new HashMap<String, Row>();
            for (Map.Entry<ParameterName, String[]> entry : parameters.entrySet()) {
                ParameterName name = entry.getKey();
                String[] values2 = entry.getValue();
                if (!name.isIndexed()) continue;
                String rowKey = name.getName().substring(0, name.getName().indexOf(93) + 1);
                if (!rows.containsKey(rowKey)) {
                    rows.put(rowKey, new Row());
                }
                ((Row)rows.get(rowKey)).put(name, values2);
            }
            for (Row row : rows.values()) {
                if (row.hasNonEmptyValues()) {
                    for (Map.Entry entry : row.entrySet()) {
                        ParameterName name = (ParameterName)entry.getKey();
                        values = (String[])entry.getValue();
                        Validate validationInfo = validationInfos.get(name.getStrippedName());
                        if (validationInfo == null || !validationInfo.required() || !this.applies(validationInfo, bean.getContext())) continue;
                        this.checkSingleRequiredField(name.getName(), name.getStrippedName(), values, req, errors);
                    }
                    continue;
                }
                for (ParameterName name : row.keySet()) {
                    parameters.remove(name);
                }
            }
        }
    }

    protected void checkSingleRequiredField(String name, String strippedName, String[] values, StripesRequestWrapper req, ValidationErrors errors) {
        FileBean file = null;
        if (req.isMultipart() && (file = req.getFileParameterValue(name)) != null) {
            if (file.getSize() <= 0L) {
                errors.add(name, new ScopedLocalizableError("validation.required", "valueNotPresent", new Object[0]));
            }
        } else if (values == null || values.length == 0) {
            ScopedLocalizableError error = new ScopedLocalizableError("validation.required", "valueNotPresent", new Object[0]);
            error.setFieldValue(null);
            errors.add(name, error);
        } else {
            for (String value : values) {
                if (value.length() != 0) continue;
                ScopedLocalizableError error = new ScopedLocalizableError("validation.required", "valueNotPresent", new Object[0]);
                error.setFieldValue(value);
                errors.add(name, error);
            }
        }
    }

    protected void doPreConversionValidations(ParameterName propertyName, String[] values, Validate validationInfo, List<ValidationError> errors) {
        for (String value : values) {
            ScopedLocalizableError error;
            if (value == null || value.length() <= 0) continue;
            if (validationInfo.minlength() != -1 && value.length() < validationInfo.minlength()) {
                error = new ScopedLocalizableError("validation.minlength", "valueTooShort", validationInfo.minlength());
                error.setFieldValue(value);
                errors.add(error);
            }
            if (validationInfo.maxlength() != -1 && value.length() > validationInfo.maxlength()) {
                error = new ScopedLocalizableError("validation.maxlength", "valueTooLong", validationInfo.maxlength());
                error.setFieldValue(value);
                errors.add(error);
            }
            if (validationInfo.mask().length() <= 0 || Pattern.compile(validationInfo.mask()).matcher(value).matches()) continue;
            error = new ScopedLocalizableError("validation.mask", "valueDoesNotMatch", new Object[0]);
            error.setFieldValue(value);
            errors.add(error);
        }
    }

    protected void doPostConversionValidations(ActionBean bean, Map<ParameterName, List<Object>> convertedValues, ValidationErrors errors) {
        for (Map.Entry<ParameterName, List<Object>> entry : convertedValues.entrySet()) {
            ParameterName name = entry.getKey();
            List<Object> values = entry.getValue();
            Validate validationInfo = this.validations.get(bean.getClass()).get(name.getStrippedName());
            if (values.size() == 0 || validationInfo == null) continue;
            for (Object value : values) {
                ScopedLocalizableError error;
                if (!(value instanceof Number)) continue;
                Number number = (Number)value;
                if (validationInfo.minvalue() != Double.MIN_VALUE && number.doubleValue() < validationInfo.minvalue()) {
                    error = new ScopedLocalizableError("validation.minvalue", "valueBelowMinimum", validationInfo.minvalue());
                    error.setFieldValue(String.valueOf(value));
                    errors.add(name.getName(), error);
                }
                if (validationInfo.maxvalue() == Double.MAX_VALUE || !(number.doubleValue() > validationInfo.maxvalue())) continue;
                error = new ScopedLocalizableError("validation.maxvalue", "valueAboveMaximum", validationInfo.maxvalue());
                error.setFieldValue(String.valueOf(value));
                errors.add(name.getName(), error);
            }
            this.doExpressionValidation(bean, name, values, validationInfo, errors);
        }
    }

    protected void doExpressionValidation(ActionBean bean, ParameterName name, List<Object> values, Validate validationInfo, ValidationErrors errors) {
        Expression expr = null;
        DelegatingVariableResolver resolver = null;
        if (!"".equals(validationInfo.expression())) {
            PageContext context = DispatcherHelper.getPageContext();
            if (context == null) {
                log.error("Could not process expression based validation. It would seem that ", "your servlet container is being mean and will not let the dispatcher ", "servlet manufacture a PageContext object through the JSPFactory. The ", "result of this is that expression validation will be disabled. Sorry.");
            } else {
                try {
                    String expression = validationInfo.expression();
                    if (!expression.startsWith("${")) {
                        expression = "${" + expression + "}";
                    }
                    ExpressionEvaluator evaluator = context.getExpressionEvaluator();
                    expr = evaluator.parseExpression(expression, Boolean.class, null);
                    resolver = new DelegatingVariableResolver(bean, context.getVariableResolver());
                }
                catch (ELException ele) {
                    throw new StripesRuntimeException("Could not parse the EL expression being used to validate field " + name.getName() + ". This is " + "not a transient error. Please double check the following expression " + "for errors: " + validationInfo.expression(), ele);
                }
            }
        }
        for (Object value : values) {
            if (expr == null) continue;
            try {
                resolver.setCurrentValue(value);
                Boolean result = (Boolean)expr.evaluate((VariableResolver)resolver);
                if (Boolean.TRUE.equals(result)) continue;
                ScopedLocalizableError error = new ScopedLocalizableError("validation.expression", "valueFailedExpression", new Object[0]);
                error.setFieldValue(String.valueOf(value));
                errors.add(name.getName(), error);
            }
            catch (ELException ele) {
                log.error("Error evaluating expression for property ", name.getName(), " of class ", bean.getClass().getSimpleName(), ". Expression: ", validationInfo.expression());
            }
        }
    }

    protected boolean applies(Validate info, ActionBeanContext context) {
        Set<String> events = this.validationEventMap.get(info);
        String current = context.getEventName();
        if (info.on().length == 0 || current == null) {
            return true;
        }
        if (info.on()[0].startsWith("!")) {
            return !events.contains("!" + current);
        }
        return events.contains(current);
    }

    private List<Object> convert(ActionBean bean, ParameterName propertyName, String[] values, Class propertyType, Validate validationInfo, List<ValidationError> errors) throws Exception {
        ArrayList<Object> returns = new ArrayList<Object>();
        TypeConverter converter = null;
        converter = validationInfo != null && validationInfo.converter() != TypeConverter.class ? this.configuration.getTypeConverterFactory().getInstance(validationInfo.converter(), bean.getContext().getRequest().getLocale()) : this.configuration.getTypeConverterFactory().getTypeConverter(propertyType, bean.getContext().getRequest().getLocale());
        log.debug("Converting ", values.length, " value(s) using converter ", converter);
        for (int i = 0; i < values.length; ++i) {
            if ("".equals(values[i])) continue;
            try {
                Object retval = null;
                if (converter != null) {
                    retval = converter.convert(values[i], propertyType, errors);
                } else {
                    Constructor constructor = propertyType.getConstructor(String.class);
                    if (constructor != null) {
                        retval = constructor.newInstance(values[i]);
                    } else {
                        log.debug("Could not find a way to convert the parameter ", propertyName.getName(), " to a ", propertyType.getSimpleName(), ". No TypeConverter could be found and the class does not ", "have a constructor that takes a single String parameter.");
                    }
                }
                if (retval != null) {
                    returns.add(retval);
                }
                for (ValidationError error : errors) {
                    error.setFieldName(propertyName.getStrippedName());
                    error.setFieldValue(values[i]);
                }
                continue;
            }
            catch (Exception e) {
                log.warn(e, "Looks like type converter ", converter, " threw an exception.");
            }
        }
        return returns;
    }

    static {
        SPECIAL_KEYS.add("_sourcePage");
        SPECIAL_KEYS.add("__fp");
        SPECIAL_KEYS.add("__fsk");
        SPECIAL_KEYS.add("_eventName");
    }
}

