/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.util.bean.BeanUtil;

class DelegatingVariableResolver
implements VariableResolver {
    private ActionBean bean;
    private VariableResolver delegate;
    private Object currentValue;

    DelegatingVariableResolver(ActionBean bean, VariableResolver resolver) {
        this.bean = bean;
        this.delegate = resolver;
    }

    void setCurrentValue(Object value) {
        this.currentValue = value;
    }

    public Object resolveVariable(String property) throws ELException {
        if ("this".equals(property)) {
            return this.currentValue;
        }
        if ("actionBean".equals(property)) {
            return this.bean;
        }
        Object result = null;
        try {
            result = BeanUtil.getPropertyValue(property, this.bean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            result = this.delegate.resolveVariable(property);
        }
        return result;
    }
}

