/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DontValidate;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ActionBeanPropertyBinder;
import net.sourceforge.stripes.controller.ActionResolver;
import net.sourceforge.stripes.controller.ExecutionContext;
import net.sourceforge.stripes.controller.Interceptor;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.HtmlUtil;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.Validatable;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrorHandler;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMethod;
import net.sourceforge.stripes.validation.ValidationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatcherHelper {
    private static final Log log = Log.getInstance(DispatcherHelper.class);
    private static final Map<Class, WeakReference<Method[]>> customValidations = Collections.synchronizedMap(new WeakHashMap());
    private static ThreadLocal<PageContext> pageContextStash = new ThreadLocal();

    public static void setPageContext(PageContext ctx) {
        pageContextStash.set(ctx);
    }

    public static PageContext getPageContext() {
        return pageContextStash.get();
    }

    public static Resolution resolveActionBean(ExecutionContext ctx) throws Exception {
        return ctx.wrap(new Interceptor(){

            public Resolution intercept(ExecutionContext ctx) throws Exception {
                ActionBeanContext context = ctx.getActionBeanContext();
                ActionBean bean = StripesFilter.getConfiguration().getActionResolver().getActionBean(context);
                ctx.setActionBean(bean);
                HttpServletRequest request = context.getRequest();
                request.setAttribute("actionBean", (Object)bean);
                return null;
            }
        });
    }

    public static Resolution resolveHandler(ExecutionContext ctx) throws Exception {
        final Configuration config = StripesFilter.getConfiguration();
        ctx.setLifecycleStage(LifecycleStage.HandlerResolution);
        ctx.setInterceptors(config.getInterceptors(LifecycleStage.HandlerResolution));
        return ctx.wrap(new Interceptor(){

            public Resolution intercept(ExecutionContext ctx) throws Exception {
                Method handler;
                ActionBean bean = ctx.getActionBean();
                ActionBeanContext context = ctx.getActionBeanContext();
                ActionResolver resolver = config.getActionResolver();
                String eventName = resolver.getEventName(bean.getClass(), context);
                context.setEventName(eventName);
                if (eventName != null) {
                    handler = resolver.getHandler(bean.getClass(), eventName);
                } else {
                    handler = resolver.getDefaultHandler(bean.getClass());
                    if (handler != null) {
                        context.setEventName(resolver.getHandledEvent(handler));
                    }
                }
                if (handler == null) {
                    throw new StripesServletException("No handler method found for request with  ActionBean [" + bean.getClass().getName() + "] and eventName [ " + eventName + "]");
                }
                log.debug("Resolved event: ", context.getEventName(), "; will invoke: ", bean.getClass().getSimpleName(), ".", handler.getName(), "()");
                ctx.setHandler(handler);
                return null;
            }
        });
    }

    public static Resolution doBindingAndValidation(ExecutionContext ctx, boolean validate) throws Exception {
        final boolean doValidate = validate && ctx.getHandler().getAnnotation(DontValidate.class) == null;
        final Configuration config = StripesFilter.getConfiguration();
        ctx.setLifecycleStage(LifecycleStage.BindingAndValidation);
        ctx.setInterceptors(config.getInterceptors(LifecycleStage.BindingAndValidation));
        return ctx.wrap(new Interceptor(){

            public Resolution intercept(ExecutionContext ctx) throws Exception {
                ActionBeanPropertyBinder binder = config.getActionBeanPropertyBinder();
                binder.bind(ctx.getActionBean(), ctx.getActionBeanContext(), doValidate);
                return null;
            }
        });
    }

    public static Resolution doCustomValidation(final ExecutionContext ctx, final boolean alwaysInvokeValidate) throws Exception {
        final ValidationErrors errors = ctx.getActionBeanContext().getValidationErrors();
        final ActionBean bean = ctx.getActionBean();
        boolean doValidate = ctx.getHandler().getAnnotation(DontValidate.class) == null;
        Configuration config = StripesFilter.getConfiguration();
        if (doValidate) {
            ctx.setLifecycleStage(LifecycleStage.CustomValidation);
            ctx.setInterceptors(config.getInterceptors(LifecycleStage.CustomValidation));
            return ctx.wrap(new Interceptor(){

                public Resolution intercept(ExecutionContext context) throws Exception {
                    Method[] validations;
                    if ((alwaysInvokeValidate || errors.isEmpty()) && bean instanceof Validatable) {
                        ((Validatable)((Object)bean)).validate(errors);
                    }
                    for (Method validation : validations = DispatcherHelper.findCustomValidationMethods(bean.getClass())) {
                        boolean run;
                        ValidationMethod ann = validation.getAnnotation(ValidationMethod.class);
                        boolean bl = run = ann.when() == ValidationState.ALWAYS || ann.when() == ValidationState.DEFAULT && alwaysInvokeValidate || errors.isEmpty();
                        if (!run || !DispatcherHelper.applies(ann, ctx.getActionBeanContext().getEventName())) continue;
                        Class<?>[] args = validation.getParameterTypes();
                        if (args.length == 1 && args[0].equals(ValidationErrors.class)) {
                            validation.invoke((Object)bean, errors);
                            continue;
                        }
                        validation.invoke((Object)bean, new Object[0]);
                    }
                    return null;
                }
            });
        }
        return null;
    }

    public static boolean applies(ValidationMethod info, String event) {
        String[] events = info.on();
        if (events.length == 0 || event == null) {
            return true;
        }
        if (events[0].startsWith("!")) {
            return !DispatcherHelper.contains(events, "!" + event);
        }
        return DispatcherHelper.contains(events, event);
    }

    private static boolean contains(String[] arr, String target) {
        for (String item : arr) {
            if (!item.equals(target)) continue;
            return true;
        }
        return false;
    }

    public static Method[] findCustomValidationMethods(Class<? extends ActionBean> type) throws Exception {
        Method[] validations = null;
        WeakReference<Method[]> ref = customValidations.get(type);
        if (ref != null) {
            validations = (Method[])ref.get();
        }
        if (validations == null) {
            TreeSet<Method> validationMethods = new TreeSet<Method>(new Comparator<Method>(){

                @Override
                public int compare(Method o1, Method o2) {
                    if (o1.getName().equals(o2.getName()) && Arrays.equals(o1.getParameterTypes(), o2.getParameterTypes())) {
                        return 0;
                    }
                    ValidationMethod ann1 = o1.getAnnotation(ValidationMethod.class);
                    ValidationMethod ann2 = o2.getAnnotation(ValidationMethod.class);
                    int returnValue = new Integer(ann1.priority()).compareTo(ann2.priority());
                    if (returnValue == 0) {
                        returnValue = o1.getName().compareTo(o2.getName());
                    }
                    return returnValue;
                }
            });
            for (Class<? extends ActionBean> temp = type; temp != null; temp = temp.getSuperclass()) {
                for (Method method : temp.getDeclaredMethods()) {
                    if (method.getAnnotation(ValidationMethod.class) == null) continue;
                    validationMethods.add(method);
                }
            }
            validations = validationMethods.toArray(new Method[validationMethods.size()]);
            customValidations.put(type, new WeakReference<Method[]>(validations));
        }
        return validations;
    }

    public static Resolution handleValidationErrors(ExecutionContext ctx) throws Exception {
        ActionBean bean = ctx.getActionBean();
        ActionBeanContext context = ctx.getActionBeanContext();
        ValidationErrors errors = context.getValidationErrors();
        Resolution resolution = null;
        DispatcherHelper.fillInValidationErrors(ctx);
        if (errors.size() > 0 && bean instanceof ValidationErrorHandler) {
            resolution = ((ValidationErrorHandler)((Object)bean)).handleValidationErrors(errors);
        }
        if (errors.size() > 0 && resolution == null) {
            resolution = context.getSourcePageResolution();
        }
        return resolution;
    }

    public static void fillInValidationErrors(ExecutionContext ctx) {
        ActionBeanContext context = ctx.getActionBeanContext();
        ValidationErrors errors = context.getValidationErrors();
        if (errors.size() > 0) {
            String formAction = StripesFilter.getConfiguration().getActionResolver().getUrlBinding(ctx.getActionBean().getClass());
            HttpServletRequest request = ctx.getActionBeanContext().getRequest();
            for (Map.Entry entry : errors.entrySet()) {
                String parameterName = (String)entry.getKey();
                List listOfErrors = (List)entry.getValue();
                for (ValidationError error : listOfErrors) {
                    if (error.getActionPath() != null) continue;
                    error.setActionPath(formAction);
                    if (error.getFieldValue() == null) {
                        error.setFieldValue(HtmlUtil.encode(request.getParameter(parameterName)));
                        continue;
                    }
                    error.setFieldValue(HtmlUtil.encode(error.getFieldValue()));
                }
            }
        }
    }

    public static Resolution invokeEventHandler(ExecutionContext ctx) throws Exception {
        Configuration config = StripesFilter.getConfiguration();
        final Method handler = ctx.getHandler();
        final ActionBean bean = ctx.getActionBean();
        ctx.setLifecycleStage(LifecycleStage.EventHandling);
        ctx.setInterceptors(config.getInterceptors(LifecycleStage.EventHandling));
        return ctx.wrap(new Interceptor(){

            public Resolution intercept(ExecutionContext ctx) throws Exception {
                Object returnValue = handler.invoke((Object)bean, new Object[0]);
                if (returnValue != null && returnValue instanceof Resolution) {
                    return (Resolution)returnValue;
                }
                if (returnValue != null) {
                    log.warn("Expected handler method ", handler.getName(), " on class ", bean.getClass().getSimpleName(), " to return a Resolution. Instead it ", "returned: ", returnValue);
                }
                return null;
            }
        });
    }

    public static void executeResolution(ExecutionContext ctx, Resolution resolution) throws Exception {
        Configuration config = StripesFilter.getConfiguration();
        ctx.setLifecycleStage(LifecycleStage.ResolutionExecution);
        ctx.setInterceptors(config.getInterceptors(LifecycleStage.ResolutionExecution));
        ctx.setResolution(resolution);
        Resolution retval = ctx.wrap(new Interceptor(){

            public Resolution intercept(ExecutionContext context) throws Exception {
                ActionBeanContext abc = context.getActionBeanContext();
                Resolution resolution = context.getResolution();
                if (resolution != null) {
                    resolution.execute(abc.getRequest(), abc.getResponse());
                }
                return null;
            }
        });
        if (retval != null) {
            log.warn("An interceptor wrapping LifecycleStage.ResolutionExecution returned ", "a Resolution. This almost certainly did NOT have the desired effect. ", "At this LifecycleStage interceptors are running *around* the actual ", "execution of the Resolution, and so returning an alternate Resolution ", "has the effect of stopping the original Resolution from being executed ", "while NOT causing the alternate Resolution to get executed. Interceptor ", "code running before the Resolution is executed (i.e. before calling ", "ExecutionContext.proceed()) can alter the Resolution by calling ", "ExecutionContext.setResolution() instead. Code running after the Resolution ", "has been executed can no longer alter what Resolution is executed for ", "what are hopefully obvious reasons!");
        }
    }
}

