/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Stack;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.DispatcherHelper;
import net.sourceforge.stripes.controller.ExecutionContext;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.BooleanTypeConverter;

public class DispatcherServlet
extends HttpServlet {
    public static final String RUN_CUSTOM_VALIDATION_WHEN_ERRORS = "Validation.InvokeValidateWhenErrorsExist";
    private Boolean alwaysInvokeValidate;
    private static Log log = Log.getInstance(DispatcherServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        block13: {
            this.doOneTimeConfiguration();
            log.trace("Dispatching request to URL: ", request.getRequestURI());
            PageContext pageContext = null;
            try {
                Configuration config = StripesFilter.getConfiguration();
                ActionBeanContext context = config.getActionBeanContextFactory().getContextInstance(request, response);
                context.setServletContext(this.getServletContext());
                ExecutionContext ctx = new ExecutionContext();
                ctx.setInterceptors(config.getInterceptors(LifecycleStage.ActionBeanResolution));
                ctx.setLifecycleStage(LifecycleStage.ActionBeanResolution);
                ctx.setActionBeanContext(context);
                try {
                    ActionBeanContext abc = ctx.getActionBeanContext();
                    pageContext = JspFactory.getDefaultFactory().getPageContext((Servlet)this, (ServletRequest)abc.getRequest(), (ServletResponse)abc.getResponse(), null, true, abc.getResponse().getBufferSize(), true);
                    DispatcherHelper.setPageContext(pageContext);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.saveActionBean(request);
                Resolution resolution = this.resolveActionBean(ctx);
                if (resolution == null && (resolution = this.resolveHandler(ctx)) == null && (resolution = this.doBindingAndValidation(ctx)) == null && (resolution = this.doCustomValidation(ctx)) == null && (resolution = this.handleValidationErrors(ctx)) == null) {
                    resolution = this.invokeEventHandler(ctx);
                    DispatcherHelper.fillInValidationErrors(ctx);
                }
                if (resolution != null) {
                    this.executeResolution(ctx, resolution);
                }
                if (pageContext == null) break block13;
            }
            catch (ServletException se) {
                try {
                    throw se;
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (InvocationTargetException ite) {
                        if (ite.getTargetException() instanceof ServletException) {
                            throw (ServletException)ite.getTargetException();
                        }
                        if (!(ite.getTargetException() instanceof RuntimeException)) throw new StripesServletException("ActionBean execution threw an exception.", ite.getTargetException());
                        throw (RuntimeException)ite.getTargetException();
                    }
                    catch (Exception e) {
                        throw new StripesServletException("Exception encountered processing request.", e);
                    }
                }
                catch (Throwable throwable) {
                    if (pageContext != null) {
                        JspFactory.getDefaultFactory().releasePageContext(pageContext);
                        DispatcherHelper.setPageContext(null);
                    }
                    this.restoreActionBean(request);
                    throw throwable;
                }
            }
            JspFactory.getDefaultFactory().releasePageContext(pageContext);
            DispatcherHelper.setPageContext(null);
        }
        this.restoreActionBean(request);
    }

    protected Resolution resolveActionBean(ExecutionContext ctx) throws Exception {
        return DispatcherHelper.resolveActionBean(ctx);
    }

    protected Resolution resolveHandler(ExecutionContext ctx) throws Exception {
        return DispatcherHelper.resolveHandler(ctx);
    }

    protected Resolution doBindingAndValidation(ExecutionContext ctx) throws Exception {
        return DispatcherHelper.doBindingAndValidation(ctx, true);
    }

    protected Resolution doCustomValidation(ExecutionContext ctx) throws Exception {
        return DispatcherHelper.doCustomValidation(ctx, this.alwaysInvokeValidate);
    }

    protected Resolution handleValidationErrors(ExecutionContext ctx) throws Exception {
        return DispatcherHelper.handleValidationErrors(ctx);
    }

    protected Resolution invokeEventHandler(ExecutionContext ctx) throws Exception {
        return DispatcherHelper.invokeEventHandler(ctx);
    }

    protected void executeResolution(ExecutionContext ctx, Resolution resolution) throws Exception {
        DispatcherHelper.executeResolution(ctx, resolution);
    }

    private void doOneTimeConfiguration() {
        if (this.alwaysInvokeValidate == null) {
            String callValidateWhenErrorsExist = StripesFilter.getConfiguration().getBootstrapPropertyResolver().getProperty(RUN_CUSTOM_VALIDATION_WHEN_ERRORS);
            if (callValidateWhenErrorsExist != null) {
                BooleanTypeConverter c = new BooleanTypeConverter();
                this.alwaysInvokeValidate = c.convert(callValidateWhenErrorsExist, Boolean.class, (Collection)null);
            } else {
                this.alwaysInvokeValidate = false;
            }
        }
    }

    protected Stack getActionBeanStack(HttpServletRequest request, boolean create) {
        Stack stack = (Stack)request.getAttribute("__stripes_actionBeanStack");
        if (stack == null && create) {
            stack = new Stack();
            request.setAttribute("__stripes_actionBeanStack", stack);
        }
        return stack;
    }

    protected void saveActionBean(HttpServletRequest request) {
        if (request.getAttribute("actionBean") != null) {
            Stack stack = this.getActionBeanStack(request, true);
            stack.push(request.getAttribute("actionBean"));
        }
    }

    protected void restoreActionBean(HttpServletRequest request) {
        Stack stack = this.getActionBeanStack(request, false);
        if (stack != null && !stack.empty()) {
            request.setAttribute("actionBean", stack.pop());
        }
    }
}

