/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.config.BootstrapPropertyResolver;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.config.RuntimeConfiguration;
import net.sourceforge.stripes.controller.FlashRequest;
import net.sourceforge.stripes.controller.FlashScope;
import net.sourceforge.stripes.controller.StripesRequestWrapper;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.ReflectUtil;

public class StripesFilter
implements Filter {
    public static final String CONFIG_CLASS = "Configuration.Class";
    private static Log log = Log.getInstance(StripesFilter.class);
    private Configuration configuration;
    private static ThreadLocal<Configuration> configurationStash = new ThreadLocal();

    public void init(FilterConfig filterConfig) throws ServletException {
        BootstrapPropertyResolver bootstrap = new BootstrapPropertyResolver(filterConfig);
        String configurationClassName = bootstrap.getProperty(CONFIG_CLASS);
        if (configurationClassName != null) {
            try {
                Class clazz = ReflectUtil.findClass(configurationClassName);
                this.configuration = (Configuration)clazz.newInstance();
            }
            catch (Exception e) {
                log.fatal(e, "Could not instantiate specified Configuration. Class name specified was ", "[", configurationClassName, "].");
                throw new StripesServletException("Could not instantiate specified Configuration. Class name specified was [" + configurationClassName + "].", e);
            }
        } else {
            this.configuration = new RuntimeConfiguration();
        }
        this.configuration.setBootstrapPropertyResolver(bootstrap);
        this.configuration.init();
        Package pkg = this.getClass().getPackage();
        log.info("Stripes Initialization Complete. Version: ", pkg.getSpecificationVersion(), ", Build: ", pkg.getImplementationVersion());
    }

    public static Configuration getConfiguration() {
        Configuration configuration = configurationStash.get();
        if (configuration == null) {
            StripesRuntimeException sre = new StripesRuntimeException("Something is trying to access the current Stripes configuration but the current request was never routed through the StripesFilter! As a result the appropriate Configuration object cannot be located. Please take a look at the exact URL in your browser's address bar and ensure that any requests to that URL will be filtered through the StripesFilter according to the filter mappings in your web.xml.");
            log.error(sre, new Object[0]);
        }
        return configuration;
    }

    public Configuration getInstanceConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        try {
            log.trace("Intercepting request to URL: ", httpRequest.getRequestURI());
            configurationStash.set(this.configuration);
            Locale locale = this.configuration.getLocalePicker().pickLocale(httpRequest);
            log.debug("LocalePicker selected locale: ", locale);
            String encoding = this.configuration.getLocalePicker().pickCharacterEncoding(httpRequest, locale);
            if (encoding != null) {
                httpRequest.setCharacterEncoding(encoding);
                log.debug("LocalePicker selected character encoding: ", encoding);
            } else {
                log.debug("LocalePicker did not pick a character encoding, using default: ", httpRequest.getCharacterEncoding());
            }
            StripesRequestWrapper request = this.wrapRequest(httpRequest);
            request.setLocale(locale);
            httpResponse.setLocale(locale);
            if (encoding != null) {
                httpResponse.setCharacterEncoding(encoding);
            }
            this.flashInbound((HttpServletRequest)request);
            filterChain.doFilter((ServletRequest)request, servletResponse);
        }
        catch (Throwable t) {
            this.configuration.getExceptionHandler().handle(t, httpRequest, httpResponse);
        }
        finally {
            this.flashOutbound(httpRequest);
            configurationStash.set(null);
        }
    }

    protected StripesRequestWrapper wrapRequest(HttpServletRequest servletRequest) throws StripesServletException {
        return new StripesRequestWrapper(servletRequest);
    }

    protected void flashInbound(HttpServletRequest req) {
        FlashScope flash = FlashScope.getPrevious(req);
        if (flash != null) {
            for (Map.Entry entry : flash.entrySet()) {
                Object tmp;
                Object value = entry.getValue();
                if (value instanceof ActionBean && (tmp = ((ActionBean)value).getContext().getRequest()) != null && (tmp = StripesRequestWrapper.findStripesWrapper((ServletRequest)tmp)) != null) {
                    tmp = (HttpServletRequest)((StripesRequestWrapper)((Object)tmp)).getRequest();
                    ((FlashRequest)tmp).setDelegate(req);
                }
                req.setAttribute((String)entry.getKey(), value);
            }
        }
    }

    protected void flashOutbound(HttpServletRequest req) {
        FlashScope flash = FlashScope.getCurrent(req, false);
        if (flash != null) {
            flash.requestComplete();
        }
    }

    public void destroy() {
    }
}

