/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.exception;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.config.BootstrapPropertyResolver;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.exception.AutoExceptionHandler;
import net.sourceforge.stripes.exception.ExceptionHandler;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.ResolverUtil;
import net.sourceforge.stripes.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingExceptionHandler
implements ExceptionHandler {
    private static final Log log = Log.getInstance(DelegatingExceptionHandler.class);
    public static final String URL_FILTERS = "DelegatingExceptionHandler.UrlFilters";
    public static final String PACAKGE_FILTERS = "DelegatingExceptionHandler.PackageFilters";
    private Configuration configuration;
    Map<Class<? extends Throwable>, HandlerProxy> handlers = new HashMap<Class<? extends Throwable>, HandlerProxy>();

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void init(Configuration configuration) throws Exception {
        this.configuration = configuration;
        Set<Class<AutoExceptionHandler>> handlers = this.findClasses(AutoExceptionHandler.class);
        for (Class<AutoExceptionHandler> handler : handlers) {
            log.debug("Processing class ", handler, " looking for exception handling methods.");
            this.addHandler(handler);
        }
    }

    protected void addHandler(Class<? extends AutoExceptionHandler> handlerClass) throws Exception {
        Method[] methods;
        for (Method method : methods = handlerClass.getMethods()) {
            Class<?>[] parameters = method.getParameterTypes();
            int mods = method.getModifiers();
            if (!Modifier.isPublic(mods) || Modifier.isAbstract(mods) || parameters.length != 3 || !Throwable.class.isAssignableFrom(parameters[0]) || !HttpServletRequest.class.equals(parameters[1]) || !HttpServletResponse.class.equals(parameters[2])) continue;
            Class<?> type = parameters[0];
            AutoExceptionHandler handler = handlerClass.newInstance();
            HandlerProxy proxy = new HandlerProxy(handler, method);
            this.handlers.put(type, proxy);
            log.debug("Added exception handler '", handlerClass.getSimpleName(), ".", method.getName(), "()' for exception type: ", type);
        }
    }

    @Override
    public void handle(Throwable throwable, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Throwable actual = this.unwrap(throwable);
            HandlerProxy proxy = null;
            for (Class<?> type = actual.getClass(); type != null && proxy == null; type = type.getSuperclass()) {
                proxy = this.handlers.get(type);
            }
            if (proxy == null) {
                throw throwable;
            }
            proxy.handle(actual, request, response);
        }
        catch (ServletException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable t) {
            throw new StripesServletException("Unhandled exception in exception handler.", t);
        }
    }

    protected Throwable unwrap(Throwable throwable) {
        Throwable t;
        if (throwable instanceof ServletException && (t = ((ServletException)throwable).getRootCause()) != null) {
            throwable = t;
        }
        return throwable;
    }

    protected Set<String> getUrlFilters() {
        BootstrapPropertyResolver bootstrap = this.configuration.getBootstrapPropertyResolver();
        HashSet<String> urlFilters = new HashSet<String>();
        String temp = bootstrap.getProperty(URL_FILTERS);
        if (temp != null) {
            urlFilters.addAll(Arrays.asList(StringUtil.standardSplit(temp)));
        }
        return urlFilters;
    }

    protected Set<String> getPackageFilters() {
        BootstrapPropertyResolver bootstrap = this.configuration.getBootstrapPropertyResolver();
        HashSet<String> packageFilters = new HashSet<String>();
        String temp = bootstrap.getProperty(PACAKGE_FILTERS);
        if (temp != null) {
            packageFilters.addAll(Arrays.asList(StringUtil.standardSplit(temp)));
        }
        return packageFilters;
    }

    protected <T> Set<Class<? extends T>> findClasses(Class<T> parentType) {
        ResolverUtil<T> resolver = new ResolverUtil<T>();
        resolver.setPackageFilters(this.getPackageFilters());
        resolver.setLocationFilters(this.getUrlFilters());
        if (!resolver.loadImplementationsFromContextClassloader(parentType)) {
            ServletContext context = this.configuration.getBootstrapPropertyResolver().getFilterConfig().getServletContext();
            resolver.loadImplementationsFromServletContext(parentType, context);
        }
        return resolver.getClasses();
    }

    private static class HandlerProxy {
        private AutoExceptionHandler handler;
        private Method handlerMethod;

        public HandlerProxy(AutoExceptionHandler handler, Method handlerMethod) {
            this.handler = handler;
            this.handlerMethod = handlerMethod;
        }

        public void handle(Throwable t, HttpServletRequest req, HttpServletResponse res) throws Exception {
            Object resolution = this.handlerMethod.invoke((Object)this.handler, t, req, res);
            if (resolution != null && resolution instanceof Resolution) {
                ((Resolution)resolution).execute(req, res);
            }
        }
    }
}

