/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.localization;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.localization.LocalizationBundleFactory;

public class DefaultLocalizationBundleFactory
implements LocalizationBundleFactory {
    public static final String BUNDLE_NAME = "StripesResources";
    private Configuration configuration;
    private String errorBundleName;
    private String fieldBundleName;

    public void init(Configuration configuration) throws Exception {
        this.configuration = configuration;
        this.errorBundleName = configuration.getBootstrapPropertyResolver().getProperty("LocalizationBundleFactory.ErrorMessageBundle");
        if (this.errorBundleName == null) {
            this.errorBundleName = BUNDLE_NAME;
        }
        this.fieldBundleName = configuration.getBootstrapPropertyResolver().getProperty("LocalizationBundleFactory.FieldNameBundle");
        if (this.fieldBundleName == null) {
            this.fieldBundleName = BUNDLE_NAME;
        }
    }

    public ResourceBundle getErrorMessageBundle(Locale locale) throws MissingResourceException {
        try {
            if (locale == null) {
                return ResourceBundle.getBundle(this.errorBundleName);
            }
            return ResourceBundle.getBundle(this.errorBundleName, locale);
        }
        catch (MissingResourceException mre) {
            MissingResourceException mre2 = new MissingResourceException("Could not find the error message resource bundle needed by Stripes. This almost certainly means that a properties file called '" + this.errorBundleName + ".properties' could not be found in the classpath. " + "This properties file is needed to lookup validation error messages. Please " + "ensure the file exists in WEB-INF/classes or elsewhere in your classpath.", this.errorBundleName, "");
            mre2.setStackTrace(mre.getStackTrace());
            throw mre2;
        }
    }

    public ResourceBundle getFormFieldBundle(Locale locale) throws MissingResourceException {
        try {
            if (locale == null) {
                return ResourceBundle.getBundle(this.fieldBundleName);
            }
            return ResourceBundle.getBundle(this.fieldBundleName, locale);
        }
        catch (MissingResourceException mre) {
            MissingResourceException mre2 = new MissingResourceException("Could not find the form field resource bundle needed by Stripes. This almost certainly means that a properties file called '" + this.fieldBundleName + ".properties' could not be found in the classpath. " + "This properties file is needed to lookup form field names. Please " + "ensure the file exists in WEB-INF/classes or elsewhere in your classpath.", this.fieldBundleName, "");
            mre2.setStackTrace(mre.getStackTrace());
            throw mre2;
        }
    }
}

