/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.mock;

import java.util.List;
import javax.servlet.Filter;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.mock.MockHttpServletRequest;
import net.sourceforge.stripes.mock.MockHttpServletResponse;
import net.sourceforge.stripes.mock.MockHttpSession;
import net.sourceforge.stripes.mock.MockServletContext;
import net.sourceforge.stripes.validation.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockRoundtrip {
    public static final String DEFAULT_SOURCE_PAGE = "_default_source_page_";
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    private MockServletContext context;

    public MockRoundtrip(MockServletContext context, Class<? extends ActionBean> beanType) {
        this(context, beanType, new MockHttpSession(context));
    }

    public MockRoundtrip(MockServletContext context, Class<? extends ActionBean> beanType, MockHttpSession session) {
        this(context, MockRoundtrip.getUrlBinding(beanType, context), session);
    }

    public MockRoundtrip(MockServletContext context, String actionBeanUrl) {
        this(context, actionBeanUrl, new MockHttpSession(context));
    }

    public MockRoundtrip(MockServletContext context, String actionBeanUrl, MockHttpSession session) {
        this.context = context;
        this.request = new MockHttpServletRequest("/" + context.getServletContextName(), actionBeanUrl);
        this.request.setSession(session);
        this.response = new MockHttpServletResponse();
        this.setSourcePage(DEFAULT_SOURCE_PAGE);
    }

    public MockHttpServletRequest getRequest() {
        return this.request;
    }

    public MockHttpServletResponse getResponse() {
        return this.response;
    }

    public void setParameter(String name, String ... value) {
        this.request.getParameterMap().put(name, value);
    }

    public void addParameter(String name, String ... value) {
        if (this.request.getParameterValues(name) == null) {
            this.setParameter(name, value);
        } else {
            String[] oldValues = this.request.getParameterMap().get(name);
            String[] combined = new String[oldValues.length + value.length];
            System.arraycopy(oldValues, 0, combined, 0, oldValues.length);
            System.arraycopy(value, 0, combined, oldValues.length, value.length);
        }
    }

    public void setSourcePage(String url) {
        this.setParameter("_sourcePage", url);
    }

    public void execute() throws Exception {
        this.context.acceptRequest(this.request, this.response);
    }

    public void execute(String event) throws Exception {
        this.setParameter(event, "");
        this.execute();
    }

    public <A extends ActionBean> A getActionBean(Class<A> type) {
        return (A)((ActionBean)this.request.getAttribute(MockRoundtrip.getUrlBinding(type, this.context)));
    }

    public ValidationErrors getValidationErrors() {
        ActionBean bean = (ActionBean)this.request.getAttribute("actionBean");
        return bean.getContext().getValidationErrors();
    }

    public byte[] getOutputBytes() {
        return this.response.getOutputBytes();
    }

    public String getOutputString() {
        return this.response.getOutputString();
    }

    public String getDestination() {
        String forward = this.request.getForwardUrl();
        String redirect = this.response.getRedirectUrl();
        if (forward != null) {
            return forward;
        }
        if (redirect != null && redirect.startsWith(this.request.getContextPath())) {
            redirect = redirect.substring(redirect.indexOf(47, 1));
        }
        return redirect;
    }

    public String getForwardUrl() {
        return this.request.getForwardUrl();
    }

    public String getRedirectUrl() {
        return this.response.getRedirectUrl();
    }

    private static String getUrlBinding(Class<? extends ActionBean> clazz, MockServletContext context) {
        List<Filter> filters = context.getFilters();
        for (Filter filter : filters) {
            if (!(filter instanceof StripesFilter)) continue;
            return ((StripesFilter)filter).getInstanceConfiguration().getActionResolver().getUrlBinding(clazz);
        }
        return null;
    }
}

