/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.util.Collection;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.localization.LocalizationUtility;
import net.sourceforge.stripes.tag.HtmlTagSupport;
import net.sourceforge.stripes.tag.InputOptionTag;
import net.sourceforge.stripes.util.bean.BeanUtil;
import net.sourceforge.stripes.util.bean.ExpressionException;

public class InputOptionsCollectionTag
extends HtmlTagSupport
implements Tag {
    private Collection collection;
    private String value;
    private String label;

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doStartTag() throws JspException {
        if (this.collection == null) {
            return 0;
        }
        String labelProperty = this.getLabel();
        String valueProperty = this.getValue();
        Locale locale = this.getPageContext().getRequest().getLocale();
        InputOptionTag tag = new InputOptionTag();
        tag.setParent(this);
        tag.setPageContext(this.getPageContext());
        tag.getAttributes().putAll(this.getAttributes());
        try {
            for (Object item : this.collection) {
                Class<?> clazz = item.getClass();
                Object label = labelProperty == null ? item : BeanUtil.getPropertyValue(labelProperty, item);
                Object value = valueProperty == null ? item : BeanUtil.getPropertyValue(valueProperty, item);
                String packageName = clazz.getPackage() == null ? "" : clazz.getPackage().getName();
                String localizedLabel = null;
                if (label != null) {
                    localizedLabel = LocalizationUtility.getLocalizedFieldName(clazz.getSimpleName() + "." + label, packageName, locale);
                }
                if (localizedLabel == null && value != null) {
                    localizedLabel = LocalizationUtility.getLocalizedFieldName(clazz.getSimpleName() + "." + value, packageName, locale);
                }
                if (localizedLabel != null) {
                    label = localizedLabel;
                }
                tag.setLabel(label == null ? null : label.toString());
                tag.setValue(value);
                try {
                    tag.doStartTag();
                    tag.doInitBody();
                    tag.doAfterBody();
                    tag.doEndTag();
                }
                catch (Throwable t) {
                    try {
                        tag.doCatch(t);
                    }
                    catch (Throwable t2) {
                        if (t2 instanceof JspException) {
                            throw (JspException)t2;
                        }
                        if (t2 instanceof RuntimeException) {
                            throw (RuntimeException)t2;
                        }
                        throw new StripesJspException(t2);
                    }
                }
                finally {
                    tag.doFinally();
                }
            }
        }
        catch (ExpressionException ee) {
            throw new StripesJspException("A problem occurred generating an options-collection. Most likely either [" + labelProperty + "] or [" + valueProperty + "] is not a " + "valid property of the beans in the collection: " + this.collection, ee);
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        return 6;
    }
}

