/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.tag.HtmlTagSupport;
import net.sourceforge.stripes.tag.ParameterizableTag;
import net.sourceforge.stripes.util.UrlBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LinkTagSupport
extends HtmlTagSupport
implements ParameterizableTag {
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private String event;
    private Object beanclass;
    private String url;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void addParameter(String name, Object valueOrValues) {
        this.parameters.put(name, valueOrValues);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getEvent() {
        return this.event;
    }

    public void setBeanclass(Object beanclass) {
        this.beanclass = beanclass;
    }

    public Object getBeanclass() {
        return this.beanclass;
    }

    protected String getPreferredBaseUrl() throws StripesJspException {
        if (this.beanclass != null) {
            String beanHref = this.getActionBeanUrl(this.beanclass);
            if (beanHref == null) {
                throw new StripesJspException("The value supplied for the 'beanclass' attribute does not represent a valid ActionBean. The value supplied was '" + this.beanclass + "'. If you're prototyping, or your bean isn't ready yet " + "and you want this exception to go away, just use 'href' for now instead.");
            }
            return beanHref;
        }
        return this.getUrl();
    }

    protected String buildUrl() throws StripesJspException {
        HttpServletRequest request = (HttpServletRequest)this.getPageContext().getRequest();
        HttpServletResponse response = (HttpServletResponse)this.getPageContext().getResponse();
        String base = this.getPreferredBaseUrl();
        String contextPath = request.getContextPath();
        if (base.startsWith("/") && !"/".equals(contextPath) && !base.contains(contextPath + "/")) {
            base = contextPath + base;
        }
        UrlBuilder builder = new UrlBuilder(base, false);
        if (this.event != null) {
            builder.addParameter(this.event, new Object[0]);
        }
        builder.addParameter("_sourcePage", request.getServletPath());
        builder.addParameters(this.parameters);
        return response.encodeURL(builder.toString());
    }
}

