/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import net.sourceforge.stripes.action.Message;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.tag.HtmlTagSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesTag
extends HtmlTagSupport {
    public static final String DEFAULT_HEADER = "<ul class=\"messages\">";
    public static final String DEFAULT_FOOTER = "</ul>";
    private String key = "_stripes_defaultMessages";

    @Override
    public int doStartTag() throws JspException {
        return 0;
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            List<Message> messages = this.getMessages();
            if (messages != null && messages.size() > 0) {
                String afterMessage;
                String beforeMessage;
                String footer;
                String header;
                JspWriter writer = this.getPageContext().getOut();
                Locale locale = this.getPageContext().getRequest().getLocale();
                ResourceBundle bundle = StripesFilter.getConfiguration().getLocalizationBundleFactory().getErrorMessageBundle(locale);
                try {
                    header = bundle.getString("stripes.messages.header");
                }
                catch (MissingResourceException mre) {
                    header = DEFAULT_HEADER;
                }
                try {
                    footer = bundle.getString("stripes.messages.footer");
                }
                catch (MissingResourceException mre) {
                    footer = DEFAULT_FOOTER;
                }
                try {
                    beforeMessage = bundle.getString("stripes.messages.beforeMessage");
                }
                catch (MissingResourceException mre) {
                    beforeMessage = "<li>";
                }
                try {
                    afterMessage = bundle.getString("stripes.messages.afterMessage");
                }
                catch (MissingResourceException mre) {
                    afterMessage = "</li>";
                }
                writer.write(header);
                for (Message message : messages) {
                    writer.write(beforeMessage);
                    writer.write(message.getMessage(locale));
                    writer.write(afterMessage);
                }
                writer.write(footer);
            }
            return 6;
        }
        catch (IOException e) {
            throw new JspException("IOException encountered while writing messages tag to the JspWriter.", (Throwable)e);
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    protected List<Message> getMessages() {
        HttpServletRequest request = (HttpServletRequest)this.getPageContext().getRequest();
        List messages = (List)request.getAttribute(this.getKey());
        if (messages == null) {
            messages = (List)request.getSession().getAttribute(this.getKey());
            request.getSession().removeAttribute(this.getKey());
        }
        return messages;
    }
}

