/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.util.HashSet;
import java.util.Map;
import javax.servlet.jsp.JspException;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.tag.FormTag;
import net.sourceforge.stripes.tag.InputHiddenTag;
import net.sourceforge.stripes.tag.StripesTagSupport;
import net.sourceforge.stripes.util.CollectionUtil;

public class WizardFieldsTag
extends StripesTagSupport {
    private boolean currentFormOnly = false;
    private boolean emptyFields = false;

    public void setCurrentFormOnly(boolean currentFormOnly) {
        this.currentFormOnly = currentFormOnly;
    }

    public boolean isCurrentFormOnly() {
        return this.currentFormOnly;
    }

    public void setEmptyFields(boolean emptyFields) {
        this.emptyFields = emptyFields;
    }

    public boolean isEmptyFields() {
        return this.emptyFields;
    }

    public int doStartTag() throws JspException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doEndTag() throws JspException {
        String eventName;
        FormTag form = this.getParentTag(FormTag.class);
        HashSet<String> excludes = new HashSet<String>();
        excludes.addAll(form.getRegisteredFields());
        excludes.add("_sourcePage");
        excludes.add("__fp");
        excludes.add("_eventName");
        ActionBean submittedActionBean = (ActionBean)this.getPageContext().getRequest().getAttribute("actionBean");
        if (submittedActionBean != null && (eventName = submittedActionBean.getContext().getEventName()) != null) {
            excludes.add(eventName);
            excludes.add(eventName + ".x");
            excludes.add(eventName + ".y");
        }
        ActionBean actionBean = form.getActionBean();
        if (!this.isCurrentFormOnly() || actionBean != null) {
            InputHiddenTag hidden = new InputHiddenTag();
            hidden.setPageContext(this.getPageContext());
            hidden.setParent(this.getParent());
            Map params = this.getPageContext().getRequest().getParameterMap();
            for (Map.Entry entry : params.entrySet()) {
                String name = (String)entry.getKey();
                String[] values = (String[])entry.getValue();
                if (excludes.contains(name) || CollectionUtil.empty(values) && !this.emptyFields) continue;
                hidden.setName(name);
                try {
                    hidden.doStartTag();
                    hidden.doAfterBody();
                    hidden.doEndTag();
                }
                catch (Throwable t) {
                    try {
                        hidden.doCatch(t);
                    }
                    catch (Throwable t2) {
                        if (t2 instanceof JspException) {
                            throw (JspException)t2;
                        }
                        if (t2 instanceof RuntimeException) {
                            throw (RuntimeException)t2;
                        }
                        throw new StripesJspException(t2);
                    }
                }
                finally {
                    hidden.doFinally();
                }
            }
        }
        return 6;
    }
}

