/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.servlet.ServletContext;
import net.sourceforge.stripes.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverUtil<T> {
    private static final Log log = Log.getInstance(ResolverUtil.class);
    private Set<String> locationFilters = new HashSet<String>();
    private Set<String> packageFilters = new HashSet<String>();
    private Set<Class<? extends T>> implementations = new HashSet<Class<? extends T>>();

    public void setLocationFilters(Collection<String> patterns) {
        this.locationFilters.clear();
        for (String pattern : patterns) {
            this.locationFilters.add(pattern.replace("*", ""));
        }
    }

    public void setPackageFilters(Collection<String> patterns) {
        this.packageFilters.clear();
        for (String pattern : patterns) {
            this.packageFilters.add(pattern.replace("*", "").replace(".", "/"));
        }
    }

    public Set<Class<? extends T>> getClasses() {
        return this.implementations;
    }

    public void loadImplementationsFromServletContext(Class<? extends T> parentType, ServletContext context) {
        log.info("Checking for classes in /WEB-INF/classes using ServletContext resources.");
        this.loadImplementationsFromServletContext(parentType, "/WEB-INF/classes/", context);
        Set jars = context.getResourcePaths("/WEB-INF/lib/");
        if (jars != null) {
            for (String jarName : jars) {
                if (!this.matchesAny(jarName, this.locationFilters)) continue;
                log.info("Checking web application library '", jarName, "' for instances of ", parentType.getName());
                this.loadImplementationsInJar(parentType, context.getResourceAsStream(jarName), jarName);
            }
        }
    }

    private void loadImplementationsFromServletContext(Class<? extends T> parentType, String path, ServletContext context) {
        Set paths = context.getResourcePaths(path);
        if (paths != null) {
            for (String subPath : paths) {
                if (subPath.endsWith("/")) {
                    this.loadImplementationsFromServletContext(parentType, subPath, context);
                    continue;
                }
                if (!subPath.endsWith(".class")) continue;
                this.addIfAssignableTo(parentType, subPath.replace("/WEB-INF/classes/", ""));
            }
        }
    }

    public boolean loadImplementationsFromContextClassloader(Class<? extends T> parentType) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (!(loader instanceof URLClassLoader)) {
            log.error("The current ClassLoader is not castable to a URLClassLoader. ClassLoader ", "is of type [", loader.getClass().getName(), "]. Cannot scan ClassLoader for ", "implementations of ", parentType.getClass().getName(), ". When this is the ", "case you *must* put your ActionBean classes in either /WEB-INF/classes ", "or in a jar in /WEB-INF/lib for Stripes to find them.");
            return false;
        }
        HashSet<URL> urls = new HashSet<URL>();
        while (loader != null) {
            try {
                URLClassLoader urlLoader = (URLClassLoader)loader;
                urls.addAll(Arrays.asList(urlLoader.getURLs()));
            }
            catch (Exception e) {
                // empty catch block
            }
            loader = loader.getParent();
        }
        for (URL url : urls) {
            String path = url.getFile();
            try {
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            File location = new File(path);
            if (!location.exists()) {
                if (path.endsWith("!/")) {
                    path = path.substring(0, path.length() - 2);
                }
                if (path.startsWith("file:")) {
                    path = path.substring(5);
                }
                location = new File(path);
            }
            if (!this.matchesAny(path, this.locationFilters)) continue;
            log.info("Checking URL '", path, "' for instances of ", parentType.getName());
            if (location.isDirectory()) {
                this.loadImplementationsInDirectory(parentType, null, location);
                continue;
            }
            this.loadImplementationsInJar(parentType, null, path);
        }
        return true;
    }

    private boolean matchesAny(String text, Set<String> filters) {
        if (filters.size() == 0) {
            return true;
        }
        for (String filter : filters) {
            if (text.indexOf(filter) == -1) continue;
            return true;
        }
        return false;
    }

    private void loadImplementationsInDirectory(Class<? extends T> parentType, String parent, File location) {
        File[] files = location.listFiles();
        StringBuilder builder = null;
        if (files == null) {
            log.warn("Could not list directory " + location.getAbsolutePath() + " when looking for classes assignable to: " + parentType.getSimpleName());
            return;
        }
        for (File file : files) {
            String packageOrClass;
            builder = new StringBuilder(100);
            builder.append(parent).append("/").append(file.getName());
            String string = packageOrClass = parent == null ? file.getName() : builder.toString();
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(parentType, packageOrClass, file);
                continue;
            }
            if (!file.getName().endsWith(".class") || !this.matchesAny(packageOrClass, this.packageFilters)) continue;
            this.addIfAssignableTo(parentType, packageOrClass);
        }
    }

    private void loadImplementationsInJar(Class<? extends T> parentType, InputStream inputStream, String location) {
        try {
            JarEntry entry;
            if (inputStream == null) {
                inputStream = new FileInputStream(location);
            }
            JarInputStream jarStream = new JarInputStream(inputStream);
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory() || !name.endsWith(".class") || !this.matchesAny(name, this.packageFilters)) continue;
                this.addIfAssignableTo(parentType, name);
            }
        }
        catch (IOException ioe) {
            log.error("Could not search jar file '", location, "' for implementations of ", parentType.getName(), "due to an IOException: ", ioe.getMessage());
        }
    }

    private void addIfAssignableTo(Class<? extends T> parentType, String fqn) {
        try {
            log.trace("Checking to see if class '", fqn, "' implements ", parentType.getName());
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            Class<?> type = loader.loadClass(externalName);
            if (parentType.isAssignableFrom(type)) {
                this.implementations.add(type);
            }
        }
        catch (Throwable t) {
            log.warn("Could not examine class '", fqn, "'", " due to a ", t.getClass().getName(), " with message: ", t.getMessage());
        }
    }
}

