/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import net.sourceforge.stripes.validation.ScopedLocalizableError;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTypeConverter
implements TypeConverter<Date> {
    private Locale locale;
    private DateFormat[] formats;
    public static final Pattern pattern = Pattern.compile("[\\s,-/\\.]+");
    public static final String[] formatStrings = new String[]{"d MMM yy", "yyyy M d", "yyyy MMM d", "EEE MMM dd HH:mm:ss zzz yyyy"};

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
        this.formats = this.getDateFormats();
    }

    protected String[] getFormatStrings() {
        return formatStrings;
    }

    protected DateFormat[] getDateFormats() {
        String[] formatStrings = this.getFormatStrings();
        DateFormat[] dateFormats = new SimpleDateFormat[formatStrings.length + 3];
        for (int i = 0; i < formatStrings.length; ++i) {
            dateFormats[i + 3] = new SimpleDateFormat(formatStrings[i], this.locale);
            dateFormats[i + 3].setLenient(false);
        }
        dateFormats[0] = (SimpleDateFormat)DateFormat.getDateInstance(3, this.locale);
        dateFormats[0].applyPattern(this.preProcessInput(dateFormats[0].toPattern()));
        dateFormats[0].setLenient(false);
        dateFormats[1] = (SimpleDateFormat)DateFormat.getDateInstance(2, this.locale);
        dateFormats[1].applyPattern(this.preProcessInput(dateFormats[1].toPattern()));
        dateFormats[1].setLenient(false);
        dateFormats[2] = (SimpleDateFormat)DateFormat.getDateInstance(1, this.locale);
        dateFormats[2].applyPattern(this.preProcessInput(dateFormats[2].toPattern()));
        dateFormats[2].setLenient(false);
        return dateFormats;
    }

    @Override
    public Date convert(String input, Class<? extends Date> targetType, Collection<ValidationError> errors) {
        String parseable = this.preProcessInput(input);
        Date date = null;
        for (DateFormat format : this.formats) {
            try {
                date = format.parse(parseable);
                break;
            }
            catch (ParseException pe) {
            }
        }
        if (date != null) {
            return date;
        }
        errors.add(new ScopedLocalizableError("converter.date", "invalidDate", new Object[0]));
        return null;
    }

    protected String preProcessInput(String input) {
        input = pattern.matcher(input.trim()).replaceAll(" ");
        int count = 0;
        for (char ch : input.toCharArray()) {
            if (ch != ' ') continue;
            ++count;
        }
        if (count == 1) {
            input = input + " " + Calendar.getInstance(this.locale).get(1);
        }
        return input;
    }
}

