/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.validation.BigDecimalTypeConverter;
import net.sourceforge.stripes.validation.BigIntegerTypeConverter;
import net.sourceforge.stripes.validation.BooleanTypeConverter;
import net.sourceforge.stripes.validation.ByteTypeConverter;
import net.sourceforge.stripes.validation.CharacterTypeConverter;
import net.sourceforge.stripes.validation.DateTypeConverter;
import net.sourceforge.stripes.validation.DoubleTypeConverter;
import net.sourceforge.stripes.validation.EnumeratedTypeConverter;
import net.sourceforge.stripes.validation.FloatTypeConverter;
import net.sourceforge.stripes.validation.IntegerTypeConverter;
import net.sourceforge.stripes.validation.LongTypeConverter;
import net.sourceforge.stripes.validation.ObjectTypeConverter;
import net.sourceforge.stripes.validation.ShortTypeConverter;
import net.sourceforge.stripes.validation.StringTypeConverter;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.TypeConverterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTypeConverterFactory
implements TypeConverterFactory {
    private Map<Class, Class<? extends TypeConverter>> converters = new HashMap<Class, Class<? extends TypeConverter>>();
    private Configuration configuration;

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
        this.converters.put(Boolean.class, BooleanTypeConverter.class);
        this.converters.put(Boolean.TYPE, BooleanTypeConverter.class);
        this.converters.put(Byte.class, ByteTypeConverter.class);
        this.converters.put(Byte.TYPE, ByteTypeConverter.class);
        this.converters.put(Short.class, ShortTypeConverter.class);
        this.converters.put(Short.TYPE, ShortTypeConverter.class);
        this.converters.put(Integer.class, IntegerTypeConverter.class);
        this.converters.put(Integer.TYPE, IntegerTypeConverter.class);
        this.converters.put(Long.class, LongTypeConverter.class);
        this.converters.put(Long.TYPE, LongTypeConverter.class);
        this.converters.put(Float.class, FloatTypeConverter.class);
        this.converters.put(Float.TYPE, FloatTypeConverter.class);
        this.converters.put(Double.class, DoubleTypeConverter.class);
        this.converters.put(Double.TYPE, DoubleTypeConverter.class);
        this.converters.put(Date.class, DateTypeConverter.class);
        this.converters.put(BigInteger.class, BigIntegerTypeConverter.class);
        this.converters.put(BigDecimal.class, BigDecimalTypeConverter.class);
        this.converters.put(String.class, StringTypeConverter.class);
        this.converters.put(Object.class, ObjectTypeConverter.class);
        this.converters.put(Character.class, CharacterTypeConverter.class);
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected Map<Class, Class<? extends TypeConverter>> getTypeConverters() {
        return this.converters;
    }

    protected void add(Class targetType, Class<? extends TypeConverter> converterClass) {
        this.converters.put(targetType, converterClass);
    }

    @Override
    public TypeConverter getTypeConverter(Class forType, Locale locale) throws Exception {
        Class<? extends TypeConverter> clazz = this.converters.get(forType);
        if (clazz != null) {
            return this.getInstance(clazz, locale);
        }
        if (forType.isEnum()) {
            return this.getInstance(EnumeratedTypeConverter.class, locale);
        }
        return null;
    }

    @Override
    public TypeConverter getInstance(Class<? extends TypeConverter> clazz, Locale locale) throws Exception {
        TypeConverter converter = clazz.newInstance();
        converter.setLocale(locale);
        return converter;
    }
}

