/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Currency;
import java.util.Locale;
import net.sourceforge.stripes.validation.ScopedLocalizableError;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberTypeConverterSupport {
    private Locale locale;
    private NumberFormat[] formats;
    private String currencySymbol;

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.formats = this.getNumberFormats();
        this.currencySymbol = locale.getCountry() != null && !"".equals(locale.getCountry()) ? Currency.getInstance(locale).getSymbol(locale) : "$";
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Deprecated
    protected NumberFormat getNumberFormat() {
        return NumberFormat.getInstance(this.locale);
    }

    protected NumberFormat[] getNumberFormats() {
        return new NumberFormat[]{this.getNumberFormat()};
    }

    protected Number parse(String input, Collection<ValidationError> errors) {
        input = this.preprocess(input);
        for (NumberFormat format : this.formats) {
            try {
                return format.parse(input);
            }
            catch (ParseException pe) {
            }
        }
        errors.add(new ScopedLocalizableError("converter.number", "invalidNumber", new Object[0]));
        return null;
    }

    protected String preprocess(String input) {
        String output = input.trim();
        if ((output = output.replace(this.currencySymbol, "")).startsWith("(") && output.endsWith(")")) {
            output = "-" + output.substring(1, output.length() - 1);
        }
        return output;
    }
}

