/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.stripes.validation.NumberTypeConverterSupport;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PercentageTypeConverter
extends NumberTypeConverterSupport
implements TypeConverter<Number> {
    @Override
    protected NumberFormat[] getNumberFormats() {
        return new NumberFormat[]{NumberFormat.getPercentInstance(this.getLocale())};
    }

    @Override
    public Number convert(String input, Class<? extends Number> targetType, Collection<ValidationError> errors) {
        Number number = this.parse(input, errors);
        if (errors.size() > 0) {
            ArrayList<ValidationError> errorsToo = new ArrayList<ValidationError>();
            number = this.parse(input + "%", errorsToo);
            if (errorsToo.size() == 0) {
                errors.clear();
            }
        }
        if (errors.size() == 0) {
            if (targetType.equals(Float.class) || targetType.equals(Float.TYPE)) {
                number = new Float(number.floatValue());
            } else if (targetType.equals(Double.class) || targetType.equals(Double.TYPE)) {
                number = new Double(number.doubleValue());
            } else if (targetType.equals(BigDecimal.class)) {
                number = new BigDecimal(number.doubleValue());
            } else {
                throw new IllegalArgumentException("PercentageTypeConverter only converts to float, double and BigDecimal. This is because the input number is always converted to a decimal value. E.g. 99% -> 0.99. Type specified was: " + targetType);
            }
        }
        return number;
    }
}

