/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.stripes.controller.ParameterName;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationErrors
extends HashMap<String, List<ValidationError>> {
    public static final String GLOBAL_ERROR = "__stripes_global_error";

    @Override
    public void put(String field, ValidationError error) {
        ArrayList<ValidationError> errors = (ArrayList<ValidationError>)this.get(field);
        if (errors == null) {
            errors = new ArrayList<ValidationError>();
            this.put(field, (List<ValidationError>)errors);
        }
        error.setFieldName(new ParameterName(field).getStrippedName());
        errors.add(error);
    }

    public void add(String field, ValidationError error) {
        this.put(field, error);
    }

    public void putAll(String field, List<ValidationError> errors) {
        for (ValidationError error : errors) {
            this.put(field, error);
        }
    }

    public void addAll(String field, List<ValidationError> errors) {
        this.putAll(field, errors);
    }

    public void addGlobalError(ValidationError error) {
        this.add(GLOBAL_ERROR, error);
    }

    @Override
    public List<ValidationError> put(String field, List<ValidationError> errors) {
        String strippedName = new ParameterName(field).getStrippedName();
        for (ValidationError error : errors) {
            error.setFieldName(strippedName);
        }
        return super.put(field, errors);
    }

    public boolean hasFieldErrors() {
        if (this.keySet().contains(GLOBAL_ERROR)) {
            return this.size() > 1;
        }
        return this.size() > 0;
    }
}

