/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ibatis3;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.util.ObjectUtils;

public class SqlSessionFactoryBean
implements FactoryBean<SqlSessionFactory>,
InitializingBean {
    private Resource[] configLocations;
    private Resource[] mapperLocations;
    private DataSource dataSource;
    private Class<? extends TransactionFactory> transactionFactoryClass = ManagedTransactionFactory.class;
    private Properties transactionFactoryProperties;
    private Properties sqlSessionFactoryProperties;
    private SqlSessionFactory sqlSessionFactory;
    private String environment = SqlSessionFactoryBean.class.getSimpleName();

    public void setConfigLocation(Resource configLocation) {
        Resource[] resourceArray;
        if (configLocation != null) {
            Resource[] resourceArray2 = new Resource[1];
            resourceArray = resourceArray2;
            resourceArray2[0] = configLocation;
        } else {
            resourceArray = null;
        }
        this.configLocations = resourceArray;
    }

    public void setConfigLocations(Resource[] configLocations) {
        this.configLocations = configLocations;
    }

    public void setMapperLocations(Resource[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public void setSqlSessionFactoryProperties(Properties sqlSessionFactoryProperties) {
        this.sqlSessionFactoryProperties = sqlSessionFactoryProperties;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public void setTransactionFactoryClass(Class<TransactionFactory> transactionFactoryClass) {
        if (transactionFactoryClass == null) {
            throw new IllegalArgumentException("Invalid transactionFactoryClass: does not implement org.apache.ibatis.transaction.TransactionFactory");
        }
        this.transactionFactoryClass = transactionFactoryClass;
    }

    public void setTransactionFactoryProperties(Properties transactionFactoryProperties) {
        this.transactionFactoryProperties = transactionFactoryProperties;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void afterPropertiesSet() throws Exception {
        this.sqlSessionFactory = this.buildSqlSessionFactory(this.configLocations, this.mapperLocations, this.sqlSessionFactoryProperties);
    }

    protected SqlSessionFactory buildSqlSessionFactory(Resource[] configLocations, Resource[] mapperLocations, Properties properties) throws IOException, IllegalAccessException, InstantiationException {
        if (ObjectUtils.isEmpty((Object[])configLocations)) {
            throw new IllegalArgumentException("At least one 'configLocation' entry is required");
        }
        XMLConfigBuilder xmlConfigBuilder = null;
        Configuration configuration = null;
        Resource[] resourceArray = configLocations;
        int n = configLocations.length;
        int n2 = 0;
        while (n2 < n) {
            Resource configLocation = resourceArray[n2];
            try {
                InputStreamReader reader = new InputStreamReader(configLocation.getInputStream());
                xmlConfigBuilder = new XMLConfigBuilder((Reader)reader, null, properties);
                configuration = xmlConfigBuilder.parse();
            }
            catch (IOException ex) {
                throw new NestedIOException("Failed to parse config resource: " + configLocation, ex.getCause());
            }
            ++n2;
        }
        assert (configuration != null);
        if (this.dataSource != null) {
            TransactionFactory transactionFactory = this.transactionFactoryClass.newInstance();
            transactionFactory.setProperties(this.transactionFactoryProperties);
            Environment environment = new Environment(this.environment, transactionFactory, this.dataSource);
            configuration.setEnvironment(environment);
        }
        if (mapperLocations != null) {
            HashMap sqlFragments = new HashMap();
            Resource[] resourceArray2 = mapperLocations;
            int n3 = mapperLocations.length;
            n = 0;
            while (n < n3) {
                Resource mapperLocation = resourceArray2[n];
                try {
                    InputStreamReader reader = new InputStreamReader(mapperLocation.getInputStream());
                    XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder((Reader)reader, configuration, mapperLocation.toString(), sqlFragments);
                    xmlMapperBuilder.parse();
                }
                catch (Exception ex) {
                    throw new NestedIOException("Failed to parse mapping resource: " + mapperLocation, (Throwable)ex);
                }
                ++n;
            }
        }
        return new SqlSessionFactoryBuilder().build(configuration);
    }

    public SqlSessionFactory getObject() throws Exception {
        return this.sqlSessionFactory;
    }

    public Class<? extends SqlSessionFactory> getObjectType() {
        return this.sqlSessionFactory == null ? SqlSessionFactory.class : this.sqlSessionFactory.getClass();
    }

    public boolean isSingleton() {
        return true;
    }
}

