/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ibatis3;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.exceptions.IbatisException;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springframework.orm.ibatis3.IbatisSystemException;
import org.springframework.orm.ibatis3.SqlSessionCallback;
import org.springframework.orm.ibatis3.SqlSessionOperations;
import org.springframework.orm.ibatis3.SqlSessionUtils;
import org.springframework.util.Assert;

public class SqlSessionTemplate
extends JdbcAccessor
implements SqlSessionOperations {
    private SqlSessionFactory sqlSessionFactory;

    public SqlSessionTemplate() {
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public SqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        this.setSqlSessionFactory(sqlSessionFactory);
        this.afterPropertiesSet();
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public DataSource getDataSource() {
        DataSource ds = super.getDataSource();
        return ds != null ? ds : this.sqlSessionFactory.getConfiguration().getEnvironment().getDataSource();
    }

    public void afterPropertiesSet() {
        if (this.sqlSessionFactory == null) {
            throw new IllegalArgumentException("Property 'sqlSessionFactory' is required");
        }
        super.afterPropertiesSet();
    }

    public <T> T execute(SqlSessionCallback<T> action) throws DataAccessException {
        return this.execute(action, this.sqlSessionFactory.getConfiguration().getDefaultExecutorType());
    }

    public <T> T execute(SqlSessionCallback<T> action, ExecutorType executorType) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Assert.notNull((Object)this.sqlSessionFactory, (String)"No SqlSessionFactory specified");
        SqlSession sqlSession = SqlSessionUtils.getSqlSession(this.sqlSessionFactory, this.getDataSource(), executorType);
        try {
            T t = action.doInSqlSession(sqlSession);
            return t;
        }
        catch (Throwable t) {
            throw this.wrapException(t);
        }
        finally {
            SqlSessionUtils.closeSqlSession(sqlSession, this.sqlSessionFactory);
        }
    }

    @Override
    public Object selectOne(String statement) {
        return this.selectOne(statement, null);
    }

    @Override
    public Object selectOne(final String statement, final Object parameter) {
        return this.execute(new SqlSessionCallback<Object>(){

            @Override
            public Object doInSqlSession(SqlSession sqlSession) {
                return sqlSession.selectOne(statement, parameter);
            }
        });
    }

    @Override
    public List selectList(String statement) {
        return this.selectList(statement, null);
    }

    @Override
    public List selectList(String statement, Object parameter) {
        return this.selectList(statement, parameter, RowBounds.DEFAULT);
    }

    @Override
    public List selectList(final String statement, final Object parameter, final RowBounds rowBounds) {
        return this.execute(new SqlSessionCallback<List>(){

            @Override
            public List doInSqlSession(SqlSession sqlSession) {
                return sqlSession.selectList(statement, parameter, rowBounds);
            }
        });
    }

    @Override
    public void select(String statement, Object parameter, ResultHandler handler) {
        this.select(statement, parameter, RowBounds.DEFAULT, handler);
    }

    @Override
    public void select(final String statement, final Object parameter, final RowBounds rowBounds, final ResultHandler handler) {
        this.execute(new SqlSessionCallback<Object>(){

            @Override
            public Object doInSqlSession(SqlSession sqlSession) {
                sqlSession.select(statement, parameter, rowBounds, handler);
                return null;
            }
        });
    }

    @Override
    public int insert(String statement) {
        return this.insert(statement, null);
    }

    @Override
    public int insert(final String statement, final Object parameter) {
        return this.execute(new SqlSessionCallback<Integer>(){

            @Override
            public Integer doInSqlSession(SqlSession sqlSession) {
                return sqlSession.insert(statement, parameter);
            }
        });
    }

    @Override
    public int update(String statement) {
        return this.update(statement, null);
    }

    @Override
    public int update(final String statement, final Object parameter) {
        return this.execute(new SqlSessionCallback<Integer>(){

            @Override
            public Integer doInSqlSession(SqlSession sqlSession) {
                return sqlSession.update(statement, parameter);
            }
        });
    }

    @Override
    public int delete(String statement) {
        return this.update(statement, null);
    }

    @Override
    public int delete(final String statement, final Object parameter) {
        return this.execute(new SqlSessionCallback<Integer>(){

            @Override
            public Integer doInSqlSession(SqlSession sqlSession) {
                return sqlSession.delete(statement, parameter);
            }
        });
    }

    @Override
    public <T> T getMapper(final Class<T> type) {
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, final Method method, final Object[] args) {
                return SqlSessionTemplate.this.execute(new SqlSessionCallback<T>(){

                    @Override
                    public T doInSqlSession(SqlSession sqlSession) throws Exception {
                        return method.invoke(sqlSession.getMapper(type), args);
                    }
                });
            }
        });
    }

    private DataAccessException wrapException(Throwable t) {
        if (t instanceof InvocationTargetException) {
            t = t.getCause();
        }
        if (t instanceof IbatisException) {
            Throwable t2 = ((IbatisException)t).getCause();
            if (t2 instanceof SQLException) {
                return this.getExceptionTranslator().translate("SqlSession operation", null, (SQLException)t2);
            }
            return new IbatisSystemException("SqlSession operation", t);
        }
        if (t instanceof DataAccessException) {
            return (DataAccessException)t;
        }
        return new IbatisSystemException("SqlSession operation", t);
    }
}

