/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ibatis3;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.logging.jdbc.ConnectionLogger;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.orm.ibatis3.SqlSessionHolder;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public final class SqlSessionUtils {
    private static final Log logger = LogFactory.getLog(SqlSessionUtils.class);

    public static SqlSession getSqlSession(SqlSessionFactory sessionFactory) {
        DataSource dataSource = sessionFactory.getConfiguration().getEnvironment().getDataSource();
        ExecutorType executorType = sessionFactory.getConfiguration().getDefaultExecutorType();
        return SqlSessionUtils.getSqlSession(sessionFactory, dataSource, executorType);
    }

    public static SqlSession getSqlSession(SqlSessionFactory sessionFactory, DataSource dataSource) {
        ExecutorType executorType = sessionFactory.getConfiguration().getDefaultExecutorType();
        return SqlSessionUtils.getSqlSession(sessionFactory, dataSource, executorType);
    }

    public static SqlSession getSqlSession(SqlSessionFactory sessionFactory, ExecutorType executorType) {
        DataSource dataSource = sessionFactory.getConfiguration().getEnvironment().getDataSource();
        return SqlSessionUtils.getSqlSession(sessionFactory, dataSource, executorType);
    }

    public static SqlSession getSqlSession(SqlSessionFactory sessionFactory, DataSource dataSource, ExecutorType executorType) {
        SqlSessionHolder holder = (SqlSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (holder != null && holder.isSynchronizedWithTransaction()) {
            holder.requested();
            logger.debug((Object)"Fetching SqlSession from current transaction");
            return holder.getSqlSession();
        }
        boolean transactionAware = dataSource instanceof TransactionAwareDataSourceProxy;
        Connection con = null;
        try {
            con = transactionAware ? dataSource.getConnection() : DataSourceUtils.getConnection((DataSource)dataSource);
        }
        catch (SQLException sqle) {
            throw new CannotGetJdbcConnectionException("Could not get JDBC Connection for SqlSession", sqle);
        }
        if (!SqlSessionUtils.usesManagedTransactions(sessionFactory.getConfiguration()) && DataSourceUtils.isConnectionTransactional((Connection)SqlSessionUtils.unwrapConnection(holder.getSqlSession()), (DataSource)dataSource)) {
            throw new IllegalTransactionStateException("Pre-bound JDBC Connection found! iBATIS SqlSession does not support running within DataSourceTransactionManager if told to manage the DataSource itself.");
        }
        logger.debug((Object)"Creating SqlSession from SqlSessionFactory");
        SqlSession session = sessionFactory.openSession(executorType, con);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug((Object)"Registering transaction synchronization for SqlSession");
            holder = new SqlSessionHolder(session, dataSource);
            TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)holder));
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SqlSessionSynchronization(holder, sessionFactory, dataSource));
            holder.setSynchronizedWithTransaction(true);
            holder.requested();
        }
        return session;
    }

    public static void commitSqlSession(SqlSession session, SqlSessionFactory sessionFactory) throws SQLException {
        SqlSessionUtils.commitSqlSession(session, sessionFactory, false);
    }

    public static void commitSqlSession(SqlSession session, SqlSessionFactory sessionFactory, boolean force) throws SQLException {
        SqlSessionHolder holder = (SqlSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (holder == null) {
            if (SqlSessionUtils.shouldManageConnection(session, session.getConfiguration().getEnvironment().getDataSource())) {
                logger.debug((Object)"Commiting non-transactional SqlSession JDBC Connection");
                session.getConnection().commit();
            }
            logger.debug((Object)"Commiting non-transactional SqlSession");
            session.commit(force);
        }
    }

    public static void rollbackSqlSession(SqlSession session, SqlSessionFactory sessionFactory) throws SQLException {
        SqlSessionUtils.rollbackSqlSession(session, sessionFactory, false);
    }

    public static void rollbackSqlSession(SqlSession session, SqlSessionFactory sessionFactory, boolean force) throws SQLException {
        SqlSessionHolder holder = (SqlSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (holder == null) {
            if (SqlSessionUtils.shouldManageConnection(session, session.getConfiguration().getEnvironment().getDataSource())) {
                logger.debug((Object)"Rolling back non-transactional SqlSession JDBC Connection");
                session.getConnection().commit();
            }
            logger.debug((Object)"Rolling back non-transactional SqlSession");
            session.rollback(force);
        } else {
            holder.setRollbackOnly();
        }
    }

    public static void closeSqlSession(SqlSession session, SqlSessionFactory sessionFactory) {
        SqlSessionHolder holder = (SqlSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (holder == null || session != holder.getSqlSession()) {
            if (SqlSessionUtils.shouldManageConnection(session, session.getConfiguration().getEnvironment().getDataSource())) {
                logger.debug((Object)"Closing non-transactional SqlSession JDBC Connection");
                DataSourceUtils.releaseConnection((Connection)session.getConnection(), null);
            }
            session.close();
        } else {
            DataSourceUtils.releaseConnection((Connection)SqlSessionUtils.unwrapConnection(session), (DataSource)holder.getDataSource());
            holder.released();
        }
    }

    public static boolean shouldManageConnection(SqlSession session, DataSource dataSource) {
        Configuration configuration = session.getConfiguration();
        if (SqlSessionUtils.usesManagedTransactions(configuration)) {
            return !DataSourceUtils.isConnectionTransactional((Connection)SqlSessionUtils.unwrapConnection(session), (DataSource)dataSource);
        }
        if (DataSourceUtils.isConnectionTransactional((Connection)SqlSessionUtils.unwrapConnection(session), (DataSource)dataSource)) {
            throw new IllegalStateException("iBATIS is not using ManagedTransactions and the current JDBC Connection is transactional. Cannot determine what to do with the current Connection.");
        }
        return false;
    }

    public static boolean usesManagedTransactions(Configuration configuration) {
        return configuration.getEnvironment().getTransactionFactory().getClass().isAssignableFrom(ManagedTransactionFactory.class);
    }

    public static boolean isSqlSessionTransactional(SqlSession session, SqlSessionFactory sessionFactory) {
        if (sessionFactory == null) {
            return false;
        }
        SqlSessionHolder holder = (SqlSessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        return holder != null && holder.getSqlSession() == session;
    }

    private static Connection unwrapConnection(SqlSession session) {
        InvocationHandler handler;
        Connection con = session.getConnection();
        if (Proxy.isProxyClass(con.getClass()) && (handler = Proxy.getInvocationHandler(con)) instanceof ConnectionLogger) {
            con = ((ConnectionLogger)handler).getConnection();
        }
        return con;
    }

    private static final class SqlSessionSynchronization
    extends TransactionSynchronizationAdapter {
        private final SqlSessionHolder holder;
        private final SqlSessionFactory sessionFactory;
        private final boolean manageConnection;

        public SqlSessionSynchronization(SqlSessionHolder holder, SqlSessionFactory sessionFactory, DataSource dataSource) {
            Assert.notNull((Object)((Object)holder));
            Assert.notNull((Object)sessionFactory);
            this.holder = holder;
            this.sessionFactory = sessionFactory;
            this.manageConnection = SqlSessionUtils.usesManagedTransactions(holder.getSqlSession().getConfiguration()) && !DataSourceUtils.isConnectionTransactional((Connection)SqlSessionUtils.unwrapConnection(holder.getSqlSession()), (DataSource)dataSource);
        }

        public int getOrder() {
            return 1001;
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)this.holder.getSqlSession());
        }

        public void afterCommit() {
            try {
                try {
                    if (this.manageConnection) {
                        logger.debug((Object)"Transaction synchronization committing JDBC Connection");
                        this.holder.getSqlSession().getConnection().commit();
                    }
                }
                catch (SQLException sqle) {
                    throw new CleanupFailureDataAccessException("SqlSessionSynchronization could not commit", (Throwable)sqle);
                }
            }
            finally {
                logger.debug((Object)"Transaction synchronization committing SqlSession");
                this.holder.getSqlSession().commit(true);
            }
        }

        public void afterCompletion(int status) {
            try {
                try {
                    if (status != 0) {
                        logger.debug((Object)"Transaction synchronization rolling back SqlSession");
                        this.holder.getSqlSession().rollback(true);
                        if (this.manageConnection) {
                            logger.debug((Object)"Transaction synchronization rolling back JDBC Connection");
                            this.holder.getSqlSession().getConnection().rollback();
                        }
                    }
                }
                catch (SQLException sqle) {
                    throw new CleanupFailureDataAccessException("SqlSessionSynchronization could not rollback", (Throwable)sqle);
                }
            }
            finally {
                if (!this.holder.isOpen()) {
                    logger.debug((Object)"Transaction synchronization closing SqlSession");
                    TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                    this.holder.getSqlSession().close();
                }
            }
        }
    }
}

