/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ibatis3.support;

import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DaoSupport;
import org.springframework.orm.ibatis3.SqlSessionTemplate;
import org.springframework.util.Assert;

public abstract class SqlSessionDaoSupport
extends DaoSupport {
    private SqlSessionTemplate sqlSessionTemplate = new SqlSessionTemplate();
    private boolean externalTemplate = false;

    public final void setDataSource(DataSource dataSource) {
        if (!this.externalTemplate) {
            this.sqlSessionTemplate.setDataSource(dataSource);
        }
    }

    public final DataSource getDataSource() {
        return this.sqlSessionTemplate.getDataSource();
    }

    @Autowired
    public final void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        if (!this.externalTemplate) {
            this.sqlSessionTemplate.setSqlSessionFactory(sqlSessionFactory);
        }
    }

    public final SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionTemplate.getSqlSessionFactory();
    }

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        Assert.notNull((Object)sqlSessionTemplate, (String)"SqlSessionTemplate must not be null");
        this.sqlSessionTemplate = sqlSessionTemplate;
        this.externalTemplate = true;
    }

    public final SqlSessionTemplate getSqlSessionTemplate() {
        return this.sqlSessionTemplate;
    }

    protected void checkDaoConfig() {
        if (!this.externalTemplate) {
            this.sqlSessionTemplate.afterPropertiesSet();
        }
    }
}

