/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xdoclet;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.xdoclet.Config;
import org.codehaus.xdoclet.Util;
import org.xdoclet.JavaSourceProvider;

public class Maven2SourceProvider
implements JavaSourceProvider {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String encoding;
    private final List compileSourceRoots;
    private final List sourceJars;
    private final String[] includes;
    private final String[] excludes;
    private static final boolean caseSensitive = true;

    public Maven2SourceProvider(Config config, List compileSourceRoots, List sourceJars) {
        this.encoding = config.getEncoding();
        this.compileSourceRoots = compileSourceRoots;
        this.sourceJars = sourceJars;
        this.includes = Util.toTrimmedStringArray(config.getIncludes());
        this.excludes = Util.toTrimmedStringArray(config.getExcludes());
    }

    public Collection getURLs() throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterator it = this.compileSourceRoots.iterator();
        while (it.hasNext()) {
            String baseDir = (String)it.next();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(baseDir);
            scanner.setFollowSymlinks(true);
            scanner.setExcludes(this.excludes);
            scanner.setIncludes(this.includes);
            scanner.addDefaultExcludes();
            scanner.scan();
            String[] files = scanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(baseDir, files[i]);
                urls.add(file.toURL());
            }
        }
        Iterator itSrcJars = this.sourceJars.iterator();
        while (itSrcJars.hasNext()) {
            File file = (File)itSrcJars.next();
            URL fileUrl = file.toURI().toURL();
            String urlPrefix = "jar:" + fileUrl.toExternalForm() + "!/";
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!this.isIncluded(entryName) || this.isExcluded(entryName)) continue;
                URL url = new URL(urlPrefix + entryName);
                urls.add(url);
            }
        }
        return urls;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected boolean isIncluded(String name) {
        for (int i = 0; i < this.includes.length; ++i) {
            if (!Maven2SourceProvider.matchPath(this.includes[i], name, true)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcluded(String name) {
        for (int i = 0; i < this.excludes.length; ++i) {
            if (!Maven2SourceProvider.matchPath(this.excludes[i], name, true)) continue;
            return true;
        }
        return false;
    }

    protected static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath((String)pattern, (String)str, (boolean)isCaseSensitive);
    }
}

