/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xdoclet;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.xdoclet.Component;
import org.codehaus.xdoclet.Config;
import org.codehaus.xdoclet.Maven2SourceProvider;
import org.codehaus.xdoclet.Util;
import org.nanocontainer.DefaultNanoContainer;
import org.nanocontainer.integrationkit.ContainerComposer;
import org.nanocontainer.integrationkit.DefaultLifecycleContainerBuilder;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.BeanPropertyComponentAdapter;
import org.picocontainer.defaults.BeanPropertyComponentAdapterFactory;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.ObjectReference;
import org.picocontainer.defaults.SimpleReference;

public class XDocletMojo
extends AbstractMojo {
    private List configs = new LinkedList();
    private final ObjectReference containerRef = new SimpleReference();
    private MavenProject project;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private String sourceArtifacts;
    private String sourcesOuputDirectory;
    private String resourcesOutputDirectory;
    static /* synthetic */ Class class$org$generama$velocity$ClasspathFileResourceVelocityComponent;
    static /* synthetic */ Class class$org$xdoclet$QDoxMetadataProvider;
    static /* synthetic */ Class class$org$generama$defaults$FileWriterMapper;
    static /* synthetic */ Class class$org$generama$JellyTemplateEngine;
    static /* synthetic */ Class class$org$generama$MergeableVelocityTemplateEngine;
    static /* synthetic */ Class class$org$generama$FreeMarkerTemplateEngine;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList<File> dependenciesSourcesURLs = new ArrayList<File>();
        List sourceDependencyIncludes = Util.toTrimmedList(this.sourceArtifacts);
        PatternIncludesArtifactFilter filter = new PatternIncludesArtifactFilter(sourceDependencyIncludes, true);
        if (!sourceDependencyIncludes.isEmpty()) {
            List remoteArtifactRepositories = this.project.getRemoteArtifactRepositories();
            List deps = this.project.getDependencies();
            Iterator itDeps = deps.iterator();
            while (itDeps.hasNext()) {
                Dependency dep = (Dependency)itDeps.next();
                String artifactId = dep.getArtifactId();
                String groupId = dep.getGroupId();
                String version = dep.getVersion();
                Artifact a = this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, "java-source", "sources");
                try {
                    if (!filter.include(a)) continue;
                    this.artifactResolver.resolve(a, remoteArtifactRepositories, this.localRepository);
                    if (a.getFile() == null) {
                        throw new ArtifactNotFoundException("Can't resolve", a);
                    }
                    dependenciesSourcesURLs.add(a.getFile());
                }
                catch (ArtifactNotFoundException e) {
                    throw new MojoExecutionException("Source artifact for " + groupId + ":" + artifactId + ":" + version + " was not found : " + e.getMessage());
                }
                catch (ArtifactResolutionException e) {
                    this.getLog().warn((CharSequence)("Could not download source artifact for " + groupId + ":" + artifactId + ":" + version + " : " + e.getMessage()));
                }
            }
        }
        Iterator it = this.configs.iterator();
        while (it.hasNext()) {
            Config config = (Config)it.next();
            this.getLog().debug((CharSequence)config.toString());
            String defaultOuputPath = this.project.getBuild().getDirectory() + "/generated-resources/xdoclet";
            String outputPath = this.resolveOutputDir(config, defaultOuputPath);
            Map<String, String> defaultPluginProps = Collections.singletonMap("destdir", outputPath);
            PluginContainerComposer containerComposer = new PluginContainerComposer(config, defaultPluginProps, this.project.getCompileSourceRoots(), dependenciesSourcesURLs);
            PluginLifecycleContainerBuilder containerBuilder = new PluginLifecycleContainerBuilder(containerComposer);
            try {
                containerBuilder.buildContainer(this.containerRef, null, null, true);
                containerBuilder.killContainer(this.containerRef);
            }
            catch (UndeclaredThrowableException e) {
                Throwable ex = e.getUndeclaredThrowable();
                if (ex instanceof InvocationTargetException) {
                    ex = ((InvocationTargetException)ex).getTargetException();
                }
                throw new MojoExecutionException("Undeclared: ", ex);
            }
            catch (RuntimeException e) {
                throw new MojoExecutionException("XDoclet plugin failed: " + e.getMessage(), (Exception)e);
            }
            File outpathFile = new File(outputPath);
            if (!outpathFile.exists()) continue;
            if (config.isAddToSources()) {
                if (!outputPath.equals(this.sourcesOuputDirectory)) {
                    this.copyOutput(outpathFile, new File(this.sourcesOuputDirectory), config.getExcludes(), config.getIncludes());
                }
                this.getLog().debug((CharSequence)("Adding " + this.sourcesOuputDirectory + " to compiler path"));
                this.project.addCompileSourceRoot(this.sourcesOuputDirectory);
            }
            if (!config.isAddToResources()) continue;
            if (!outputPath.equals(this.resourcesOutputDirectory)) {
                this.copyOutput(outpathFile, new File(this.resourcesOutputDirectory), config.getResourcesExcludes(), config.getResourcesIncludes());
            }
            Resource resource = new Resource();
            this.getLog().debug((CharSequence)("Adding " + this.resourcesOutputDirectory + " to resources"));
            resource.setDirectory(this.resourcesOutputDirectory);
            resource.addInclude(config.getResourcesIncludes());
            resource.addExclude(config.getResourcesExcludes());
            this.project.addResource(resource);
        }
    }

    public List getConfigs() {
        return this.configs;
    }

    private String resolveOutputDir(Config config, String defaultOuputPath) {
        String destDir;
        String out = defaultOuputPath;
        Map params = config.getParams();
        if (params != null && (destDir = (String)params.get("destdir")) != null) {
            out = destDir;
        }
        return out;
    }

    void copyOutput(File inputDir, File outputDir, String excludes, String includes) throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setExcludes(Util.toTrimmedStringArray(excludes));
        scanner.setIncludes(Util.toTrimmedStringArray(includes));
        scanner.setBasedir(inputDir);
        scanner.addDefaultExcludes();
        scanner.scan();
        List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
        Iterator<String> j = includedFiles.iterator();
        while (j.hasNext()) {
            String name = j.next();
            File source = new File(inputDir, name);
            File destinationFile = new File(outputDir, name);
            if (!destinationFile.getParentFile().exists()) {
                destinationFile.getParentFile().mkdirs();
            }
            try {
                if (destinationFile.lastModified() >= source.lastModified()) continue;
                FileUtils.copyFile((File)source, (File)destinationFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying resources", (Exception)e);
            }
        }
    }

    public void setConfigs(List configs) {
        this.configs = configs;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PluginLifecycleContainerBuilder
    extends DefaultLifecycleContainerBuilder {
        private BeanPropertyComponentAdapterFactory propertyFactory = new BeanPropertyComponentAdapterFactory((ComponentAdapterFactory)new DefaultComponentAdapterFactory());

        private PluginLifecycleContainerBuilder(ContainerComposer composer) {
            super(composer);
        }

        protected PicoContainer createContainer(PicoContainer parentContainer, Object assemblyScope) {
            return new DefaultPicoContainer((ComponentAdapterFactory)this.propertyFactory);
        }
    }

    private static class PluginContainerComposer
    implements ContainerComposer {
        private final List compileSourceRoots;
        private final List dependenciesSourcesURLs;
        private final Config config;
        private final Map defaultPluginProps;

        public PluginContainerComposer(Config config, Map defaultPluginProps, List compileSourceRoots, List dependenciesSourcesURLs) {
            this.config = config;
            this.defaultPluginProps = defaultPluginProps;
            this.compileSourceRoots = compileSourceRoots;
            this.dependenciesSourcesURLs = dependenciesSourcesURLs;
        }

        public void composeContainer(MutablePicoContainer pico, Object assemblyScope) {
            pico.registerComponentImplementation(class$org$generama$velocity$ClasspathFileResourceVelocityComponent == null ? (class$org$generama$velocity$ClasspathFileResourceVelocityComponent = XDocletMojo.class$("org.generama.velocity.ClasspathFileResourceVelocityComponent")) : class$org$generama$velocity$ClasspathFileResourceVelocityComponent);
            pico.registerComponentImplementation(class$org$xdoclet$QDoxMetadataProvider == null ? (class$org$xdoclet$QDoxMetadataProvider = XDocletMojo.class$("org.xdoclet.QDoxMetadataProvider")) : class$org$xdoclet$QDoxMetadataProvider);
            pico.registerComponentImplementation(class$org$generama$defaults$FileWriterMapper == null ? (class$org$generama$defaults$FileWriterMapper = XDocletMojo.class$("org.generama.defaults.FileWriterMapper")) : class$org$generama$defaults$FileWriterMapper);
            pico.registerComponentImplementation(class$org$generama$JellyTemplateEngine == null ? (class$org$generama$JellyTemplateEngine = XDocletMojo.class$("org.generama.JellyTemplateEngine")) : class$org$generama$JellyTemplateEngine);
            pico.registerComponentImplementation(class$org$generama$MergeableVelocityTemplateEngine == null ? (class$org$generama$MergeableVelocityTemplateEngine = XDocletMojo.class$("org.generama.MergeableVelocityTemplateEngine")) : class$org$generama$MergeableVelocityTemplateEngine);
            pico.registerComponentImplementation(class$org$generama$FreeMarkerTemplateEngine == null ? (class$org$generama$FreeMarkerTemplateEngine = XDocletMojo.class$("org.generama.FreeMarkerTemplateEngine")) : class$org$generama$FreeMarkerTemplateEngine);
            Maven2SourceProvider sourceProvider = new Maven2SourceProvider(this.config, this.compileSourceRoots, this.dependenciesSourcesURLs);
            pico.registerComponentInstance((Object)sourceProvider);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            DefaultNanoContainer nano = new DefaultNanoContainer(cl, pico);
            Iterator iter = this.config.getComponents().iterator();
            while (iter.hasNext()) {
                Component comp = (Component)iter.next();
                try {
                    BeanPropertyComponentAdapter adapter = (BeanPropertyComponentAdapter)nano.registerComponentImplementation((Object)comp.toString(), comp.getClassname());
                    HashMap mergedProps = new HashMap();
                    mergedProps.putAll(this.defaultPluginProps);
                    mergedProps.putAll(this.config.getParams());
                    mergedProps.putAll(comp.getParams());
                    adapter.setProperties(mergedProps);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Class Not Found: " + e.getMessage(), e);
                }
            }
        }
    }
}

