/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.alimenty.sprawozdanie;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.xml.sax.InputSource;
import pl.topteam.alimenty.sprawozdanie.wer4.\u015awiadczeniaAlimentacyjne1;

public class Sprawozdania {
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();
    private static final Map<String, Class> WERSJA = new HashMap<String, Class>();

    public static Object wczytaj(byte[] sprawozdanie) {
        try {
            Unmarshaller unmarshaller = Sprawozdania.utworzContext(sprawozdanie).createUnmarshaller();
            return unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(sprawozdanie));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static JAXBContext utworzContext(byte[] bytes) throws JAXBException {
        String wersja = (String)Preconditions.checkNotNull((Object)Sprawozdania.pobierzWersjeFormularza(bytes), (Object)"Nie uda\u0142o si\u0119 ustali\u0107 wersji formularza");
        Class klasaSprawozdania = (Class)Preconditions.checkNotNull((Object)WERSJA.get(wersja), (String)"Nie uda\u0142o si\u0119 ustali\u0107 contextu dla wersji %s", (Object[])new Object[]{wersja});
        return JAXBContext.newInstance((Class[])new Class[]{klasaSprawozdania});
    }

    public static String pobierzWersjeFormularza(byte[] bytes) {
        XPath xpath = XPATH_FACTORY.newXPath();
        try {
            return xpath.evaluate("/*/@Wersja-formularza", new InputSource(new ByteArrayInputStream(bytes)));
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    public static String drukuj(Object sprawozdanie) {
        String string;
        block8: {
            InputStream styl = sprawozdanie.getClass().getResourceAsStream("styl.xslt");
            try {
                Preconditions.checkNotNull((Object)styl, (String)"nie uda\u0142o si\u0119 odnale\u017a\u0107 xslt dla klasy: %s", (Object[])new Object[]{sprawozdanie.getClass()});
                string = Sprawozdania.transformuj(sprawozdanie, styl);
                if (styl == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (styl != null) {
                        try {
                            styl.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | JAXBException | TransformerException e) {
                    throw new RuntimeException(e);
                }
            }
            styl.close();
        }
        return string;
    }

    private static String transformuj(Object sprawozdanie, InputStream styl) throws TransformerException, JAXBException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(styl));
        JAXBSource xmlSource = new JAXBSource(JAXBContext.newInstance((Class[])new Class[]{sprawozdanie.getClass()}), sprawozdanie);
        StringWriter sw = new StringWriter();
        transformer.transform((Source)xmlSource, new StreamResult(sw));
        return sw.toString();
    }

    public static Properties wczytajSciezki(Object sprawozdanie) {
        Properties properties;
        block8: {
            InputStream sciezki = sprawozdanie.getClass().getResourceAsStream("sciezki.xml");
            try {
                Preconditions.checkNotNull((Object)"nie uda\u0142o si\u0119 odnale\u017a\u0107 \u015bcie\u017cek dla klasy: %s", sprawozdanie.getClass());
                Properties properties2 = new Properties();
                properties2.loadFromXML(sciezki);
                properties = properties2;
                if (sciezki == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (sciezki != null) {
                        try {
                            sciezki.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            sciezki.close();
        }
        return properties;
    }

    public static void zapisz(Object sprawozdanie, Writer writer) {
        try {
            Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{sprawozdanie.getClass()}).createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(sprawozdanie, writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String pobierzSzablon(Class klasa) {
        try (InputStream is = klasa.getResourceAsStream("szablon.xml");){
            String string;
            try (InputStreamReader isr = new InputStreamReader(is, Charsets.UTF_8);){
                string = CharStreams.toString((Readable)isr);
            }
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        WERSJA.put("1.00", pl.topteam.alimenty.sprawozdanie.wer1.\u015awiadczeniaAlimentacyjne1.class);
        WERSJA.put("2.00", pl.topteam.alimenty.sprawozdanie.wer2.\u015awiadczeniaAlimentacyjne1.class);
        WERSJA.put("1.03a", pl.topteam.alimenty.sprawozdanie.wer3.\u015awiadczeniaAlimentacyjne1.class);
        WERSJA.put("1.04", \u015awiadczeniaAlimentacyjne1.class);
        WERSJA.put("1.04a", pl.topteam.alimenty.sprawozdanie.wer5.\u015awiadczeniaAlimentacyjne1.class);
        WERSJA.put("1.04b", pl.topteam.alimenty.sprawozdanie.wer6.\u015awiadczeniaAlimentacyjne1.class);
        WERSJA.put("1.04c", pl.topteam.alimenty.sprawozdanie.wer7.\u015awiadczeniaAlimentacyjne1.class);
    }
}

