<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet	version="1.0"
						xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
						xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.2'"/>
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator="," />
	<xsl:variable name="obsada" select="'###&#160;###&#160;###&#160;##0,00'" />
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'" />
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'" />
	<xsl:variable name="width" select="'944'" />
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">

				<style type="text/css">
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
												font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>px;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1	{color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>px;
                                				}
                    		.heading_2	{color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption			{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       		{width: <xsl:value-of select="$width"/>px; padding-top: 6px;
                                				}

							.tab_col_no	{text-align: center; vertical-align: middle; color: #000000;
												font-family: Tahoma, Verdana; font-size: 10px;
												font-weight: normal;
												}
							.tab_row_no	{padding-left: 5px; padding-top: 5px; padding-bottom: 5px;
												color: #000000; font-family: Tahoma, Verdana; font-size: 10px;
												text-align: left; vertical-align: middle; font-weight: bold;
												}
                   			 .contents		{height: 2.5em;
												padding-right: 2px; padding-top: 2px; padding-bottom: 2px;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: right; vertical-align: middle; font-weight: bold;
                                				}
                   			 .totals			{height: 2.5em;
												padding-right: 2px; padding-top: 2px; padding-bottom: 2px;
                                 				background-color: silver; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: right; vertical-align: middle; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; padding-top: 5px; padding-bottom: 5px;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: left; vertical-align: middle; font-weight: normal;
                                				}
                    		.remark			{padding-left: 8px; text-align: justify; vertical-align: baseline;
                                				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				padding-top: 4px; font-weight: normal;
                                				}
                    		.stars			{padding-left: 2px; text-align: left; vertical-align: super;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				padding-top: 2px; font-weight: normal; width: 10px;
                                				}
                    		.xslt_ver		{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; padding-top: 24px;
                                				}
                    		.empty			{border: 0 0 0 0;}
				</style>
				<xsl:apply-templates select="Świadczenia-alimentacyjne-1"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Świadczenia-alimentacyjne-1">
		<xsl:apply-templates select="Metryczka"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Część_A"/>
		<xsl:apply-templates select="Część_B"/>
		<xsl:apply-templates select="Część_C"/>
		<xsl:apply-templates select="Część_D"/>
		<xsl:apply-templates select="Część_E"/>
		<xsl:apply-templates select="Część_F"/>
		<xsl:apply-templates select="Część_G"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/> <br/> <br/>
			</div>
		</xsl:if>

		<xsl:for-each select="../Nagłówek/Dane-jednostki-org">
			 <table cellspacing="0" cellpadding="0">
				<tr>
					<td class="stamp" colspan="2">
						<xsl:value-of select="Pełna-nazwa" />
					</td>
				</tr>
				 <xsl:for-each select="Adres-pocztowy">
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Ulica-i-numer" />
						</td>
					</tr>
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Kod-i-poczta" />
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="stamp" style="font-size: 12px; text-align: left">
						<xsl:for-each select="Telefon">
							Tel. <xsl:apply-templates/>&#160;
 						</xsl:for-each>
					</td>
					<td class="stamp" style="font-size: 12px; text-align: right">
						<xsl:for-each select="Faks">
							&#160;Fax <xsl:apply-templates />
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</xsl:for-each>

		<br/><br/>
		<div class="auth_name">
			<xsl:for-each select="../Nagłówek">
				<xsl:for-each select="Wojewoda">
					Wojewoda <xsl:apply-templates />
				</xsl:for-each>
				<xsl:for-each select="Gmina">
					Gmina <xsl:apply-templates />
				</xsl:for-each>
				<!--xsl:for-each select="Wojewoda">
					Wojewoda/<span style="text-decoration: line-through">Gmina</span><sup>1)</sup>&#160;&#160;<xsl:apply-templates />
				</xsl:for-each>
				<xsl:for-each select="Gmina">
					<span style="text-decoration: line-through">Wojewoda</span>/Gmina<sup>1)</sup>&#160;&#160;<xsl:apply-templates />
				</xsl:for-each-->
			</xsl:for-each>
		</div>
		<br/><br/>
		<div class="heading_1">
			SPRAWOZDANIE
			<xsl:if test="../Nagłówek/Wojewoda">ZBIORCZE</xsl:if>
			Z REALIZACJI ZADAŃ PRZEWIDZIANYCH W USTAWIE<br/> O POMOCY
OSOBOM UPRAWNIONYM DO ALIMENTÓW<!--sup> 2) 3)</sup--><br/>
			<span class="heading_2">
				<xsl:for-each select="Za-okres">
					<xsl:for-each select="Miesiąc">
						za <xsl:apply-templates />
					</xsl:for-each>
					<xsl:for-each select="Kwartał">
						za <xsl:apply-templates /> kwartał
					</xsl:for-each>
						<xsl:value-of select="concat(' ', Rok, ' r.')" />
				</xsl:for-each>
			</span>
		</div>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table width="800">
			<!--caption>Osoba&#160;sporządzająca&#160;sprawozdanie:</caption-->
			<tr>
				<th colspan="2" align="left">Osoba&#160;sporządzająca&#160;sprawozdanie:</th>
				<th align="center">Organ<br/>sporządzający sprawozdanie</th>
			</tr>
			<tr>
				<td>imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
				<td rowspan="5" align="center" valign="top">
					<xsl:for-each select="Nagłówek">
						<xsl:for-each select="Wojewoda">
							Wojewoda&#160;&#160;<xsl:apply-templates />
						</xsl:for-each>
						<xsl:for-each select="Gmina">
							Gmina&#160;&#160;<xsl:apply-templates />
						</xsl:for-each>
					</xsl:for-each>
				</td>
			</tr>
			<tr>
				<td>telefon:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td>e-mail:</td>
				<td>
					<xsl:value-of select="$kto/E-mail"/>
				</td>
			</tr>
			<tr>
				<td>podpis:</td> <td>........................................</td>
			</tr>
			<tr>
				<td>data:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
		</table>

		<br/><br/>
		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="xslt_ver" style="text-align: left;">
					Wersja szablonu XSLT: <xsl:value-of select="$wersja"/>
				</td>
				<td class="xslt_ver" style="text-align: right;">
					<xsl:value-of select="concat('XSLT wersja ', system-property('xsl:version'), ', producent: ', system-property('xsl:vendor'))"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="sumuj">
		<xsl:param name="wynik"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma"/>
		<xsl:choose>
			<xsl:when test="$suma!=''">
				<xsl:call-template name="sumuj">
					<xsl:with-param name="wynik" select="$wynik+substring-before($suma,'+')"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="suma" select="substring-after($suma,'+')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string(number($wynik)) = 'NaN'">
						<td class="totals" style="background-color: red">
							<center>???</center>
						</td>
					</xsl:when>
					<xsl:when test="string(number($contents)) != 'NaN' and $contents != ''">
						<td class="totals">
							<xsl:value-of select="format-number($wynik, $format)"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($wynik, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Table-caption">
		<xsl:param name="width"/>
		<table border="0">
 			<xsl:attribute name="style">
 				<xsl:if test="name() != 'Część_A'">
 					page-break-before: always;
 				</xsl:if>
 				text-align: left; font-family: Tahoma, Verdana;
 				font-size: 18px; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px;
			</xsl:attribute>
			<tr style="vertical-align: top;">
				<td style="width: 1.5em;">
					<xsl:value-of select="concat(substring-after(name(.), '_'), '. ')"/>
				</td>
				<td style="margin-left: 0.2em">
					<xsl:choose>
						<xsl:when test="name(.) = 'Część_C'">
							<xsl:value-of select="@Opis"/>
							<!--xsl:value-of select="substring-before(@Opis, 'i zaliczek alimentacyjnych')"/>
							i&#160;zaliczek alimentacyjnych<sup>1)</sup>
							<xsl:value-of select="substring-after(@Opis, 'alimentacyjnych')"/-->
						</xsl:when>
						<xsl:when test="name(.) = 'Część_G'">
							<xsl:value-of select="@Opis"/>
							<!--xsl:value-of select="@Opis"/><span style="font-size: 12px; vertical-align: top;">1)</span-->
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="@Opis"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Row-description">
		<td class="tab_row_no">
			<xsl:value-of select="concat(substring-after(@Pozycja, '_'), '.')" />
		</td>
		<td class="row_descr">
			<xsl:choose>
				<!--xsl:when test="@Pozycja = 'A_4.1' or @Pozycja = 'A_4.2' or @Pozycja = 'A_4.3'">
					<xsl:value-of select="@Opis"/><sup>3)</sup>
				</xsl:when-->
				<xsl:when test="@Pozycja = 'B_5'">
					<xsl:value-of select="substring-before(@Opis, 'alimentacyjnych')"/>
					alimentacyjnych<sup>2)</sup>
					<xsl:value-of select="substring-after(@Opis, 'alimentacyjnych')"/>
				</xsl:when>
				<xsl:when test="@Pozycja = 'C_3'">
					<xsl:value-of select="@Opis"/><sup>1)</sup>
				</xsl:when>
				<xsl:when test="@Pozycja = 'D_1' or @Pozycja = 'D_2' or @Pozycja = 'D_6'">
					<xsl:value-of select="substring-before(@Opis, 'budżetowej')"/>
					budżetowej<sup>2)</sup>
					<xsl:value-of select="substring-after(@Opis, 'budżetowej')"/>
				</xsl:when>
				<!--xsl:when test="@Pozycja = 'D_7'">
					<xsl:value-of select="substring-before(@Opis, 'ustawy')"/>
					ustawy<sup>3)</sup>
					<xsl:value-of select="substring-after(@Opis, 'ustawy')"/>
				</xsl:when-->
				<!--xsl:when test="@Pozycja = 'E_5.1' or @Pozycja = 'E_5.2' or @Pozycja = 'E_5.3' or @Pozycja = 'E_5.4' or @Pozycja = 'E_6' or @Pozycja = 'F_10.2'">
					<xsl:value-of select="substring-before(@Opis, 'ustawy')"/>
					ustawy<sup>1)</sup>
					<xsl:value-of select="substring-after(@Opis, 'ustawy')"/>
				</xsl:when-->
				<xsl:when test="@Pozycja = 'F_3'">
					<xsl:value-of select="substring-before(@Opis, 'zobowiązaną')"/>
					<span style="text-decoration: underline">zobowiązaną</span>
					<xsl:value-of select="substring-after(@Opis, 'zobowiązaną')"/>
				</xsl:when>
				<xsl:when test="@Pozycja = 'F_4'">
					<xsl:value-of select="substring-before(@Opis, 'niezobowiązaną')"/>
					<span style="text-decoration: underline">niezobowiązaną</span>
					<xsl:value-of select="substring-after(@Opis, 'niezobowiązaną')"/>
				</xsl:when>
				<!--xsl:when test="@Pozycja = 'F_11'">
					<xsl:value-of select="@Opis"/><sup>2)</sup>
				</xsl:when-->
				<!--xsl:when test="@Pozycja = 'G_6' or @Pozycja = 'G_11'">
					<xsl:value-of select="substring-before(@Opis, 'ustawy')"/>
					ustawy<sup>2)</sup>
					<xsl:value-of select="substring-after(@Opis, 'ustawy')"/>
				</xsl:when-->
				<xsl:otherwise>
					<xsl:value-of select="@Opis"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="_A_add_tree_12">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="contents" select="../../*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="skladniki"/>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:for-each select="../../../*[contains(concat($skladniki, ' '),concat(@Pozycja,' '))]/*[name(.) = $subtree]/*[name(.) = $column]">
					<xsl:call-template name="_A_add_tree_12">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="skladniki" select="../../@Składniki"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_A_add_tree_34">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="contents" select="../../../*[name(.) = $subtree]/Trzy-miesiące/*[name(.) = $column]"/>
		<xsl:param name="skladniki"/>
		<xsl:choose>
			<xsl:when test="$skladniki and $contents = ''">
				<xsl:for-each select="../../../../*[contains(concat($skladniki, ' '),concat(@Pozycja,' '))]/*[name(.) = $subtree]/Trzy-miesiące/*[name(.) = $column]">
					<xsl:call-template name="_A_add_tree_34">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="skladniki" select="../../../@Składniki"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="string(../../../*[name(.) = $subtree]/Trzy-miesiące/*[name(.) = $column]/@xsi:nil) != 'true'">
					<xsl:value-of select="$contents"/>
					<xsl:value-of select="'+'"/>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_A_total_12">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="items" select="../*[contains($skladniki,concat(@Pozycja,' '))]/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="suma">
			<xsl:for-each select="$items">
				<xsl:call-template name="_A_add_tree_12">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="skladniki" select="../../@Składniki"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_A_total_34">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="items" select="../*[contains($skladniki,concat(@Pozycja,' '))]/*[name(.) = $subtree]/Trzy-miesiące/*[name(.) = $column]"/>
		<xsl:param name="suma">
			<xsl:for-each select="$items">
				<xsl:choose>
					<xsl:when test=". != ''">
						<xsl:value-of select="."/>
						<xsl:value-of select="'+'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="_A_add_tree_34">
							<xsl:with-param name="subtree" select="$subtree"/>
							<xsl:with-param name="skladniki" select="../../../@Składniki"/>
							<xsl:with-param name="column" select="$column"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="$suma!=''">
				<xsl:call-template name="sumuj">
					<xsl:with-param name="wynik" select="0"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="suma" select="$suma"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="$contents"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_A_column_12">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:call-template name="_A_total_12">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:when test="string(number($contents)) = 'NaN'">
							<div style="color: red; text-align: center;">???</div>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_A_column_34">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/Trzy-miesiące/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:choose>
					<xsl:when test="string($item/@xsi:nil) = 'true'">
						<td class="totals">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="_A_total_34">
							<xsl:with-param name="subtree" select="$subtree"/>
							<xsl:with-param name="column" select="$column"/>
							<xsl:with-param name="contents" select="$contents"/>
							<xsl:with-param name="format" select="$format"/>
							<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:when test="string(number($contents)) = 'NaN'">
							<div style="color: red; text-align: center;">???</div>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_A_contents">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/> <xsl:param name="format"/>
		<xsl:call-template name="_A_column_12">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_A_column_12">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Dwa-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_A_column_34">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Razem'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-świadczeniobiorcy">
		<xsl:param name="skladniki"/>
		<xsl:call-template name="_A_contents">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Wydatki-narastająco'"/>
			<!--xsl:with-param name="format" select="$kwota"/-->
			<xsl:with-param name="format">
				<xsl:choose>
					<xsl:when test="not(starts-with(./@Pozycja, 'A_2'))"><xsl:value-of select="$kwota"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$obsada"/></xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
		</xsl:call-template>

		<xsl:choose>
			<xsl:when test="string(Liczba-świadczeń/@xsi:nil) = 'true'">
				<xsl:if test="position()=5">
					<td class="empty" colspan="4" rowspan="15"/>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="_A_contents">
					<xsl:with-param name="skladniki" select="$skladniki"/>
					<xsl:with-param name="subtree" select="'Liczba-świadczeń'"/>
					<xsl:with-param name="format" select="$liczba"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="A_header">
		<xsl:param name="descrwidth" select="26"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(round((100-number($descrwidth)-3) div 2))"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 4))"/>
		</xsl:param>
		<xsl:param name="double">
			<xsl:value-of select="string(number($single) * 2)"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="2">Lp.</th>
				<th rowspan="2"><xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					Kwoty narastająco od początku roku w złotych
				</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					Liczba wypłaconych świadczeń narastająco<br/>od początku roku
				</th>
			</tr>
			<tr>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy<br/>miesiąc<br/>kwartału</th>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>dwa<br/>miesiące<br/>kwartału</th>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>trzy miesiące<br/>kwartału</th>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy<br/>miesiąc<br/>kwartału</th>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>dwa<br/>miesiące<br/>kwartału</th>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>trzy miesiące<br/>kwartału</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
				<td class="tab_col_no">6</td>
				<td class="tab_col_no">7</td>
				<td class="tab_col_no">8</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_A">
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<xsl:call-template name="A_header"/>
			<tbody>
				<xsl:for-each select="Wydatki-i-świadczenia">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Wydatki-i-świadczeniobiorcy">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>

		_________
		<table style="padding-top: 6px;" width="600" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" valign="top">1)</td>
				<td class="remark">
					Niepotrzebne skreślić
				</td>
			</tr>
			<tr>
				<td class="stars" valign="top">2)</td>
				<td class="remark">
					<xsl:choose>
						<xsl:when test="name(.) = 'Część_A'">
							Zasada narastania nie dotyczy wiersza 4.
						</xsl:when>
						<xsl:otherwise>
							Dotyczy ustawy z dnia 7 września 2007 r. o pomocy osobom uprawnionym do alimentów (Dz. U. Nr 192, poz. 1378).
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<!--xsl:if test="name(.) = 'Część_A'">
				<tr>
					<td class="stars" valign="top">3)</td>
					<td class="remark">
							Dotyczy ustawy z dnia 7 września 2007 r. o pomocy osobom uprawnionym do alimentów (Dz. U. Nr 192, poz. 1378).
					</td>
				</tr>
			</xsl:if-->
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="BCD_row">
		<xsl:param name="format" select="$liczba"/>
		<xsl:call-template name="BCD_column">
			<xsl:with-param name="skladniki" select="@Składniki"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="BCD_column">
			<xsl:with-param name="skladniki" select="@Składniki"/>
			<xsl:with-param name="column" select="'Dwa-miesiące'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="BCD_column">
			<xsl:with-param name="skladniki" select="@Składniki"/>
			<xsl:with-param name="column" select="'Trzy-miesiące'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="BCD_column">
		<xsl:param name="format"/>
		<xsl:param name="column"/> <xsl:param name="skladniki"/>
		<xsl:param name="item" select="./*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>

		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:call-template name="_BCD_total">
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:value-of select="format-number($contents, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_BCD_total">
		<xsl:param name="skladniki"/> <xsl:param name="column"/>
		<xsl:param name="items" select="../*[contains($skladniki,concat(@Pozycja,' '))]/*/*[name(.) = $column]"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="$items">
				<xsl:call-template name="_BCD_add_tree">
					<xsl:with-param name="skladniki" select="../@Składniki"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_BCD_add_tree">
		<xsl:param name="column"/>
		<xsl:param name="contents" select="../*[name(.) = $column]"/>
		<xsl:param name="skladniki"/>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:for-each select="../*[contains(concat($skladniki, ' '),concat(@Pozycja,' '))]/*[name(.) = $column]">
					<xsl:call-template name="_BCD_add_tree">
						<xsl:with-param name="skladniki" select="../@Składniki"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="BCD_header">
		<xsl:param name="remark"/> <xsl:param name="grouphdr"/> <xsl:param name="descrwidth"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(100-number($descrwidth)-3)"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 3))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="2">Lp.</th>
				<th rowspan="2"><xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr"/>
					<xsl:if test="$remark">
						<sup><xsl:value-of select="$remark"/></sup>
					</xsl:if>
				</th>
			</tr>
			<tr>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy miesiąc kwartału</th>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>dwa miesiące kwartału</th>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>trzy miesiące kwartału</th>
			</tr>
		<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Część_BCD">
		<xsl:param name="grouphdr"/><xsl:param name="remark"/><xsl:param name="row_name"/>
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<xsl:call-template name="BCD_header">
				<xsl:with-param name="remark" select="$remark"/>
				<xsl:with-param name="grouphdr" select="$grouphdr"/>
				<xsl:with-param name="descrwidth" select="63"/>
			</xsl:call-template>
			<tbody>
				<xsl:for-each select="*[name(.)=$row_name]">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="BCD_row"/>
					</tr>
				</xsl:for-each>
				<xsl:if test="$row_name='Finansowanie-lub-koszty'">
					<xsl:for-each select="*[name(.)='Osób-obsługi-lub-etatów']">
						<tr>
							<xsl:call-template name="Row-description"/>
							<xsl:call-template name="Realizacja-mies"/>
						</tr>
					</xsl:for-each>
				</xsl:if>
			</tbody>
		</table>

		_________
		<table style="padding-top: 6px;" border="0" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<xsl:choose>
				<xsl:when test="$remark">
					<xsl:if test="$row_name='Należności-narastająco'">
						<tr>	
							<td class="stars">1)</td>
							<td class="remark">
								Zasada narastania nie dotyczy wiersza 1.
							</td>
						</tr>
	
					</xsl:if>
					<xsl:if test="$row_name='Finansowanie-lub-koszty'">
						<tr>	
							<td class="stars">1)</td>
							<td class="remark">
								Zasada narastania nie dotyczy wiersza 1, 8, 8.1, 8.2 i 8.3.
							</td>
						</tr>
						<tr>
							<td class="stars">2)</td>
							<td class="remark">
								Świadczenia rodzinne, zaliczka alimentacyjna oraz składki na ubezpieczenia emerytalne i rentowe z ubezpieczenia społecznego.
							</td>
						</tr>
						<!--tr>
							<td class="stars">3)</td>
							<td class="remark">
								Dotyczy ustawy z dnia 7 września 2007 r. o pomocy osobom uprawnionym do alimentów (Dz. U. Nr 192, poz. 1378).
							</td>
						</tr-->
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td class="stars">1)</td>
						<td class="remark">
							Dotyczy świadczeń wypłaconych na podstawie ustawy z dnia 22 kwietnia 2005 r. o postępowaniu wobec dłużników alimentacyjnych oraz zaliczce alimentacyjnej (Dz. U. Nr 86, poz. 732, z późn. zm.).
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_B">
		<xsl:call-template name="Część_BCD">
			<xsl:with-param name="grouphdr" select="'Kwoty narastająco od początku roku (w zł)'"/>
			<xsl:with-param name="row_name" select="'Należności-narastająco'"/>
			<xsl:with-param name="remark" select="'1)'"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_C">
		<xsl:call-template name="Część_BCD">
			<xsl:with-param name="grouphdr" select="'Kwoty narastająco od początku roku (w zł)'"/>
			<xsl:with-param name="row_name" select="'Odzyskano-narastająco'"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_D">
		<xsl:call-template name="Część_BCD">
			<xsl:with-param name="grouphdr" select="'Kwoty narastająco od początku roku w zł'"/>
			<xsl:with-param name="row_name" select="'Finansowanie-lub-koszty'"/>
			<xsl:with-param name="remark" select="'1)'"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Realizacja-mies">
		<xsl:param name="format">
			<xsl:choose>
				<xsl:when test="Miesięcznie-kwota">
					<xsl:value-of select="$kwota"/>
				</xsl:when>
				<xsl:when test="Miesięcznie-etatów">
					<xsl:value-of select="$obsada"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$liczba"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<xsl:call-template name="E_column">
			<xsl:with-param name="skladniki" select="@Składniki"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="E_column">
			<xsl:with-param name="skladniki" select="@Składniki"/>
			<xsl:with-param name="column" select="'Drugi-miesiąc'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="E_column">
			<xsl:with-param name="skladniki" select="@Składniki"/>
			<xsl:with-param name="column" select="'Trzeci-miesiąc'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="E_column">
		<xsl:param name="format"/>
		<xsl:param name="column"/> <xsl:param name="skladniki"/>
		<xsl:param name="item" select="./*/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>

		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:call-template name="_E_total">
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:value-of select="format-number($contents, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_E_total">
		<xsl:param name="skladniki"/> <xsl:param name="column"/>
		<xsl:param name="items" select="../*[contains($skladniki,concat(@Pozycja,' '))]/*/*[name(.) = $column]"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="$items">
				<xsl:call-template name="_E_add_tree">
					<xsl:with-param name="skladniki" select="../@Składniki"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_E_add_tree">
		<xsl:param name="column"/>
		<xsl:param name="contents" select="../*[name(.) = $column]"/>
		<xsl:param name="skladniki"/>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:for-each select="../*[contains(concat($skladniki, ' '),concat(@Pozycja,' '))]/*[name(.) = $column]">
					<xsl:call-template name="_E_add_tree">
						<xsl:with-param name="skladniki" select="../@Składniki"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="EF_header">
		<xsl:param name="remark"/> <xsl:param name="grouphdr"/> <xsl:param name="descrwidth"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(100-number($descrwidth)-3)"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 3))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="2">Lp.</th>
				<th rowspan="2"><xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr"/>
					<xsl:if test="$remark">
						<sup><xsl:value-of select="$remark"/></sup>
					</xsl:if>
				</th>
			</tr>
			<tr>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy miesiąc kwartału</th>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>drugi miesiąc kwartału</th>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>trzeci miesiąc kwartału</th>
			</tr>
		<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="F_column">
		<xsl:param name="column"/>

		<td class="contents">
			<xsl:value-of select="format-number(*[name() = $column], $kwota)"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_E">
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<xsl:call-template name="EF_header">
				<xsl:with-param name="grouphdr" select="'Wykonanie miesięczne'"/>
				<xsl:with-param name="descrwidth" select="60"/>
			</xsl:call-template>
			<tbody>
				<xsl:for-each select="Wykonanie-miesięczne">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Realizacja-mies"/>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<!--
		_________
		<table style="padding-top: 6px;" border="0" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<tr>
				<td class="stars">1)</td>
				<td class="remark">
					Dotyczy ustawy z dnia 7 września 2007 r. o pomocy osobom uprawnionym do alimentów (Dz. U. Nr 192, poz. 1378).
				</td>
			</tr>
		</table-->
		<br/><br/><br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
		
	
	<xsl:template match="Część_F">
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<xsl:call-template name="EF_header">
				<xsl:with-param name="grouphdr" select="'Wykonanie miesięczne'"/>
				<xsl:with-param name="descrwidth" select="60"/>
			</xsl:call-template>
			<tbody>
				<xsl:for-each select="Miesięcznie-liczba">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="I_column">
							<xsl:with-param name="skladniki" select="@Składniki"/>
							<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
						</xsl:call-template>
						<xsl:call-template name="I_column">
							<xsl:with-param name="skladniki" select="@Składniki"/>
							<xsl:with-param name="column" select="'Drugi-miesiąc'"/>
						</xsl:call-template>
						<xsl:call-template name="I_column">
							<xsl:with-param name="skladniki" select="@Składniki"/>
							<xsl:with-param name="column" select="'Trzeci-miesiąc'"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<!--
		_________
		<table style="padding-top: 6px;" border="0" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<tr>
				<td class="stars">1)</td>
				<td class="remark">
					Dotyczy ustawy z dnia 7 września 2007 r. o pomocy osobom uprawnionym do alimentów (Dz. U. Nr 192, poz. 1378).
				</td>
			</tr>
			<tr>
				<td class="stars">2)</td>
				<td class="remark">
					Wypełnia organ właściwy dłużnika.
				</td>
			</tr>
		</table-->
		<br/><br/><br/>
	</xsl:template> 
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="I_column">
		<xsl:param name="column"/> <xsl:param name="skladniki"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>

		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:call-template name="_I_total">
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$liczba"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:value-of select="format-number($contents, $liczba)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_I_total">
		<xsl:param name="skladniki"/> <xsl:param name="column"/>
		<xsl:param name="items" select="../*[contains($skladniki,concat(@Pozycja,' '))]/*[name(.) = $column]"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="$items">
				<xsl:call-template name="_I_add_tree">
					<xsl:with-param name="skladniki" select="../@Składniki"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_I_add_tree">
		<xsl:param name="column"/>
		<xsl:param name="contents" select="../*[name(.) = $column]"/>
		<xsl:param name="skladniki"/>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:for-each select="../*[contains(concat($skladniki, ' '),concat(@Pozycja,' '))]/*[name(.) = $column]">
					<xsl:call-template name="_I_add_tree">
						<xsl:with-param name="skladniki" select="../@Składniki"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="G_header">
		<xsl:param name="descrwidth" select="36"/>
		<xsl:param name="double">
			<xsl:value-of select="string(round((100-number($descrwidth)-3)))"/>
		</xsl:param>
		<xsl:param name="triple">
			<xsl:value-of select="string(round(number($double) div 2))"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 3))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="2">Lp.</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>	Wyszczególnienie
				</th>
				<!--th colspan="6">
					<xsl:attribute name="width"><xsl:value-of select="concat($double,'%')"/></xsl:attribute>
					Wykonanie miesięczne
				</th-->
			<!--/tr>
			<tr-->
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					Liczba podjętych działań<br/>(wykonanie miesięczne)
				</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					Liczba podjętych działań, które w kwartale doprowadziły do wzrostu ściągalności należności wymienionych w art. 28 ust.1 pkt 1-4 ustawy<!--sup>2)</sup-->
				</th>
			</tr>
			<tr>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy<br/>miesiąc<br/>kwartału</th>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>drugi<br/>miesiąc<br/>kwartału</th>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>trzeci<br/>miesiąc<br/>kwartału</th>
				<!--th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Pierwszy<br/>miesiąc<br/>kwartału</th>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Drugi<br/>miesiąc<br/>kwartału</th>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Trzeci<br/>miesiąc<br/>kwartału</th-->
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
				<td class="tab_col_no">6</td>
				<!--td class="tab_col_no">7</td>
				<td class="tab_col_no">8</td-->
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_G_column">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<td class="contents">
			<xsl:choose>
				<xsl:when test="string($item/@xsi:nil) = 'true'">
					<center>X</center>
				</xsl:when>
				<xsl:when test="string(number($contents)) = 'NaN'">
					<div style="color: red; text-align: center;">???</div>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="format-number($contents, $format)"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_G_contents">
		<xsl:param name="subtree"/> <xsl:param name="format"/>
		<xsl:call-template name="_G_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_G_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Drugi-miesiąc'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_G_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Trzeci-miesiąc'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Podjęte-i-skuteczne">
		<xsl:param name="skladniki"/>

		<xsl:call-template name="_G_contents">
			<xsl:with-param name="subtree" select="'Podjęte'"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>

		<xsl:choose>
			<xsl:when test="string(Skuteczne/@xsi:nil) = 'true'">
				<td class="contents"><center>X</center></td>
				<!--td class="contents"><center>X</center></td>
				<td class="contents"><center>X</center></td-->
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:value-of select="format-number(Skuteczne, $liczba)"/>
				</td>
				<!--xsl:call-template name="_G_contents">
					<xsl:with-param name="subtree" select="'Skuteczne'"/>
					<xsl:with-param name="format" select="$liczba"/>
				</xsl:call-template-->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_G">
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<xsl:call-template name="G_header"/>
			<tbody>
				<xsl:for-each select="Działania">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Podjęte-i-skuteczne">
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<!--
		_________
		<table style="padding-top: 6px;" width="600" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" valign="top">1)</td>
				<td class="remark">
					Wiersze 10 i 11 wypełnia również organ właściwy wierzyciela.
				</td>
			</tr>
			<tr>
				<td class="stars" valign="top">2)</td>
				<td class="remark">
					Dotyczy ustawy z dnia 7 września 2007 r. o pomocy osobom uprawnionym do alimentów (Dz. U. Nr 192, poz. 1378).
				</td>
			</tr>
		</table-->
		<br/><br/><br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
