<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
	<xsl:variable name="obsada" select="'###&#160;###&#160;###&#160;##0,00'"/>
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'944'"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
                    .reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
											font-weight: bold; text-align: right;
											width: <xsl:value-of select="$width"/>px;
										}
					.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
											font-weight: bold; text-align: center;
										}
					.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
											font-weight: bold;
										}
					.heading_1  	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
											font-weight: bold; text-align: justify;
											width: <xsl:value-of select="$width"/>px;
										}
					.data_table	{border: 1px solid black; border-collapse: collapse;
											color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
											font-weight: normal;
										}
					.bottom_table {max-width: 900px; border-width: 0px;}
					th          		{padding: 5px; font-weight: bold; border: 1px solid black;}
					caption     	{color: #000000; font-family: Tahoma, Verdana;
											text-align: left; font-size: 14px; font-weight: bold;
											margin-bottom: 0.4em;
										}
					.tab_col_no	{text-align: center; font-size: 8px;
											border: 1px solid black; padding: 5px;
										}
					.tab_row_no	{padding-left: 5px; padding-top: 5px; padding-bottom: 5px;
											text-align: left; border: 1px solid black;
										}
					.contents		{padding: 5px; text-align: right; border: 1px solid black;}
					.totals     		{padding: 5px; text-align: right; border: 1px solid black;}
					.blad				{background-color: red; font-weight: bold;}
					.row_descr	{padding: 5px; text-align: left; border: 1px solid black;}
					.remark			{padding-left: 8px; text-align: justify; vertical-align: baseline;
											color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
											padding-top: 4px; font-weight: normal;
										}
					.stars      		{padding-left: 2px; text-align: left; vertical-align: super;
											color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
											padding-top: 2px; font-weight: normal;
										}
					.stopka			{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
											font-weight: normal; width: 500px;
										}
				</style>
			</head>
			<body>
				<xsl:apply-templates select="Świadczenia-alimentacyjne-1"/>
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Świadczenia-alimentacyjne-1">
		<xsl:apply-templates select="Metryczka"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Część_A.1"/>
		<xsl:apply-templates select="Część_A.2"/>
		<xsl:apply-templates select="Część_B"/>
		<xsl:apply-templates select="Część_C.1"/>
		<xsl:apply-templates select="Część_C.2"/>
		<xsl:apply-templates select="Część_D.1"/>
		<xsl:apply-templates select="Część_D.2"/>
		<xsl:apply-templates select="Część_E"/>
		<xsl:apply-templates select="Część_F"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/>
				<br/>
				<br/>
			</div>
		</xsl:if>
		<xsl:for-each select="../Nagłówek/Dane-jednostki-org">
			<table cellspacing="0" cellpadding="0">
				<tr>
					<td class="stamp" colspan="2">
						<xsl:value-of select="Pełna-nazwa"/>
					</td>
				</tr>
				<xsl:for-each select="Adres-pocztowy">
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Ulica-i-numer"/>
						</td>
					</tr>
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Kod-i-poczta"/>
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="stamp" style="font-size: 12px; text-align: left">
						<xsl:for-each select="Telefon">
							Tel. <xsl:apply-templates/>&#160;
 						</xsl:for-each>
					</td>
					<td class="stamp" style="font-size: 12px; text-align: right">
						<xsl:for-each select="Faks">
							&#160;Fax <xsl:apply-templates/>
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</xsl:for-each>
		<br/>
		<br/>
		<div class="auth_name">
			<xsl:for-each select="../Nagłówek">
				<xsl:for-each select="Gmina">
					Gmina <xsl:apply-templates/>
				</xsl:for-each>
			</xsl:for-each>
		</div>
		<br/>
		<br/>
		<div class="heading_1">
			KWARTALNE
			<xsl:if test="../Nagłówek/Wojewoda"> ZBIORCZE</xsl:if>
			SPRAWOZDANIE	RZECZOWO-FINANSOWE Z REALIZACJI ZADAŃ PRZEWIDZIANYCH W USTAWIE <nobr>O POMOCY</nobr> OSOBOM UPRAWNIONYM DO ALIMENTÓW<sup>1)</sup>
			<xsl:for-each select="Za-okres">
				<xsl:for-each select="Miesiąc">
					ZA <xsl:apply-templates/>
				</xsl:for-each>
				<xsl:for-each select="Kwartał">
					ZA <xsl:apply-templates/> KWARTAŁ
				</xsl:for-each>
				<xsl:value-of select="concat(' ', Rok, ' R.')"/>
			</xsl:for-each>
		</div>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table class="stopka">
			<caption class="stopka">Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
			<tr>
				<td>imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
			</tr>
			<tr>
				<td>telefon służbowy:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td>e-mail służbowy:</td>
				<td>
					<xsl:value-of select="$kto/E-mail"/>
				</td>
			</tr>
			<tr>
				<td>Data sporządzenia sprawozdania:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="suma">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="contents"/>
		<xsl:param name="format"/>
		<xsl:param name="skladniki"/>
		<xsl:variable name="wynik">
			<xsl:choose>
				<xsl:when test="$subtree">
					<xsl:value-of select="sum(../*[contains($skladniki,concat(name(.),' '))]/*[name(.) = $subtree]/descendant-or-self::*[name(.) = $column])"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="sum(../*[contains($skladniki,concat(name(.),' '))]/descendant-or-self::*[name(.) = $column])"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string(number($wynik)) = 'NaN'">
				<td class="totals" style="background-color: red">
					<center>???</center>
				</td>
			</xsl:when>
			<xsl:when test="string(number($contents)) != 'NaN' and $contents != ''">
				<xsl:choose>
					<xsl:when test="format-number($contents, $format) != format-number($wynik, $format)">
						<td class="contents" style="background-color: red">
							<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
							<br/>
							<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($wynik, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="$wynik"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Column">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="skladniki"/>
		<xsl:param name="format"/>
		<xsl:variable name="item" select="descendant-or-self::*[name(.) = $column]"/>
		<xsl:variable name="subtree_item" select="*[name(.) = $subtree]/descendant-or-self::*[name(.) = $column]"/>
		<xsl:variable name="contents">
			<xsl:choose>
				<xsl:when test="$subtree">
					<xsl:value-of select="$subtree_item"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$item"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="czyNil">
			<xsl:choose>
				<xsl:when test="$subtree">
					<xsl:value-of select="$subtree_item/@xsi:nil"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$item/@xsi:nil"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string($czyNil) = 'true'">
				<xsl:variable name="cssName">
					<xsl:choose>
						<xsl:when test="$skladniki">totals</xsl:when>
						<xsl:otherwise>contents</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<td>
					<xsl:attribute name="class"><xsl:value-of select="$cssName"/></xsl:attribute>
					<center>X</center>
				</td>
			</xsl:when>
			<xsl:when test="$skladniki">
				<xsl:call-template name="suma">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string(number($contents)) = 'NaN'">
							<div style="color: red; text-align: center;">???</div>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Table-caption">
		<caption>
			<xsl:value-of select="concat(substring-after(name(.), '_'), '. ')"/>
			<xsl:call-template name="Tables-description">
				<xsl:with-param name="table_name" select="name()"/>
			</xsl:call-template>
		</caption>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Tables-description">
		<xsl:param name="table_name"/>
		<xsl:choose>
			<xsl:when test="$table_name = 'Część_A.1'">Wydatki na świadczenie z funduszu alimentacyjnego finansowane z dotacji celowej z budżetu państwa oraz liczba wypłaconych świadczeń, z wyłączeniem świadczeń ustalonych na podstawie art. 9 ust. 2a ustawy<sup>1)</sup></xsl:when>
			<xsl:when test="$table_name = 'Część_A.2'">Wydatki na świadczenie z funduszu alimentacyjnego finansowane z dotacji celowej z budżetu państwa oraz liczba wypłaconych świadczeń, w zakresie świadczeń ustalonych wyłącznie na podstawie art. 9 ust. 2a ustawy<sup>1)</sup></xsl:when>
			<xsl:when test="$table_name = 'Część_B'">Informacje na temat należności z tytułu wypłaconych świadczeń z funduszu alimentacyjnego</xsl:when>
			<xsl:when test="$table_name = 'Część_C.1'">Informacje na temat należności z tytułu nienależnie pobranych świadczeń z funduszu alimentacyjnego</xsl:when>
			<xsl:when test="$table_name = 'Część_C.2'">Informacje o odzyskanych nienależnie pobranych świadczeniach z funduszu alimentacyjnego</xsl:when>
			<xsl:when test="$table_name = 'Część_D.1'">Informacje uzupełniające o realizacji świadczenia z funduszu alimentacyjnego</xsl:when>
			<xsl:when test="$table_name = 'Część_D.2'">Informacje uzupełniające o usługach wymiany informacji pomiędzy systemem dziedzinowym (SD) podobszaru funduszu alimentacyjnego a Centralnym Systemem Informatycznym Zabezpieczenia Społecznego (CSIZS)</xsl:when>
			<xsl:when test="$table_name = 'Część_E'">Informacje na temat rodzin i osób korzystających ze świadczenia z funduszu alimentacyjnego</xsl:when>
			<xsl:when test="$table_name = 'Część_F'">Informacje na temat liczby dłużników alimentacyjnych oraz liczby podejmowanych działań wobec dłużników alimentacyjnych</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Row-description">
		<td class="tab_row_no">
			<xsl:value-of select="concat(substring-after(name(), '_'), '.')"/>
		</td>
		<td class="row_descr">
			<xsl:call-template name="Rows-description">
				<xsl:with-param name="row_name" select="name()"/>
			</xsl:call-template>
		</td>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Rows-description">
		<xsl:param name="row_name"/>
		<xsl:choose>
			<xsl:when test="$row_name = 'A.1_1'">Świadczenie z funduszu alimentacyjnego, z tego na osobę uprawnioną w wieku:</xsl:when>
			<xsl:when test="$row_name = 'A.1_1.1'">- 0-17 lat</xsl:when>
			<xsl:when test="$row_name = 'A.1_1.2'">- 18-24 lat</xsl:when>
			<xsl:when test="$row_name = 'A.1_1.3'">- 25 lat i więcej</xsl:when>
			<xsl:when test="$row_name = 'A.2_1'">Świadczenie z funduszu alimentacyjnego, z tego na osobę uprawnioną w wieku:</xsl:when>
			<xsl:when test="$row_name = 'A.2_1.1'">- 0-17 lat</xsl:when>
			<xsl:when test="$row_name = 'A.2_1.2'">- 18-24 lat</xsl:when>
			<xsl:when test="$row_name = 'A.2_1.3'">- 25 lat i więcej</xsl:when>
			<xsl:when test="$row_name = 'B_1'">Stan należności z tytułu wypłaconych świadczeń z funduszu alimentacyjnego na ostatni dzień miesiąca</xsl:when>
			<xsl:when test="$row_name = 'B_2'">Kwoty zwrócone przez dłużników alimentacyjnych z tytułu wypłaconych świadczeń z funduszu alimentacyjnego, z tego:</xsl:when>
			<xsl:when test="$row_name = 'B_2.1'">- przekazane na dochody  budżetu państwa, w tym:</xsl:when>
			<xsl:when test="$row_name = 'B_2.1.1'">- odsetki ustawowe za opóźnienie</xsl:when>
			<xsl:when test="$row_name = 'B_2.2'">- przekazane na dochody własne organu właściwego wierzyciela</xsl:when>
			<xsl:when test="$row_name = 'B_3'">Umorzone należności od dłużników  alimentacyjnych, z tego należności, o których mowa w:</xsl:when>
			<xsl:when test="$row_name = 'B_3.1'">- art. 28 ust. 1 pkt 1 ustawy<sup>2)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'B_3.2'">- art. 28 ust. 1 pkt 2 ustawy<sup>2)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'B_3.3'">- art. 28 ust. 1 pkt 4 ustawy<sup>2)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'B_4'">Wygaszone należności z tytuł świadczeń wypłaconych w zastępstwie alimentów, z tego:</xsl:when>
			<xsl:when test="$row_name = 'B_4.1'">- należności, które wygasły zgodnie z art. 23 ust. 9 ustawy<sup>2)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'B_4.2'">- należności, które wygasły zgodnie z art. 28 ust. 3 ustawy<sup>2)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'E_1'">Liczba rodzin, w których jest pobierane świadczenie z funduszu alimentacyjnego, z tego o dochodzie rodziny w przeliczeniu na osobę:</xsl:when>
			<xsl:when test="$row_name = 'E_1.1'">- bez dochodu</xsl:when>
			<xsl:when test="$row_name = 'E_1.2'">- od 0,01 do 100 zł</xsl:when>
			<xsl:when test="$row_name = 'E_1.3'">- od 100,01 do 252 zł</xsl:when>
			<xsl:when test="$row_name = 'E_1.4'">- od 252,01 do 362,50 zł</xsl:when>
			<xsl:when test="$row_name = 'E_1.5'">- od 362,51 do 504 zł</xsl:when>
			<xsl:when test="$row_name = 'E_1.6'">- od 504,01 do 583 zł</xsl:when>
			<xsl:when test="$row_name = 'E_1.7'">- od 583,01 do 674 zł</xsl:when>
			<xsl:when test="$row_name = 'E_1.8'">- od 674,01 do 725 zł</xsl:when>
			<xsl:when test="$row_name = 'E_1.9'">- od 725,01 do 800 zł</xsl:when>
			<xsl:when test="$row_name = 'E_1.10'">- od 800,01 do 900 zł</xsl:when>
			<xsl:when test="$row_name = 'E_1.11'">- pow. 900 zł</xsl:when>
			<xsl:when test="$row_name = 'E_2'">Liczba rodzin, w których jest pobierane świadczenie z funduszu alimentacyjnego, w tym:</xsl:when>
			<xsl:when test="$row_name = 'E_2.1'">- z jedną osobą uprawnioną</xsl:when>
			<xsl:when test="$row_name = 'E_2.2'">- z dwiema osobami uprawnionymi</xsl:when>
			<xsl:when test="$row_name = 'E_2.3'">- z trzema osobami uprawnionymi</xsl:when>
			<xsl:when test="$row_name = 'E_2.4'">- z czterema i więcej osobami uprawnionymi</xsl:when>
			<xsl:when test="$row_name = 'E_3'">Liczba osób uprawnionych do świadczenia z funduszu alimentacyjnego wychowywanych przez osobę pozostającą w związku małżeńskim z osobą zobowiązaną do alimentacji wobec osoby uprawnionej</xsl:when>
			<xsl:when test="$row_name = 'E_4'">Liczba osób uprawnionych do świadczenia z funduszu alimentacyjnego wychowywanych przez osobę pozostającą w związku małżeńskim z osobą niezobowiązaną do alimentacji wobec osoby uprawnionej</xsl:when>
			<xsl:when test="$row_name = 'E_5'">Liczba osób uprawnionych do świadczenia z funduszu alimentacyjnego wychowywanych przez rodzica niepozostającego w związku małżeńskim</xsl:when>
			<xsl:when test="$row_name = 'E_6'">Liczba osób uprawnionych do świadczenia z funduszu alimentacyjnego wychowywanych przez rodziców niepozostających w związku małżeńskim</xsl:when>
			<xsl:when test="$row_name = 'E_7'">Liczba osób uprawnionych do świadczenia z funduszu alimentacyjnego pobierających świadczenie z funduszu alimentacyjnego na siebie</xsl:when>
			<xsl:when test="$row_name = 'E_8'">Liczba osób uprawnionych otrzymujących świadczenie z funduszu alimentacyjnego, z tego w wysokości:</xsl:when>
			<xsl:when test="$row_name = 'E_8.1'">- do 100 zł</xsl:when>
			<xsl:when test="$row_name = 'E_8.2'">- od 100,01 do 200 zł</xsl:when>
			<xsl:when test="$row_name = 'E_8.3'">- od 200,01 do 300 zł</xsl:when>
			<xsl:when test="$row_name = 'E_8.4'">- od 300,01 do 400 zł</xsl:when>
			<xsl:when test="$row_name = 'E_8.5'">- od 400,01 do 500 zł</xsl:when>
			<xsl:when test="$row_name = 'E_9'">Liczba osób uprawnionych do świadczenia z funduszu alimentacyjnego, w stosunku do których zostało zasądzone świadczenie alimentacyjne, z tego w wysokości:</xsl:when>
			<xsl:when test="$row_name = 'E_9.1'">- do 100 zł</xsl:when>
			<xsl:when test="$row_name = 'E_9.2'">- od 100,01 do 200 zł</xsl:when>
			<xsl:when test="$row_name = 'E_9.3'">- od 200,01 do 300 zł</xsl:when>
			<xsl:when test="$row_name = 'E_9.4'">- od 300,01 do 400 zł</xsl:when>
			<xsl:when test="$row_name = 'E_9.5'">- od 400,01 do 500 zł</xsl:when>
			<xsl:when test="$row_name = 'E_9.6'">- od 500,01 do 700 zł</xsl:when>
			<xsl:when test="$row_name = 'E_9.7'">- od 700,01 do 900 zł</xsl:when>
			<xsl:when test="$row_name = 'E_9.8'">- pow. 900 zł</xsl:when>
			<xsl:when test="$row_name = 'E_10'">Liczba świadczeń z funduszu alimentacyjnego pobieranych w związku z zamieszkiwaniem dłużnika alimentacyjnego poza granicami Rzeczypospolitej Polskiej, w tym: </xsl:when>
			<xsl:when test="$row_name = 'E_10.1'">- w związku z niemożnością wszczęcia lub prowadzenia egzekucji alimentów</xsl:when>
			<xsl:when test="$row_name = 'C.2_1'">Kwota odzyskanych nienależnie pobranych świadczeń z funduszu alimentacyjnego, w tym:</xsl:when>
			<xsl:when test="$row_name = 'C.2_1.1'">- podlegająca zwrotowi do budżetu państwa</xsl:when>
			<xsl:when test="$row_name = 'D.1_1'">Liczba wniosków dotyczących świadczenia z funduszu alimentacyjnego złożonych do organu właściwego wierzyciela, w tym:</xsl:when>
			<xsl:when test="$row_name = 'D.1_1.1'">- o przyznanie świadczenia, w tym:</xsl:when>
			<xsl:when test="$row_name = 'D.1_1.1.1'">- złożonych za pomocą systemu teleinformatycznego utworzonego przez ministra właściwego do spraw rodziny</xsl:when>
			<xsl:when test="$row_name = 'D.1_2'">Liczba decyzji wydanych przez organ właściwy wierzyciela w sprawach dotyczących świadczenia z funduszu alimentacyjnego, w tym:</xsl:when>
			<xsl:when test="$row_name = 'D.1_2.1'">- ustalających prawo do świadczenia</xsl:when>
			<xsl:when test="$row_name = 'D.1_2.2'">- stwierdzających nienależnie pobrane świadczenia</xsl:when>
			<xsl:when test="$row_name = 'D.1_2.3'">- umarzających należności z tytułu nienależnie pobranych świadczeń</xsl:when>
			<xsl:when test="$row_name = 'D.1_3'">Liczba decyzji umarzających należności od dłużników alimentacyjnych, w tym na podstawie:</xsl:when>
			<xsl:when test="$row_name = 'D.1_3.1'">- art. 30 ust. 1 pkt 1 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'D.1_3.2'">- art. 30 ust. 1 pkt 2 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'D.1_3.3'">- art. 30 ust. 1 pkt 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'D.1_3.4'">- art. 30 ust. 2 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'D.1_4'">Liczba spraw, w których wygaszono należności, z tego:</xsl:when>
			<xsl:when test="$row_name = 'D.1_4.1'">- z tytułu nienależnie pobranych świadczeń z funduszu alimentacyjnego, na podstawie art. 23 ust. 9 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'D.1_4.2'">- od dłużników alimentacyjnych, na podstawie art. 28 ust. 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'F_1'">Dłużnicy alimentacyjni w gminie, z tego, w stosunku do których:</xsl:when>
			<xsl:when test="$row_name = 'F_1.1'">- podjęto działania wobec dłużników alimentacyjnych</xsl:when>
			<xsl:when test="$row_name = 'F_1.2'">- nie podjęto działań wobec dłużników alimentacyjnych, w tym:</xsl:when>
			<xsl:when test="$row_name = 'F_1.2.1'">- w związku z okolicznościami, o których mowa w art. 5a ust. 2 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'F_2'">Otrzymane od organu właściwego wierzyciela  wnioski o podjęcie działań wobec dłużnika alimentacyjnego (art. 3 ust. 5 ustawy<sup>1)</sup>)</xsl:when>
			<xsl:when test="$row_name = 'F_3'">Przeprowadzenie przez organ właściwy dłużnika wywiadu alimentacyjnego oraz odebranie oświadczenia majątkowego, w tym:</xsl:when>
			<xsl:when test="$row_name = 'F_3.1'">- na podstawie art. 8d ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'F_4'">Przekazanie komornikowi sądowemu informacji mających wpływ na egzekucję zasądzonych świadczeń alimentacyjnych, w tym pochodzących z wywiadu alimentacyjnego oraz oświadczenia majątkowego</xsl:when>
			<xsl:when test="$row_name = 'F_5'">Przekazanie komornikowi sądowemu informacji mających wpływ na egzekucję zasądzonych świadczeń alimentacyjnych, pochodzących z rodzinnego wywiadu środowiskowego</xsl:when>
			<xsl:when test="$row_name = 'F_6'">Zobowiązanie dłużnika alimentacyjnego do zarejestrowania się w urzędzie pracy jako bezrobotny albo poszukujący pracy</xsl:when>
			<xsl:when test="$row_name = 'F_7'">Poinformowanie powiatowego urzędu pracy o potrzebie  aktywizacji zawodowej dłużnika alimentacyjnego</xsl:when>
			<xsl:when test="$row_name = 'F_8'">Informacje od starosty o odmowie dokonania przez dłużnika alimentacyjnego czynności, o których mowa art. 5 ust. 3 pkt 2 i 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'F_9'">Wszczęcie postępowania o uznanie dłużnika alimentacyjnego za uchylającego się od zobowiązań alimentacyjnych</xsl:when>
			<xsl:when test="$row_name = 'F_10'">Wydanie decyzji o uznaniu dłużnika alimentacyjnego za uchylającego się od zobowiązań alimentacyjnych</xsl:when>
			<xsl:when test="$row_name = 'F_11'">Wydanie decyzji o umorzeniu postępowania dotyczącego uznania dłużnika alimentacyjnego  za uchylającego się od zobowiązań alimentacyjnych, w tym:</xsl:when>
			<xsl:when test="$row_name = 'F_11.1'">- na podstawie art. 5 ust. 3a ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'F_12'">Złożenie wniosku o ściganie za przestępstwa określone w art. 209 Kodeksu karnego</xsl:when>
			<xsl:when test="$row_name = 'F_13'">Skierowanie do starosty wniosku o zatrzymanie prawa jazdy dłużnika alimentacyjnego</xsl:when>
			<xsl:when test="$row_name = 'F_14'">Skierowanie do starosty wniosku o uchylenie decyzji o zatrzymaniu prawa jazdy dłużnika alimentacyjnego</xsl:when>
			<xsl:when test="$row_name = 'F_15'">Wystąpienie z powództwem o ustalenie alimentów od innych osób</xsl:when>
			<xsl:when test="$row_name = 'F_16'">Przekazanie do sądu informacji o bezczynności lub opieszałości komornika sądowego (art. 3 ust. 8 ustawy<sup>1)</sup>)</xsl:when>
			<xsl:when test="$row_name = 'F_17'">Przekazanie informacji gospodarczej do biura informacji gospodarczej o zobowiązaniu lub zobowiązaniach dłużnika alimentacyjnego wynikających z tytułów, o których mowa w art. 28 ust. 1 pkt 1 i 2 ustawy<sup>1)</sup>, w przypadku powstania zaległości za okres dłuższy niż 6 miesięcy</xsl:when>
			<xsl:when test="$row_name = 'C.1_1'">Stan należności z tytułu nienależnie pobranych świadczeń z funduszu alimentacyjnego na ostatni dzień miesiąca</xsl:when>
			<xsl:when test="$row_name = 'C.1_2'">Kwota umorzonych nienależnie pobranych świadczeń z funduszu alimentacyjnego</xsl:when>
			<xsl:when test="$row_name = 'C.1_3'">Kwota nienależnie pobranych świadczeń z funduszu alimentacyjnego, w stosunku do których w danym miesiącu podjęto decyzję o rozłożeniu na raty</xsl:when>
			<xsl:when test="$row_name = 'C.1_4'">Kwota nienależnie pobranych świadczeń z funduszu alimentacyjnego, potrącona  w danym miesiącu z bieżąco wypłacanych świadczeń</xsl:when>
			<xsl:when test="$row_name = 'D.2_1'">Wygenerowane usługi integracji SD z zasobami zbioru PESEL, w tym:</xsl:when>
			<xsl:when test="$row_name = 'D.2_1.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'D.2_1.2'">- niepowodzenia</xsl:when>
			<xsl:when test="$row_name = 'D.2_2'">Wygenerowane usługi integracji SD z zasobami Aplikacji Centralnej Rynku Pracy, w tym:</xsl:when>
			<xsl:when test="$row_name = 'D.2_2.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'D.2_2.2'">- niepowodzenia</xsl:when>
			<xsl:when test="$row_name = 'D.2_3'">Wygenerowane usługi integracji SD z zasobami Centralnej Ewidencji i Informacji Działalności Gospodarczej (CEIDG), w tym:</xsl:when>
			<xsl:when test="$row_name = 'D.2_3.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'D.2_3.2'">- niepowodzenia</xsl:when>
			<xsl:when test="$row_name = 'D.2_4'">Wygenerowane usługi integracji SD z zasobami Elektronicznego Krajowego Systemu Monitoringu Orzekania o Niepełnosprawności (EKSMOoN), w tym:</xsl:when>
			<xsl:when test="$row_name = 'D.2_4.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'D.2_4.2'">- niepowodzenia</xsl:when>
			<xsl:when test="$row_name = 'D.2_5'">Wygenerowane usługi integracji SD z zasobami Ministerstwa Finansów,  w tym:</xsl:when>
			<xsl:when test="$row_name = 'D.2_5.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'D.2_5.2'">- niepowodzenia</xsl:when>
			<xsl:when test="$row_name = 'D.2_6'">Wygenerowane usługi integracji SD z zasobami Zakładu Ubezpieczeń Społecznych, w tym:</xsl:when>
			<xsl:when test="$row_name = 'D.2_6.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'D.2_6.2'">- niepowodzenia</xsl:when>
			<xsl:when test="$row_name = 'D.2_7'">Wygenerowane usługi integracji SD z zasobami Krajowego Rejestru Sądowego (KRS), w tym:</xsl:when>
			<xsl:when test="$row_name = 'D.2_7.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'D.2_7.2'">- niepowodzenia</xsl:when>
			<xsl:when test="$row_name = 'D.2_8'">Wygenerowane usługi integracji SD z zasobami Centralnej Ewidencji Pojazdów i Kierowców (CEPiK), w zakresie Centralnej Ewidencji Kierowców, w tym:</xsl:when>
			<xsl:when test="$row_name = 'D.2_8.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'D.2_8.2'">- niepowodzenia</xsl:when>
			<xsl:when test="$row_name = 'D.2_9'">Wygenerowane usługi integracji SD z Centralną Bazą Beneficjentów w zakresie zasilania i udostępniania danych, w tym:</xsl:when>
			<xsl:when test="$row_name = 'D.2_9.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'D.2_9.2'">- niepowodzenia</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Wydatki-i-liczby-kw-narast-header">
		<xsl:param name="descrwidth" select="31"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(round((100-number($descrwidth)-3) div 2))"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 3))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="2">Lp.</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					Kwoty narastająco od początku roku w zł
				</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					Liczba świadczeń narastająco od początku roku
				</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy miesiąc kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>dwa miesiące kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>trzy miesiące kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy miesiąc kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>dwa miesiące kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>trzy miesiące kwartału</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
				<td class="tab_col_no">6</td>
				<td class="tab_col_no">7</td>
				<td class="tab_col_no">8</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-narast-header">
		<xsl:param name="remark"/>
		<xsl:param name="grouphdr" select="'Kwoty narastająco od początku roku w zł'"/>
		<xsl:call-template name="Kwoty-kw-header">
			<xsl:with-param name="remark" select="$remark"/>
			<xsl:with-param name="grouphdr" select="$grouphdr"/>
			<xsl:with-param name="opisKol1" select="'pierwszy miesiąc kwartału'"/>
			<xsl:with-param name="opisKol2" select="'dwa miesiące kwartału'"/>
			<xsl:with-param name="opisKol3" select="'trzy miesiące kwartału'"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-nienarast-header">
		<xsl:param name="remark"/>
		<xsl:param name="grouphdr" select="'Wykonanie miesięczne'"/>
		<xsl:call-template name="Kwoty-kw-header">
			<xsl:with-param name="remark" select="$remark"/>
			<xsl:with-param name="grouphdr" select="$grouphdr"/>
			<xsl:with-param name="opisKol1" select="'pierwszy miesiąc kwartału'"/>
			<xsl:with-param name="opisKol2" select="'drugi miesiąc kwartału'"/>
			<xsl:with-param name="opisKol3" select="'trzeci miesiąc kwartału'"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-header">
		<xsl:param name="remark"/>
		<xsl:param name="grouphdr"/>
		<xsl:param name="opisKol1"/>
		<xsl:param name="opisKol2"/>
		<xsl:param name="opisKol3"/>
		<xsl:param name="descrwidth" select="64"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(100-number($descrwidth)-3)"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 3))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="2">L.p.</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr"/>
					<xsl:if test="$remark">
						<sup>
							<xsl:value-of select="$remark"/>
						</sup>
					</xsl:if>
				</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>
					<xsl:value-of select="$opisKol1"/>
				</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>
					<xsl:value-of select="$opisKol2"/>
				</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>
					<xsl:value-of select="$opisKol3"/>
				</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Dzialania-header">
		<xsl:param name="descrwidth" select="42"/>
		<xsl:param name="single">
			<xsl:value-of select="string(round((100-number($descrwidth)-3) div 5))"/>
		</xsl:param>
		<xsl:param name="double">
			<xsl:value-of select="string(number($single) * 2)"/>
		</xsl:param>
		<xsl:param name="triple">
			<xsl:value-of select="string(number($single) * 3)"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="2">Lp.</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					Liczba (miesięcznie)
				</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($double,'%')"/></xsl:attribute>Liczba podjętych działań, które w danym kwartale doprowadziły do wzrostu ściągalności należności wymienionych w art. 28 ust.1 pkt 1-4 ustawy<sup>1)</sup>
				</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy miesiąc kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>drugi miesiąc kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>trzeci miesiąc kwartału</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
				<td class="tab_col_no">6</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka-tabeli">
		<xsl:param name="remark1"/>
		<xsl:param name="remark2"/>
		<table class="bottom_table" cellspacing="0" cellpadding="0">
			<xsl:if test="$remark1">
				<xsl:call-template name="Stopka-tabeli-wiersz">
					<xsl:with-param name="numer" select="'1'"/>
					<xsl:with-param name="opis" select="$remark1"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$remark2">
				<xsl:call-template name="Stopka-tabeli-wiersz">
					<xsl:with-param name="numer" select="'2'"/>
					<xsl:with-param name="opis" select="$remark2"/>
				</xsl:call-template>
			</xsl:if>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka-tabeli-wiersz">
		<xsl:param name="numer"/>
		<xsl:param name="opis"/>
		<tr>
			<td class="stars" valign="top">
				<xsl:value-of select="$numer"/>)
			</td>
			<td class="remark">
				<xsl:value-of select="$opis"/>
			</td>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Narast-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/>
		<xsl:param name="format"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Dwa-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Trzy-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Narast-body">
		<tbody>
			<xsl:for-each select="*">
				<tr>
					<xsl:variable name="formatKomorki">
						<xsl:choose>
							<xsl:when test="name() = 'B_2' or name() = 'B_2.1' or name() = 'B_2.1.1' or name() = 'B_2.2'">
								<xsl:value-of select="$obsada"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$kwota"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:call-template name="Row-description"/>
					<xsl:call-template name="Narast-content">
						<xsl:with-param name="skladniki" select="@Składniki"/>
						<xsl:with-param name="format" select="$formatKomorki"/>
					</xsl:call-template>
				</tr>
			</xsl:for-each>
		</tbody>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Nienarast-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="format"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Drugi-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Trzeci-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Nienarast-body">
		<tbody>
			<xsl:for-each select="*">
				<tr>
					<xsl:call-template name="Row-description"/>
					<xsl:call-template name="Nienarast-content">
						<xsl:with-param name="skladniki" select="@Składniki"/>
						<xsl:with-param name="format" select="$kwota"/>
					</xsl:call-template>
				</tr>
			</xsl:for-each>
		</tbody>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Dzialania-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="format"/>
		<xsl:call-template name="Nienarast-content">
			<xsl:with-param name="subtree" select="'Podjęte'"/>
			<xsl:with-param name="skladniki" select="@Składniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Skuteczne'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Dzialania-body">
		<tbody>
			<xsl:for-each select="*">
				<tr>
					<xsl:call-template name="Row-description"/>
					<xsl:call-template name="Dzialania-content">
						<xsl:with-param name="skladniki" select="@Składniki"/>
						<xsl:with-param name="format" select="$kwota"/>
					</xsl:call-template>
				</tr>
			</xsl:for-each>
		</tbody>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczby-content">
		<xsl:param name="skladniki"/>
		<xsl:call-template name="Narast-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Wydatki-narastająco'"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
		<xsl:call-template name="Narast-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Liczba-świadczeń'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczby-body">
		<tbody>
			<xsl:for-each select="*">
				<tr>
					<xsl:call-template name="Row-description"/>
					<xsl:call-template name="Wydatki-i-liczby-content">
						<xsl:with-param name="skladniki" select="@Składniki"/>
						<xsl:with-param name="format" select="$kwota"/>
					</xsl:call-template>
				</tr>
			</xsl:for-each>
		</tbody>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_A.1">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Wydatki-i-liczby-kw-narast-header"/>
			<xsl:call-template name="Wydatki-i-liczby-body"/>
		</table>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy ustawy z dnia 7 września 2007 r. o pomocy osobom uprawnionym do alimentów (Dz.U. z 2020 r. poz. 808 z późn. zm.).'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_A.2">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Wydatki-i-liczby-kw-narast-header"/>
			<xsl:call-template name="Wydatki-i-liczby-body"/>
		</table>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy ustawy z dnia 7 września 2007 r. o pomocy osobom uprawnionym do alimentów.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_B">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwoty-kw-narast-header">
				<xsl:with-param name="remark" select="'1)'"/>
			</xsl:call-template>
			<xsl:call-template name="Narast-body"/>
		</table>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Zasada narastania nie dotyczy wiersza 1.'"/>
			<xsl:with-param name="remark2" select="'Dotyczy ustawy z dnia 7 września 2007 r. o pomocy osobom uprawnionym do alimentów.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_C.1">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwoty-kw-narast-header">
				<xsl:with-param name="remark" select="'1)'"/>
			</xsl:call-template>
			<xsl:call-template name="Narast-body"/>
		</table>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Zasada narastania nie dotyczy wiersza 1.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_C.2">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwoty-kw-narast-header"/>
			<xsl:call-template name="Narast-body"/>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_D.1">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwoty-kw-nienarast-header"/>
			<xsl:call-template name="Nienarast-body"/>
		</table>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy ustawy z dnia 7 września 2007 r. o pomocy osobom uprawnionym do alimentów.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_D.2">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwoty-kw-nienarast-header"/>
			<xsl:call-template name="Nienarast-body"/>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_E">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwoty-kw-nienarast-header"/>
			<xsl:call-template name="Nienarast-body"/>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_F">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Dzialania-header"/>
			<xsl:call-template name="Dzialania-body"/>
		</table>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy ustawy z dnia 7 września 2007 r. o pomocy osobom uprawnionym do alimentów.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
