package pl.topteam.arisco.dom.dao_gen;

import static org.apache.ibatis.jdbc.SqlBuilder.BEGIN;
import static org.apache.ibatis.jdbc.SqlBuilder.DELETE_FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.FROM;
import static org.apache.ibatis.jdbc.SqlBuilder.INSERT_INTO;
import static org.apache.ibatis.jdbc.SqlBuilder.ORDER_BY;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT;
import static org.apache.ibatis.jdbc.SqlBuilder.SELECT_DISTINCT;
import static org.apache.ibatis.jdbc.SqlBuilder.SET;
import static org.apache.ibatis.jdbc.SqlBuilder.SQL;
import static org.apache.ibatis.jdbc.SqlBuilder.UPDATE;
import static org.apache.ibatis.jdbc.SqlBuilder.VALUES;
import static org.apache.ibatis.jdbc.SqlBuilder.WHERE;

import java.util.List;
import java.util.Map;
import pl.topteam.arisco.dom.model.KaDaneOsobowe;
import pl.topteam.arisco.dom.model_gen.KaDaneOsoboweCriteria.Criteria;
import pl.topteam.arisco.dom.model_gen.KaDaneOsoboweCriteria.Criterion;
import pl.topteam.arisco.dom.model.KaDaneOsoboweCriteria;

public class KaDaneOsoboweSqlProvider {

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String countByExample(KaDaneOsoboweCriteria example) {
        BEGIN();
        SELECT("count(*)");
        FROM("KA_DANE_OSOBOWE");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String deleteByExample(KaDaneOsoboweCriteria example) {
        BEGIN();
        DELETE_FROM("KA_DANE_OSOBOWE");
        applyWhere(example, false);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String insertSelective(KaDaneOsobowe record) {
        BEGIN();
        INSERT_INTO("KA_DANE_OSOBOWE");
        
        if (record.getIdOsoby() != null) {
            VALUES("ID_OSOBY", "#{idOsoby,jdbcType=INTEGER}");
        }
        
        if (record.getNazwisko() != null) {
            VALUES("NAZWISKO", "#{nazwisko,jdbcType=VARCHAR}");
        }
        
        if (record.getImie1() != null) {
            VALUES("IMIE_1", "#{imie1,jdbcType=VARCHAR}");
        }
        
        if (record.getImie2() != null) {
            VALUES("IMIE_2", "#{imie2,jdbcType=VARCHAR}");
        }
        
        if (record.getNazRod() != null) {
            VALUES("NAZ_ROD", "#{nazRod,jdbcType=VARCHAR}");
        }
        
        if (record.getPlec() != null) {
            VALUES("PLEC", "#{plec,jdbcType=VARCHAR}");
        }
        
        if (record.getoStwo() != null) {
            VALUES("O_STWO", "#{oStwo,jdbcType=VARCHAR}");
        }
        
        if (record.getStatus() != null) {
            VALUES("STATUS", "#{status,jdbcType=CHAR}");
        }
        
        if (record.getPesel() != null) {
            VALUES("PESEL", "#{pesel,jdbcType=VARCHAR}");
        }
        
        if (record.getNip() != null) {
            VALUES("NIP", "#{nip,jdbcType=VARCHAR}");
        }
        
        if (record.getImieOjca() != null) {
            VALUES("IMIE_OJCA", "#{imieOjca,jdbcType=VARCHAR}");
        }
        
        if (record.getImieMatki() != null) {
            VALUES("IMIE_MATKI", "#{imieMatki,jdbcType=VARCHAR}");
        }
        
        if (record.getNazRodMat() != null) {
            VALUES("NAZ_ROD_MAT", "#{nazRodMat,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejUrodz() != null) {
            VALUES("MIEJ_URODZ", "#{miejUrodz,jdbcType=VARCHAR}");
        }
        
        if (record.getNrEwid() != null) {
            VALUES("NR_EWID", "#{nrEwid,jdbcType=INTEGER}");
        }
        
        if (record.getdUrodz() != null) {
            VALUES("D_URODZ", "#{dUrodz,jdbcType=DATE}");
        }
        
        if (record.getDataWpisu() != null) {
            VALUES("DATA_WPISU", "#{dataWpisu,jdbcType=DATE}");
        }
        
        if (record.getGrupaInw() != null) {
            VALUES("GRUPA_INW", "#{grupaInw,jdbcType=CHAR}");
        }
        
        if (record.getGrupa() != null) {
            VALUES("GRUPA", "#{grupa,jdbcType=INTEGER}");
        }
        
        if (record.getKasaCh() != null) {
            VALUES("KASA_CH", "#{kasaCh,jdbcType=INTEGER}");
        }
        
        if (record.getDowOsob() != null) {
            VALUES("DOW_OSOB", "#{dowOsob,jdbcType=CHAR}");
        }
        
        if (record.getDowWydPrzez() != null) {
            VALUES("DOW_WYD_PRZEZ", "#{dowWydPrzez,jdbcType=VARCHAR}");
        }
        
        if (record.getDowDataWyd() != null) {
            VALUES("DOW_DATA_WYD", "#{dowDataWyd,jdbcType=DATE}");
        }
        
        if (record.getStanCywilny() != null) {
            VALUES("STAN_CYWILNY", "#{stanCywilny,jdbcType=VARCHAR}");
        }
        
        if (record.getWspolmalzonek() != null) {
            VALUES("WSPOLMALZONEK", "#{wspolmalzonek,jdbcType=VARCHAR}");
        }
        
        if (record.getOddzial() != null) {
            VALUES("ODDZIAL", "#{oddzial,jdbcType=INTEGER}");
        }
        
        if (record.getOpiekun() != null) {
            VALUES("OPIEKUN", "#{opiekun,jdbcType=INTEGER}");
        }
        
        if (record.getUtworzyl() != null) {
            VALUES("UTWORZYL", "#{utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            VALUES("POPRAWIL", "#{poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getNaZasadach() != null) {
            VALUES("NA_ZASADACH", "#{naZasadach,jdbcType=CHAR}");
        }
        
        if (record.getZdjecie() != null) {
            VALUES("ZDJECIE", "#{zdjecie,jdbcType=OTHER}");
        }
        
        if (record.getNieOdsetki() != null) {
            VALUES("NIE_ODSETKI", "#{nieOdsetki,jdbcType=CHAR}");
        }
        
        if (record.getOddzialZus() != null) {
            VALUES("ODDZIAL_ZUS", "#{oddzialZus,jdbcType=INTEGER}");
        }
        
        if (record.getNrLegUb() != null) {
            VALUES("NR_LEG_UB", "#{nrLegUb,jdbcType=VARCHAR}");
        }
        
        if (record.getWyksztalcenie() != null) {
            VALUES("WYKSZTALCENIE", "#{wyksztalcenie,jdbcType=INTEGER}");
        }
        
        if (record.getWyznanie() != null) {
            VALUES("WYZNANIE", "#{wyznanie,jdbcType=INTEGER}");
        }
        
        if (record.getAdresUlica() != null) {
            VALUES("ADRES_ULICA", "#{adresUlica,jdbcType=VARCHAR}");
        }
        
        if (record.getAdresMiejsc() != null) {
            VALUES("ADRES_MIEJSC", "#{adresMiejsc,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzSchorz() != null) {
            VALUES("RODZ_SCHORZ", "#{rodzSchorz,jdbcType=INTEGER}");
        }
        
        if (record.getProfildomu() != null) {
            VALUES("PROFILDOMU", "#{profildomu,jdbcType=INTEGER}");
        }
        
        if (record.getNrKontaBank() != null) {
            VALUES("NR_KONTA_BANK", "#{nrKontaBank,jdbcType=VARCHAR}");
        }
        
        if (record.getPerson() != null) {
            VALUES("PERSON", "#{person,jdbcType=VARCHAR}");
        }
        
        if (record.getDieta() != null) {
            VALUES("DIETA", "#{dieta,jdbcType=INTEGER}");
        }
        
        if (record.getSchorzenie2() != null) {
            VALUES("SCHORZENIE2", "#{schorzenie2,jdbcType=INTEGER}");
        }
        
        if (record.getSchorzenie3() != null) {
            VALUES("SCHORZENIE3", "#{schorzenie3,jdbcType=INTEGER}");
        }
        
        if (record.getNiePodatek() != null) {
            VALUES("NIE_PODATEK", "#{niePodatek,jdbcType=CHAR}");
        }
        
        if (record.getDowTerminWaz() != null) {
            VALUES("DOW_TERMIN_WAZ", "#{dowTerminWaz,jdbcType=DATE}");
        }
        
        if (record.getIdFilia() != null) {
            VALUES("ID_FILIA", "#{idFilia,jdbcType=INTEGER}");
        }
        
        if (record.getNrswiadzus() != null) {
            VALUES("NRSWIADZUS", "#{nrswiadzus,jdbcType=VARCHAR}");
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String selectByExample(KaDaneOsoboweCriteria example) {
        BEGIN();
        if (example != null && example.isDistinct()) {
            SELECT_DISTINCT("ID_UNIK");
        } else {
            SELECT("ID_UNIK");
        }
        SELECT("ID_OSOBY");
        SELECT("NAZWISKO");
        SELECT("IMIE_1");
        SELECT("IMIE_2");
        SELECT("NAZ_ROD");
        SELECT("PLEC");
        SELECT("O_STWO");
        SELECT("STATUS");
        SELECT("PESEL");
        SELECT("NIP");
        SELECT("IMIE_OJCA");
        SELECT("IMIE_MATKI");
        SELECT("NAZ_ROD_MAT");
        SELECT("MIEJ_URODZ");
        SELECT("NR_EWID");
        SELECT("D_URODZ");
        SELECT("DATA_WPISU");
        SELECT("GRUPA_INW");
        SELECT("GRUPA");
        SELECT("KASA_CH");
        SELECT("DOW_OSOB");
        SELECT("DOW_WYD_PRZEZ");
        SELECT("DOW_DATA_WYD");
        SELECT("STAN_CYWILNY");
        SELECT("WSPOLMALZONEK");
        SELECT("ODDZIAL");
        SELECT("OPIEKUN");
        SELECT("UTWORZYL");
        SELECT("POPRAWIL");
        SELECT("NA_ZASADACH");
        SELECT("ZDJECIE");
        SELECT("NIE_ODSETKI");
        SELECT("ODDZIAL_ZUS");
        SELECT("NR_LEG_UB");
        SELECT("WYKSZTALCENIE");
        SELECT("WYZNANIE");
        SELECT("ADRES_ULICA");
        SELECT("ADRES_MIEJSC");
        SELECT("RODZ_SCHORZ");
        SELECT("PROFILDOMU");
        SELECT("NR_KONTA_BANK");
        SELECT("PERSON");
        SELECT("DIETA");
        SELECT("SCHORZENIE2");
        SELECT("SCHORZENIE3");
        SELECT("NIE_PODATEK");
        SELECT("DOW_TERMIN_WAZ");
        SELECT("ID_FILIA");
        SELECT("NRSWIADZUS");
        FROM("KA_DANE_OSOBOWE");
        applyWhere(example, false);
        
        if (example != null && example.getOrderByClause() != null) {
            ORDER_BY(example.getOrderByClause());
        }
        
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExampleSelective(Map<String, Object> parameter) {
        KaDaneOsobowe record = (KaDaneOsobowe) parameter.get("record");
        KaDaneOsoboweCriteria example = (KaDaneOsoboweCriteria) parameter.get("example");
        
        BEGIN();
        UPDATE("KA_DANE_OSOBOWE");
        
        if (record.getIdUnik() != null) {
            SET("ID_UNIK = #{record.idUnik,jdbcType=INTEGER}");
        }
        
        if (record.getIdOsoby() != null) {
            SET("ID_OSOBY = #{record.idOsoby,jdbcType=INTEGER}");
        }
        
        if (record.getNazwisko() != null) {
            SET("NAZWISKO = #{record.nazwisko,jdbcType=VARCHAR}");
        }
        
        if (record.getImie1() != null) {
            SET("IMIE_1 = #{record.imie1,jdbcType=VARCHAR}");
        }
        
        if (record.getImie2() != null) {
            SET("IMIE_2 = #{record.imie2,jdbcType=VARCHAR}");
        }
        
        if (record.getNazRod() != null) {
            SET("NAZ_ROD = #{record.nazRod,jdbcType=VARCHAR}");
        }
        
        if (record.getPlec() != null) {
            SET("PLEC = #{record.plec,jdbcType=VARCHAR}");
        }
        
        if (record.getoStwo() != null) {
            SET("O_STWO = #{record.oStwo,jdbcType=VARCHAR}");
        }
        
        if (record.getStatus() != null) {
            SET("STATUS = #{record.status,jdbcType=CHAR}");
        }
        
        if (record.getPesel() != null) {
            SET("PESEL = #{record.pesel,jdbcType=VARCHAR}");
        }
        
        if (record.getNip() != null) {
            SET("NIP = #{record.nip,jdbcType=VARCHAR}");
        }
        
        if (record.getImieOjca() != null) {
            SET("IMIE_OJCA = #{record.imieOjca,jdbcType=VARCHAR}");
        }
        
        if (record.getImieMatki() != null) {
            SET("IMIE_MATKI = #{record.imieMatki,jdbcType=VARCHAR}");
        }
        
        if (record.getNazRodMat() != null) {
            SET("NAZ_ROD_MAT = #{record.nazRodMat,jdbcType=VARCHAR}");
        }
        
        if (record.getMiejUrodz() != null) {
            SET("MIEJ_URODZ = #{record.miejUrodz,jdbcType=VARCHAR}");
        }
        
        if (record.getNrEwid() != null) {
            SET("NR_EWID = #{record.nrEwid,jdbcType=INTEGER}");
        }
        
        if (record.getdUrodz() != null) {
            SET("D_URODZ = #{record.dUrodz,jdbcType=DATE}");
        }
        
        if (record.getDataWpisu() != null) {
            SET("DATA_WPISU = #{record.dataWpisu,jdbcType=DATE}");
        }
        
        if (record.getGrupaInw() != null) {
            SET("GRUPA_INW = #{record.grupaInw,jdbcType=CHAR}");
        }
        
        if (record.getGrupa() != null) {
            SET("GRUPA = #{record.grupa,jdbcType=INTEGER}");
        }
        
        if (record.getKasaCh() != null) {
            SET("KASA_CH = #{record.kasaCh,jdbcType=INTEGER}");
        }
        
        if (record.getDowOsob() != null) {
            SET("DOW_OSOB = #{record.dowOsob,jdbcType=CHAR}");
        }
        
        if (record.getDowWydPrzez() != null) {
            SET("DOW_WYD_PRZEZ = #{record.dowWydPrzez,jdbcType=VARCHAR}");
        }
        
        if (record.getDowDataWyd() != null) {
            SET("DOW_DATA_WYD = #{record.dowDataWyd,jdbcType=DATE}");
        }
        
        if (record.getStanCywilny() != null) {
            SET("STAN_CYWILNY = #{record.stanCywilny,jdbcType=VARCHAR}");
        }
        
        if (record.getWspolmalzonek() != null) {
            SET("WSPOLMALZONEK = #{record.wspolmalzonek,jdbcType=VARCHAR}");
        }
        
        if (record.getOddzial() != null) {
            SET("ODDZIAL = #{record.oddzial,jdbcType=INTEGER}");
        }
        
        if (record.getOpiekun() != null) {
            SET("OPIEKUN = #{record.opiekun,jdbcType=INTEGER}");
        }
        
        if (record.getUtworzyl() != null) {
            SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        }
        
        if (record.getPoprawil() != null) {
            SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        }
        
        if (record.getNaZasadach() != null) {
            SET("NA_ZASADACH = #{record.naZasadach,jdbcType=CHAR}");
        }
        
        if (record.getZdjecie() != null) {
            SET("ZDJECIE = #{record.zdjecie,jdbcType=OTHER}");
        }
        
        if (record.getNieOdsetki() != null) {
            SET("NIE_ODSETKI = #{record.nieOdsetki,jdbcType=CHAR}");
        }
        
        if (record.getOddzialZus() != null) {
            SET("ODDZIAL_ZUS = #{record.oddzialZus,jdbcType=INTEGER}");
        }
        
        if (record.getNrLegUb() != null) {
            SET("NR_LEG_UB = #{record.nrLegUb,jdbcType=VARCHAR}");
        }
        
        if (record.getWyksztalcenie() != null) {
            SET("WYKSZTALCENIE = #{record.wyksztalcenie,jdbcType=INTEGER}");
        }
        
        if (record.getWyznanie() != null) {
            SET("WYZNANIE = #{record.wyznanie,jdbcType=INTEGER}");
        }
        
        if (record.getAdresUlica() != null) {
            SET("ADRES_ULICA = #{record.adresUlica,jdbcType=VARCHAR}");
        }
        
        if (record.getAdresMiejsc() != null) {
            SET("ADRES_MIEJSC = #{record.adresMiejsc,jdbcType=VARCHAR}");
        }
        
        if (record.getRodzSchorz() != null) {
            SET("RODZ_SCHORZ = #{record.rodzSchorz,jdbcType=INTEGER}");
        }
        
        if (record.getProfildomu() != null) {
            SET("PROFILDOMU = #{record.profildomu,jdbcType=INTEGER}");
        }
        
        if (record.getNrKontaBank() != null) {
            SET("NR_KONTA_BANK = #{record.nrKontaBank,jdbcType=VARCHAR}");
        }
        
        if (record.getPerson() != null) {
            SET("PERSON = #{record.person,jdbcType=VARCHAR}");
        }
        
        if (record.getDieta() != null) {
            SET("DIETA = #{record.dieta,jdbcType=INTEGER}");
        }
        
        if (record.getSchorzenie2() != null) {
            SET("SCHORZENIE2 = #{record.schorzenie2,jdbcType=INTEGER}");
        }
        
        if (record.getSchorzenie3() != null) {
            SET("SCHORZENIE3 = #{record.schorzenie3,jdbcType=INTEGER}");
        }
        
        if (record.getNiePodatek() != null) {
            SET("NIE_PODATEK = #{record.niePodatek,jdbcType=CHAR}");
        }
        
        if (record.getDowTerminWaz() != null) {
            SET("DOW_TERMIN_WAZ = #{record.dowTerminWaz,jdbcType=DATE}");
        }
        
        if (record.getIdFilia() != null) {
            SET("ID_FILIA = #{record.idFilia,jdbcType=INTEGER}");
        }
        
        if (record.getNrswiadzus() != null) {
            SET("NRSWIADZUS = #{record.nrswiadzus,jdbcType=VARCHAR}");
        }
        
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    public String updateByExample(Map<String, Object> parameter) {
        BEGIN();
        UPDATE("KA_DANE_OSOBOWE");
        
        SET("ID_UNIK = #{record.idUnik,jdbcType=INTEGER}");
        SET("ID_OSOBY = #{record.idOsoby,jdbcType=INTEGER}");
        SET("NAZWISKO = #{record.nazwisko,jdbcType=VARCHAR}");
        SET("IMIE_1 = #{record.imie1,jdbcType=VARCHAR}");
        SET("IMIE_2 = #{record.imie2,jdbcType=VARCHAR}");
        SET("NAZ_ROD = #{record.nazRod,jdbcType=VARCHAR}");
        SET("PLEC = #{record.plec,jdbcType=VARCHAR}");
        SET("O_STWO = #{record.oStwo,jdbcType=VARCHAR}");
        SET("STATUS = #{record.status,jdbcType=CHAR}");
        SET("PESEL = #{record.pesel,jdbcType=VARCHAR}");
        SET("NIP = #{record.nip,jdbcType=VARCHAR}");
        SET("IMIE_OJCA = #{record.imieOjca,jdbcType=VARCHAR}");
        SET("IMIE_MATKI = #{record.imieMatki,jdbcType=VARCHAR}");
        SET("NAZ_ROD_MAT = #{record.nazRodMat,jdbcType=VARCHAR}");
        SET("MIEJ_URODZ = #{record.miejUrodz,jdbcType=VARCHAR}");
        SET("NR_EWID = #{record.nrEwid,jdbcType=INTEGER}");
        SET("D_URODZ = #{record.dUrodz,jdbcType=DATE}");
        SET("DATA_WPISU = #{record.dataWpisu,jdbcType=DATE}");
        SET("GRUPA_INW = #{record.grupaInw,jdbcType=CHAR}");
        SET("GRUPA = #{record.grupa,jdbcType=INTEGER}");
        SET("KASA_CH = #{record.kasaCh,jdbcType=INTEGER}");
        SET("DOW_OSOB = #{record.dowOsob,jdbcType=CHAR}");
        SET("DOW_WYD_PRZEZ = #{record.dowWydPrzez,jdbcType=VARCHAR}");
        SET("DOW_DATA_WYD = #{record.dowDataWyd,jdbcType=DATE}");
        SET("STAN_CYWILNY = #{record.stanCywilny,jdbcType=VARCHAR}");
        SET("WSPOLMALZONEK = #{record.wspolmalzonek,jdbcType=VARCHAR}");
        SET("ODDZIAL = #{record.oddzial,jdbcType=INTEGER}");
        SET("OPIEKUN = #{record.opiekun,jdbcType=INTEGER}");
        SET("UTWORZYL = #{record.utworzyl,jdbcType=VARCHAR}");
        SET("POPRAWIL = #{record.poprawil,jdbcType=VARCHAR}");
        SET("NA_ZASADACH = #{record.naZasadach,jdbcType=CHAR}");
        SET("ZDJECIE = #{record.zdjecie,jdbcType=OTHER}");
        SET("NIE_ODSETKI = #{record.nieOdsetki,jdbcType=CHAR}");
        SET("ODDZIAL_ZUS = #{record.oddzialZus,jdbcType=INTEGER}");
        SET("NR_LEG_UB = #{record.nrLegUb,jdbcType=VARCHAR}");
        SET("WYKSZTALCENIE = #{record.wyksztalcenie,jdbcType=INTEGER}");
        SET("WYZNANIE = #{record.wyznanie,jdbcType=INTEGER}");
        SET("ADRES_ULICA = #{record.adresUlica,jdbcType=VARCHAR}");
        SET("ADRES_MIEJSC = #{record.adresMiejsc,jdbcType=VARCHAR}");
        SET("RODZ_SCHORZ = #{record.rodzSchorz,jdbcType=INTEGER}");
        SET("PROFILDOMU = #{record.profildomu,jdbcType=INTEGER}");
        SET("NR_KONTA_BANK = #{record.nrKontaBank,jdbcType=VARCHAR}");
        SET("PERSON = #{record.person,jdbcType=VARCHAR}");
        SET("DIETA = #{record.dieta,jdbcType=INTEGER}");
        SET("SCHORZENIE2 = #{record.schorzenie2,jdbcType=INTEGER}");
        SET("SCHORZENIE3 = #{record.schorzenie3,jdbcType=INTEGER}");
        SET("NIE_PODATEK = #{record.niePodatek,jdbcType=CHAR}");
        SET("DOW_TERMIN_WAZ = #{record.dowTerminWaz,jdbcType=DATE}");
        SET("ID_FILIA = #{record.idFilia,jdbcType=INTEGER}");
        SET("NRSWIADZUS = #{record.nrswiadzus,jdbcType=VARCHAR}");
        
        KaDaneOsoboweCriteria example = (KaDaneOsoboweCriteria) parameter.get("example");
        applyWhere(example, true);
        return SQL();
    }

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
	@SuppressWarnings("deprecation")
    protected void applyWhere(KaDaneOsoboweCriteria example, boolean includeExamplePhrase) {
        if (example == null) {
            return;
        }
        
        String parmPhrase1;
        String parmPhrase1_th;
        String parmPhrase2;
        String parmPhrase2_th;
        String parmPhrase3;
        String parmPhrase3_th;
        if (includeExamplePhrase) {
            parmPhrase1 = "%s #{example.oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{example.oredCriteria[%d].allCriteria[%d].value} and #{example.oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{example.oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{example.oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{example.oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{example.oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        } else {
            parmPhrase1 = "%s #{oredCriteria[%d].allCriteria[%d].value}";
            parmPhrase1_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s}";
            parmPhrase2 = "%s #{oredCriteria[%d].allCriteria[%d].value} and #{oredCriteria[%d].criteria[%d].secondValue}";
            parmPhrase2_th = "%s #{oredCriteria[%d].allCriteria[%d].value,typeHandler=%s} and #{oredCriteria[%d].criteria[%d].secondValue,typeHandler=%s}";
            parmPhrase3 = "#{oredCriteria[%d].allCriteria[%d].value[%d]}";
            parmPhrase3_th = "#{oredCriteria[%d].allCriteria[%d].value[%d],typeHandler=%s}";
        }
        
        StringBuilder sb = new StringBuilder();
        List<Criteria> oredCriteria = example.getOredCriteria();
        boolean firstCriteria = true;
        for (int i = 0; i < oredCriteria.size(); i++) {
            Criteria criteria = oredCriteria.get(i);
            if (criteria.isValid()) {
                if (firstCriteria) {
                    firstCriteria = false;
                } else {
                    sb.append(" or ");
                }
                
                sb.append('(');
                List<Criterion> criterions = criteria.getAllCriteria();
                boolean firstCriterion = true;
                for (int j = 0; j < criterions.size(); j++) {
                    Criterion criterion = criterions.get(j);
                    if (firstCriterion) {
                        firstCriterion = false;
                    } else {
                        sb.append(" and ");
                    }
                    
                    if (criterion.isNoValue()) {
                        sb.append(criterion.getCondition());
                    } else if (criterion.isSingleValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase1, criterion.getCondition(), i, j));
                        } else {
                            sb.append(String.format(parmPhrase1_th, criterion.getCondition(), i, j,criterion.getTypeHandler()));
                        }
                    } else if (criterion.isBetweenValue()) {
                        if (criterion.getTypeHandler() == null) {
                            sb.append(String.format(parmPhrase2, criterion.getCondition(), i, j, i, j));
                        } else {
                            sb.append(String.format(parmPhrase2_th, criterion.getCondition(), i, j, criterion.getTypeHandler(), i, j, criterion.getTypeHandler()));
                        }
                    } else if (criterion.isListValue()) {
                        sb.append(criterion.getCondition());
                        sb.append(" (");
                        List<?> listItems = (List<?>) criterion.getValue();
                        boolean comma = false;
                        for (int k = 0; k < listItems.size(); k++) {
                            if (comma) {
                                sb.append(", ");
                            } else {
                                comma = true;
                            }
                            if (criterion.getTypeHandler() == null) {
                                sb.append(String.format(parmPhrase3, i, j, k));
                            } else {
                                sb.append(String.format(parmPhrase3_th, i, j, k, criterion.getTypeHandler()));
                            }
                        }
                        sb.append(')');
                    }
                }
                sb.append(')');
            }
        }
        
        if (sb.length() > 0) {
            WHERE(sb.toString());
        }
    }
}