package pl.topteam.arisco.dom.dao_gen;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import pl.topteam.arisco.dom.model.KaRodzina;
import pl.topteam.arisco.dom.model.KaRodzinaCriteria;

public abstract interface KaRodzinaMapper {
    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=KaRodzinaSqlProvider.class, method="countByExample")
    int countByExample(KaRodzinaCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @DeleteProvider(type=KaRodzinaSqlProvider.class, method="deleteByExample")
    int deleteByExample(KaRodzinaCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Delete({
        "delete from KA_RODZINA",
        "where IDUNIK = #{idunik,jdbcType=INTEGER}"
    })
    int deleteByPrimaryKey(Integer idunik);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Insert({
        "insert into KA_RODZINA (ID_PRAC, NIP, ",
        "RODZ_DOK, NAZWISKO, ",
        "IMIE_PIERWSZE, KOD_POCZTOWY, ",
        "MIEJSCOWOSC, GMINA, ",
        "ULICA, NR_DOMU, NR_LOKALU, ",
        "NR_TELEFONU, NR_FAKSU, ",
        "OSOBA, DATA_URODZENIA, ",
        "ADRES_NIEZGODNY, POPRAWIL, ",
        "UTWORZYL, MIEJSCE_PR, ",
        "TELEFON_PR, RELACJA, ",
        "WYKSZTALCENIE, PLATNIK, ",
        "OS_KONTAKTU, RODZINA, TYP, ",
        "OPIEK_PRAW, ZMIANA)",
        "values (#{idPrac,jdbcType=INTEGER}, #{nip,jdbcType=VARCHAR}, ",
        "#{rodzDok,jdbcType=CHAR}, #{nazwisko,jdbcType=VARCHAR}, ",
        "#{imiePierwsze,jdbcType=VARCHAR}, #{kodPocztowy,jdbcType=VARCHAR}, ",
        "#{miejscowosc,jdbcType=VARCHAR}, #{gmina,jdbcType=VARCHAR}, ",
        "#{ulica,jdbcType=VARCHAR}, #{nrDomu,jdbcType=VARCHAR}, #{nrLokalu,jdbcType=VARCHAR}, ",
        "#{nrTelefonu,jdbcType=VARCHAR}, #{nrFaksu,jdbcType=VARCHAR}, ",
        "#{osoba,jdbcType=VARCHAR}, #{dataUrodzenia,jdbcType=TIMESTAMP}, ",
        "#{adresNiezgodny,jdbcType=CHAR}, #{poprawil,jdbcType=VARCHAR}, ",
        "#{utworzyl,jdbcType=VARCHAR}, #{miejscePr,jdbcType=VARCHAR}, ",
        "#{telefonPr,jdbcType=VARCHAR}, #{relacja,jdbcType=INTEGER}, ",
        "#{wyksztalcenie,jdbcType=INTEGER}, #{platnik,jdbcType=CHAR}, ",
        "#{osKontaktu,jdbcType=CHAR}, #{rodzina,jdbcType=CHAR}, #{typ,jdbcType=VARCHAR}, ",
        "#{opiekPraw,jdbcType=CHAR}, #{zmiana,jdbcType=TIMESTAMP})"
    })
    @SelectKey(statement="_", keyProperty="idunik", before=false, resultType=Integer.class)
    int insert(KaRodzina record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    int mergeInto(KaRodzina record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @InsertProvider(type=KaRodzinaSqlProvider.class, method="insertSelective")
    @SelectKey(statement="_", keyProperty="idunik", before=false, resultType=Integer.class)
    int insertSelective(KaRodzina record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=KaRodzinaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="IDUNIK", property="idunik", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_PRAC", property="idPrac", jdbcType=JdbcType.INTEGER),
        @Result(column="NIP", property="nip", jdbcType=JdbcType.VARCHAR),
        @Result(column="RODZ_DOK", property="rodzDok", jdbcType=JdbcType.CHAR),
        @Result(column="NAZWISKO", property="nazwisko", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE_PIERWSZE", property="imiePierwsze", jdbcType=JdbcType.VARCHAR),
        @Result(column="KOD_POCZTOWY", property="kodPocztowy", jdbcType=JdbcType.VARCHAR),
        @Result(column="MIEJSCOWOSC", property="miejscowosc", jdbcType=JdbcType.VARCHAR),
        @Result(column="GMINA", property="gmina", jdbcType=JdbcType.VARCHAR),
        @Result(column="ULICA", property="ulica", jdbcType=JdbcType.VARCHAR),
        @Result(column="NR_DOMU", property="nrDomu", jdbcType=JdbcType.VARCHAR),
        @Result(column="NR_LOKALU", property="nrLokalu", jdbcType=JdbcType.VARCHAR),
        @Result(column="NR_TELEFONU", property="nrTelefonu", jdbcType=JdbcType.VARCHAR),
        @Result(column="NR_FAKSU", property="nrFaksu", jdbcType=JdbcType.VARCHAR),
        @Result(column="OSOBA", property="osoba", jdbcType=JdbcType.VARCHAR),
        @Result(column="DATA_URODZENIA", property="dataUrodzenia", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="ADRES_NIEZGODNY", property="adresNiezgodny", jdbcType=JdbcType.CHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="MIEJSCE_PR", property="miejscePr", jdbcType=JdbcType.VARCHAR),
        @Result(column="TELEFON_PR", property="telefonPr", jdbcType=JdbcType.VARCHAR),
        @Result(column="RELACJA", property="relacja", jdbcType=JdbcType.INTEGER),
        @Result(column="WYKSZTALCENIE", property="wyksztalcenie", jdbcType=JdbcType.INTEGER),
        @Result(column="PLATNIK", property="platnik", jdbcType=JdbcType.CHAR),
        @Result(column="OS_KONTAKTU", property="osKontaktu", jdbcType=JdbcType.CHAR),
        @Result(column="RODZINA", property="rodzina", jdbcType=JdbcType.CHAR),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR),
        @Result(column="OPIEK_PRAW", property="opiekPraw", jdbcType=JdbcType.CHAR),
        @Result(column="ZMIANA", property="zmiana", jdbcType=JdbcType.TIMESTAMP)
    })
    List<KaRodzina> selectByExampleWithRowbounds(KaRodzinaCriteria example, RowBounds rowBounds);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @SelectProvider(type=KaRodzinaSqlProvider.class, method="selectByExample")
    @Results({
        @Result(column="IDUNIK", property="idunik", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_PRAC", property="idPrac", jdbcType=JdbcType.INTEGER),
        @Result(column="NIP", property="nip", jdbcType=JdbcType.VARCHAR),
        @Result(column="RODZ_DOK", property="rodzDok", jdbcType=JdbcType.CHAR),
        @Result(column="NAZWISKO", property="nazwisko", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE_PIERWSZE", property="imiePierwsze", jdbcType=JdbcType.VARCHAR),
        @Result(column="KOD_POCZTOWY", property="kodPocztowy", jdbcType=JdbcType.VARCHAR),
        @Result(column="MIEJSCOWOSC", property="miejscowosc", jdbcType=JdbcType.VARCHAR),
        @Result(column="GMINA", property="gmina", jdbcType=JdbcType.VARCHAR),
        @Result(column="ULICA", property="ulica", jdbcType=JdbcType.VARCHAR),
        @Result(column="NR_DOMU", property="nrDomu", jdbcType=JdbcType.VARCHAR),
        @Result(column="NR_LOKALU", property="nrLokalu", jdbcType=JdbcType.VARCHAR),
        @Result(column="NR_TELEFONU", property="nrTelefonu", jdbcType=JdbcType.VARCHAR),
        @Result(column="NR_FAKSU", property="nrFaksu", jdbcType=JdbcType.VARCHAR),
        @Result(column="OSOBA", property="osoba", jdbcType=JdbcType.VARCHAR),
        @Result(column="DATA_URODZENIA", property="dataUrodzenia", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="ADRES_NIEZGODNY", property="adresNiezgodny", jdbcType=JdbcType.CHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="MIEJSCE_PR", property="miejscePr", jdbcType=JdbcType.VARCHAR),
        @Result(column="TELEFON_PR", property="telefonPr", jdbcType=JdbcType.VARCHAR),
        @Result(column="RELACJA", property="relacja", jdbcType=JdbcType.INTEGER),
        @Result(column="WYKSZTALCENIE", property="wyksztalcenie", jdbcType=JdbcType.INTEGER),
        @Result(column="PLATNIK", property="platnik", jdbcType=JdbcType.CHAR),
        @Result(column="OS_KONTAKTU", property="osKontaktu", jdbcType=JdbcType.CHAR),
        @Result(column="RODZINA", property="rodzina", jdbcType=JdbcType.CHAR),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR),
        @Result(column="OPIEK_PRAW", property="opiekPraw", jdbcType=JdbcType.CHAR),
        @Result(column="ZMIANA", property="zmiana", jdbcType=JdbcType.TIMESTAMP)
    })
    List<KaRodzina> selectByExample(KaRodzinaCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Select({
        "select",
        "IDUNIK, ID_PRAC, NIP, RODZ_DOK, NAZWISKO, IMIE_PIERWSZE, KOD_POCZTOWY, MIEJSCOWOSC, ",
        "GMINA, ULICA, NR_DOMU, NR_LOKALU, NR_TELEFONU, NR_FAKSU, OSOBA, DATA_URODZENIA, ",
        "ADRES_NIEZGODNY, POPRAWIL, UTWORZYL, MIEJSCE_PR, TELEFON_PR, RELACJA, WYKSZTALCENIE, ",
        "PLATNIK, OS_KONTAKTU, RODZINA, TYP, OPIEK_PRAW, ZMIANA",
        "from KA_RODZINA",
        "where IDUNIK = #{idunik,jdbcType=INTEGER}"
    })
    @Results({
        @Result(column="IDUNIK", property="idunik", jdbcType=JdbcType.INTEGER, id=true),
        @Result(column="ID_PRAC", property="idPrac", jdbcType=JdbcType.INTEGER),
        @Result(column="NIP", property="nip", jdbcType=JdbcType.VARCHAR),
        @Result(column="RODZ_DOK", property="rodzDok", jdbcType=JdbcType.CHAR),
        @Result(column="NAZWISKO", property="nazwisko", jdbcType=JdbcType.VARCHAR),
        @Result(column="IMIE_PIERWSZE", property="imiePierwsze", jdbcType=JdbcType.VARCHAR),
        @Result(column="KOD_POCZTOWY", property="kodPocztowy", jdbcType=JdbcType.VARCHAR),
        @Result(column="MIEJSCOWOSC", property="miejscowosc", jdbcType=JdbcType.VARCHAR),
        @Result(column="GMINA", property="gmina", jdbcType=JdbcType.VARCHAR),
        @Result(column="ULICA", property="ulica", jdbcType=JdbcType.VARCHAR),
        @Result(column="NR_DOMU", property="nrDomu", jdbcType=JdbcType.VARCHAR),
        @Result(column="NR_LOKALU", property="nrLokalu", jdbcType=JdbcType.VARCHAR),
        @Result(column="NR_TELEFONU", property="nrTelefonu", jdbcType=JdbcType.VARCHAR),
        @Result(column="NR_FAKSU", property="nrFaksu", jdbcType=JdbcType.VARCHAR),
        @Result(column="OSOBA", property="osoba", jdbcType=JdbcType.VARCHAR),
        @Result(column="DATA_URODZENIA", property="dataUrodzenia", jdbcType=JdbcType.TIMESTAMP),
        @Result(column="ADRES_NIEZGODNY", property="adresNiezgodny", jdbcType=JdbcType.CHAR),
        @Result(column="POPRAWIL", property="poprawil", jdbcType=JdbcType.VARCHAR),
        @Result(column="UTWORZYL", property="utworzyl", jdbcType=JdbcType.VARCHAR),
        @Result(column="MIEJSCE_PR", property="miejscePr", jdbcType=JdbcType.VARCHAR),
        @Result(column="TELEFON_PR", property="telefonPr", jdbcType=JdbcType.VARCHAR),
        @Result(column="RELACJA", property="relacja", jdbcType=JdbcType.INTEGER),
        @Result(column="WYKSZTALCENIE", property="wyksztalcenie", jdbcType=JdbcType.INTEGER),
        @Result(column="PLATNIK", property="platnik", jdbcType=JdbcType.CHAR),
        @Result(column="OS_KONTAKTU", property="osKontaktu", jdbcType=JdbcType.CHAR),
        @Result(column="RODZINA", property="rodzina", jdbcType=JdbcType.CHAR),
        @Result(column="TYP", property="typ", jdbcType=JdbcType.VARCHAR),
        @Result(column="OPIEK_PRAW", property="opiekPraw", jdbcType=JdbcType.CHAR),
        @Result(column="ZMIANA", property="zmiana", jdbcType=JdbcType.TIMESTAMP)
    })
    KaRodzina selectByPrimaryKey(Integer idunik);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=KaRodzinaSqlProvider.class, method="updateByExampleSelective")
    int updateByExampleSelective(@Param("record") KaRodzina record, @Param("example") KaRodzinaCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=KaRodzinaSqlProvider.class, method="updateByExample")
    int updateByExample(@Param("record") KaRodzina record, @Param("example") KaRodzinaCriteria example);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @UpdateProvider(type=KaRodzinaSqlProvider.class, method="updateByPrimaryKeySelective")
    int updateByPrimaryKeySelective(KaRodzina record);

    /**
     * @mbggenerated 2013-11-05 11:51:52
     */
    @Update({
        "update KA_RODZINA",
        "set ID_PRAC = #{idPrac,jdbcType=INTEGER},",
          "NIP = #{nip,jdbcType=VARCHAR},",
          "RODZ_DOK = #{rodzDok,jdbcType=CHAR},",
          "NAZWISKO = #{nazwisko,jdbcType=VARCHAR},",
          "IMIE_PIERWSZE = #{imiePierwsze,jdbcType=VARCHAR},",
          "KOD_POCZTOWY = #{kodPocztowy,jdbcType=VARCHAR},",
          "MIEJSCOWOSC = #{miejscowosc,jdbcType=VARCHAR},",
          "GMINA = #{gmina,jdbcType=VARCHAR},",
          "ULICA = #{ulica,jdbcType=VARCHAR},",
          "NR_DOMU = #{nrDomu,jdbcType=VARCHAR},",
          "NR_LOKALU = #{nrLokalu,jdbcType=VARCHAR},",
          "NR_TELEFONU = #{nrTelefonu,jdbcType=VARCHAR},",
          "NR_FAKSU = #{nrFaksu,jdbcType=VARCHAR},",
          "OSOBA = #{osoba,jdbcType=VARCHAR},",
          "DATA_URODZENIA = #{dataUrodzenia,jdbcType=TIMESTAMP},",
          "ADRES_NIEZGODNY = #{adresNiezgodny,jdbcType=CHAR},",
          "POPRAWIL = #{poprawil,jdbcType=VARCHAR},",
          "UTWORZYL = #{utworzyl,jdbcType=VARCHAR},",
          "MIEJSCE_PR = #{miejscePr,jdbcType=VARCHAR},",
          "TELEFON_PR = #{telefonPr,jdbcType=VARCHAR},",
          "RELACJA = #{relacja,jdbcType=INTEGER},",
          "WYKSZTALCENIE = #{wyksztalcenie,jdbcType=INTEGER},",
          "PLATNIK = #{platnik,jdbcType=CHAR},",
          "OS_KONTAKTU = #{osKontaktu,jdbcType=CHAR},",
          "RODZINA = #{rodzina,jdbcType=CHAR},",
          "TYP = #{typ,jdbcType=VARCHAR},",
          "OPIEK_PRAW = #{opiekPraw,jdbcType=CHAR},",
          "ZMIANA = #{zmiana,jdbcType=TIMESTAMP}",
        "where IDUNIK = #{idunik,jdbcType=INTEGER}"
    })
    int updateByPrimaryKey(KaRodzina record);
}